/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.emitter.core.Emitter;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.query.CachingEmitter;
import org.apache.hive.druid.io.druid.query.DefaultQueryMetrics;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryMetrics;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.ListFilteredDimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.joda.time.Interval;
import org.joda.time.base.AbstractInterval;
import org.junit.Assert;
import org.junit.Test;

public class DefaultQueryMetricsTest {
    @Test
    public void testDefaultQueryMetricsQuery() {
        CachingEmitter cachingEmitter = new CachingEmitter();
        ServiceEmitter serviceEmitter = new ServiceEmitter("", "", (Emitter)cachingEmitter);
        DefaultQueryMetrics queryMetrics = new DefaultQueryMetrics(TestHelper.makeJsonMapper());
        TopNQuery query = new TopNQueryBuilder().dataSource("xx").granularity(Granularities.ALL).dimension((DimensionSpec)new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("tags", "tags"), (Set)ImmutableSet.of((Object)"t3"), null)).metric("count").intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Collections.singletonList(new CountAggregatorFactory("count"))).threshold(5).filters((DimFilter)new SelectorDimFilter("tags", "t3", null)).build();
        queryMetrics.query((Query)query);
        queryMetrics.reportQueryTime(0L).emit(serviceEmitter);
        Map actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((long)12L, (long)actualEvent.size());
        Assert.assertTrue((boolean)actualEvent.containsKey("feed"));
        Assert.assertTrue((boolean)actualEvent.containsKey("timestamp"));
        Assert.assertEquals((Object)"", actualEvent.get("host"));
        Assert.assertEquals((Object)"", actualEvent.get("service"));
        Assert.assertEquals((Object)"xx", actualEvent.get("dataSource"));
        Assert.assertEquals((Object)query.getType(), actualEvent.get("type"));
        List expectedIntervals = QueryRunnerTestHelper.fullOnInterval.getIntervals();
        List expectedStringIntervals = expectedIntervals.stream().map(AbstractInterval::toString).collect(Collectors.toList());
        Assert.assertEquals(expectedStringIntervals, actualEvent.get("interval"));
        Assert.assertEquals((Object)"true", actualEvent.get("hasFilters"));
        Assert.assertEquals((Object)((Interval)expectedIntervals.get(0)).toDuration().toString(), actualEvent.get("duration"));
        Assert.assertEquals((Object)"", actualEvent.get("id"));
        Assert.assertEquals((Object)"query/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)0L, actualEvent.get("value"));
    }

    @Test
    public void testDefaultQueryMetricsMetricNamesAndUnits() {
        CachingEmitter cachingEmitter = new CachingEmitter();
        ServiceEmitter serviceEmitter = new ServiceEmitter("", "", (Emitter)cachingEmitter);
        DefaultQueryMetrics queryMetrics = new DefaultQueryMetrics(TestHelper.makeJsonMapper());
        DefaultQueryMetricsTest.testQueryMetricsDefaultMetricNamesAndUnits(cachingEmitter, serviceEmitter, queryMetrics);
    }

    public static void testQueryMetricsDefaultMetricNamesAndUnits(CachingEmitter cachingEmitter, ServiceEmitter serviceEmitter, QueryMetrics<? extends Query<?>> queryMetrics) {
        queryMetrics.reportQueryTime(1000001L).emit(serviceEmitter);
        Map actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((Object)"query/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)1L, actualEvent.get("value"));
        queryMetrics.reportWaitTime(2000001L).emit(serviceEmitter);
        actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((Object)"query/wait/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)2L, actualEvent.get("value"));
        queryMetrics.reportSegmentTime(3000001L).emit(serviceEmitter);
        actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((Object)"query/segment/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)3L, actualEvent.get("value"));
        queryMetrics.reportSegmentAndCacheTime(4000001L).emit(serviceEmitter);
        actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((Object)"query/segmentAndCache/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)4L, actualEvent.get("value"));
        queryMetrics.reportIntervalChunkTime(5000001L).emit(serviceEmitter);
        actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((Object)"query/intervalChunk/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)5L, actualEvent.get("value"));
        queryMetrics.reportCpuTime(6000001L).emit(serviceEmitter);
        actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((Object)"query/cpu/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)6000L, actualEvent.get("value"));
        queryMetrics.reportNodeTimeToFirstByte(7000001L).emit(serviceEmitter);
        actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((Object)"query/node/ttfb", actualEvent.get("metric"));
        Assert.assertEquals((Object)7L, actualEvent.get("value"));
        queryMetrics.reportNodeTime(8000001L).emit(serviceEmitter);
        actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((Object)"query/node/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)8L, actualEvent.get("value"));
        queryMetrics.reportQueryBytes(9L).emit(serviceEmitter);
        actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((Object)"query/bytes", actualEvent.get("metric"));
        Assert.assertEquals((Object)9L, actualEvent.get("value"));
        queryMetrics.reportNodeBytes(10L).emit(serviceEmitter);
        actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((Object)"query/node/bytes", actualEvent.get("metric"));
        Assert.assertEquals((Object)10L, actualEvent.get("value"));
    }
}

