/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Properties;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.guice.DruidGuiceExtensions;
import org.apache.hive.druid.io.druid.guice.JavaScriptModule;
import org.apache.hive.druid.io.druid.guice.JsonConfigurator;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.js.JavaScriptConfig;
import org.junit.Assert;
import org.junit.Test;

public class JavaScriptModuleTest {
    @Test
    public void testInjectionDefault() throws Exception {
        JavaScriptConfig config = (JavaScriptConfig)this.makeInjectorWithProperties(new Properties()).getInstance(JavaScriptConfig.class);
        Assert.assertFalse((boolean)config.isEnabled());
    }

    @Test
    public void testInjectionEnabled() throws Exception {
        Properties props = new Properties();
        props.setProperty("druid.javascript.enabled", "true");
        JavaScriptConfig config = (JavaScriptConfig)this.makeInjectorWithProperties(props).getInstance(JavaScriptConfig.class);
        Assert.assertTrue((boolean)config.isEnabled());
    }

    private Injector makeInjectorWithProperties(final Properties props) {
        return Guice.createInjector((Iterable)ImmutableList.of((Object)new DruidGuiceExtensions(), (Object)new Module(){

            public void configure(Binder binder) {
                binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
                binder.bind(JsonConfigurator.class).in(LazySingleton.class);
                binder.bind(Properties.class).toInstance((Object)props);
            }
        }, (Object)new JavaScriptModule()));
    }
}

