/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.io.druid.discovery.DataNodeService;
import org.apache.hive.druid.io.druid.discovery.DiscoveryDruidNode;
import org.apache.hive.druid.io.druid.discovery.DruidNodeDiscovery;
import org.apache.hive.druid.io.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.hive.druid.io.druid.discovery.LookupNodeService;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.junit.Assert;
import org.junit.Test;

public class DruidNodeDiscoveryProviderTest {
    @Test
    public void testGetForService() {
        TestDruidNodeDiscoveryProvider provider = new TestDruidNodeDiscoveryProvider();
        DruidNodeDiscovery dataNodeDiscovery = provider.getForService("dataNodeService");
        final HashSet dataNodes = new HashSet();
        dataNodeDiscovery.registerListener(new DruidNodeDiscovery.Listener(){

            public void nodesAdded(List<DiscoveryDruidNode> nodes) {
                dataNodes.addAll(nodes);
            }

            public void nodesRemoved(List<DiscoveryDruidNode> nodes) {
                dataNodes.removeAll(nodes);
            }
        });
        DruidNodeDiscovery lookupNodeDiscovery = provider.getForService("lookupNodeService");
        final HashSet lookupNodes = new HashSet();
        lookupNodeDiscovery.registerListener(new DruidNodeDiscovery.Listener(){

            public void nodesAdded(List<DiscoveryDruidNode> nodes) {
                lookupNodes.addAll(nodes);
            }

            public void nodesRemoved(List<DiscoveryDruidNode> nodes) {
                lookupNodes.removeAll(nodes);
            }
        });
        Assert.assertTrue((boolean)dataNodes.isEmpty());
        Assert.assertTrue((boolean)dataNodes.isEmpty());
        Assert.assertTrue((boolean)dataNodeDiscovery.getAllNodes().isEmpty());
        Assert.assertTrue((boolean)lookupNodes.isEmpty());
        Assert.assertTrue((boolean)lookupNodeDiscovery.getAllNodes().isEmpty());
        DiscoveryDruidNode node1 = new DiscoveryDruidNode(new DruidNode("s1", "h1", Integer.valueOf(8080), null, true, false), "historical", (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.HISTORICAL, 0), (Object)"lookupNodeService", (Object)new LookupNodeService("tier")));
        DiscoveryDruidNode node2 = new DiscoveryDruidNode(new DruidNode("s2", "h2", Integer.valueOf(8080), null, true, false), "historical", (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.HISTORICAL, 0)));
        DiscoveryDruidNode node3 = new DiscoveryDruidNode(new DruidNode("s3", "h3", Integer.valueOf(8080), null, true, false), "historical", (Map)ImmutableMap.of((Object)"lookupNodeService", (Object)new LookupNodeService("tier")));
        DiscoveryDruidNode node4 = new DiscoveryDruidNode(new DruidNode("s4", "h4", Integer.valueOf(8080), null, true, false), "peon", (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.HISTORICAL, 0), (Object)"lookupNodeService", (Object)new LookupNodeService("tier")));
        DiscoveryDruidNode node5 = new DiscoveryDruidNode(new DruidNode("s5", "h5", Integer.valueOf(8080), null, true, false), "peon", (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.HISTORICAL, 0)));
        DiscoveryDruidNode node6 = new DiscoveryDruidNode(new DruidNode("s6", "h6", Integer.valueOf(8080), null, true, false), "peon", (Map)ImmutableMap.of((Object)"lookupNodeService", (Object)new LookupNodeService("tier")));
        DiscoveryDruidNode node7 = new DiscoveryDruidNode(new DruidNode("s7", "h7", Integer.valueOf(8080), null, true, false), "broker", (Map)ImmutableMap.of((Object)"lookupNodeService", (Object)new LookupNodeService("tier")));
        DiscoveryDruidNode node7Clone = new DiscoveryDruidNode(new DruidNode("s7", "h7", Integer.valueOf(8080), null, true, false), "broker", (Map)ImmutableMap.of((Object)"lookupNodeService", (Object)new LookupNodeService("tier")));
        DiscoveryDruidNode node8 = new DiscoveryDruidNode(new DruidNode("s8", "h8", Integer.valueOf(8080), null, true, false), "coordinator", (Map)ImmutableMap.of());
        provider.add(node1);
        provider.add(node2);
        provider.add(node3);
        provider.add(node4);
        provider.add(node5);
        provider.add(node6);
        provider.add(node7);
        provider.add(node7Clone);
        provider.add(node8);
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node2, (Object)node4, (Object)node5), (Object)ImmutableSet.copyOf((Collection)dataNodeDiscovery.getAllNodes()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node2, (Object)node4, (Object)node5), dataNodes);
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node3, (Object)node4, (Object)node6, (Object)node7), (Object)ImmutableSet.copyOf((Collection)lookupNodeDiscovery.getAllNodes()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node3, (Object)node4, (Object)node6, (Object)node7), lookupNodes);
        provider.remove(node8);
        provider.remove(node7Clone);
        provider.remove(node6);
        provider.remove(node5);
        provider.remove(node4);
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node2), (Object)ImmutableSet.copyOf((Collection)dataNodeDiscovery.getAllNodes()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node2), dataNodes);
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node3), (Object)ImmutableSet.copyOf((Collection)lookupNodeDiscovery.getAllNodes()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)node1, (Object)node3), lookupNodes);
    }

    private static class TestDruidNodeDiscoveryProvider
    extends DruidNodeDiscoveryProvider {
        private List<DruidNodeDiscovery.Listener> listeners = new ArrayList<DruidNodeDiscovery.Listener>();

        private TestDruidNodeDiscoveryProvider() {
        }

        public DruidNodeDiscovery getForNodeType(String nodeType) {
            return new DruidNodeDiscovery(){

                public Set<DiscoveryDruidNode> getAllNodes() {
                    throw new UnsupportedOperationException();
                }

                public void registerListener(DruidNodeDiscovery.Listener listener) {
                    listeners.add(listener);
                }
            };
        }

        void add(DiscoveryDruidNode node) {
            for (DruidNodeDiscovery.Listener listener : this.listeners) {
                listener.nodesAdded((List)ImmutableList.of((Object)node));
            }
        }

        void remove(DiscoveryDruidNode node) {
            for (DruidNodeDiscovery.Listener listener : this.listeners) {
                listener.nodesRemoved((List)ImmutableList.of((Object)node));
            }
        }
    }
}

