/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.org.roaringbitmap.IntIterator;

public class IntSetTestUtility {
    private static Set<Integer> setBits = Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 5, 8, 13, 21}));

    public static Set<Integer> getSetBits() {
        return Sets.newTreeSet(setBits);
    }

    public static final BitSet createSimpleBitSet(Set<Integer> setBits) {
        BitSet retval = new BitSet();
        for (int i : setBits) {
            retval.set(i);
        }
        return retval;
    }

    public static final void addAllToMutable(MutableBitmap mutableBitmap, Iterable<Integer> intSet) {
        for (Integer integer : intSet) {
            mutableBitmap.add(integer.intValue());
        }
    }

    public static Boolean equalSets(Set<Integer> s1, ImmutableBitmap s2) {
        HashSet<Integer> s3 = new HashSet<Integer>();
        for (Integer i : new IntIt(s2.iterator())) {
            s3.add(i);
        }
        return Sets.difference(s1, s3).isEmpty();
    }

    private static class IntIt
    implements Iterable<Integer> {
        private final Iterator<Integer> intIter;

        public IntIt(IntIterator intIt) {
            this.intIter = new IntIter(intIt);
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.intIter;
        }

        private static class IntIter
        implements Iterator<Integer> {
            private final IntIterator intIt;

            public IntIter(IntIterator intIt) {
                this.intIt = intIt;
            }

            @Override
            public boolean hasNext() {
                return this.intIt.hasNext();
            }

            @Override
            public Integer next() {
                return this.intIt.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove ints from int iterator");
            }
        }
    }
}

