/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.druid.io.druid.collections.CombiningIterable;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.guava.nary.BinaryFn;
import org.apache.hive.druid.io.druid.query.Result;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class CombiningIterableTest {
    @Test
    public void testMerge() {
        List<Result> resultsBefore = Arrays.asList(new Result(DateTimes.of((String)"2011-01-01"), (Object)1L), new Result(DateTimes.of((String)"2011-01-01"), (Object)2L));
        List<Result> expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-01-01"), (Object)3L));
        CombiningIterable resultsAfter = CombiningIterable.create(resultsBefore, (Comparator)new Comparator<Result<Object>>(){

            @Override
            public int compare(Result<Object> r1, Result<Object> r2) {
                return r1.getTimestamp().compareTo((ReadableInstant)r2.getTimestamp());
            }
        }, (BinaryFn)new BinaryFn<Result<Object>, Result<Object>, Result<Object>>(){

            public Result<Object> apply(Result<Object> arg1, Result<Object> arg2) {
                if (arg1 == null) {
                    return arg2;
                }
                if (arg2 == null) {
                    return arg1;
                }
                return new Result(arg1.getTimestamp(), (Object)((Long)arg1.getValue() + (Long)arg2.getValue()));
            }
        });
        Iterator it1 = expectedResults.iterator();
        Iterator it2 = resultsAfter.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Result r1 = (Result)it1.next();
            Result r2 = (Result)it2.next();
            Assert.assertEquals((Object)r1.getTimestamp(), (Object)r2.getTimestamp());
            Assert.assertEquals((Object)r1.getValue(), (Object)r2.getValue());
        }
    }
}

