/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.client.CacheUtil;
import org.apache.hive.druid.io.druid.client.CachingQueryRunner;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheConfig;
import org.apache.hive.druid.io.druid.client.cache.CacheStats;
import org.apache.hive.druid.io.druid.client.cache.MapCache;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.SequenceWrapper;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.query.CacheStrategy;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryConfig;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CachingQueryRunnerTest {
    private static final List<AggregatorFactory> AGGS = Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("imps", "imps"), new LongSumAggregatorFactory("impers", "imps"));
    private static final Object[] objects = new Object[]{DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983};
    private ExecutorService backgroundExecutorService;

    @Parameterized.Parameters(name="numBackgroundThreads={0}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.cartesian(Arrays.asList(5, 1, 0));
    }

    public CachingQueryRunnerTest(int numBackgroundThreads) {
        this.backgroundExecutorService = numBackgroundThreads > 0 ? Executors.newFixedThreadPool(numBackgroundThreads) : MoreExecutors.sameThreadExecutor();
    }

    @Test
    public void testCloseAndPopulate() throws Exception {
        List<Result> expectedRes = this.makeTopNResults(false, objects);
        List<Result> expectedCacheRes = this.makeTopNResults(true, objects);
        TopNQueryBuilder builder = new TopNQueryBuilder().dataSource("ds").dimension("top_dim").metric("imps").threshold(3).intervals("2011-01-05/2011-01-10").aggregators(AGGS).granularity(Granularities.ALL);
        TopNQueryQueryToolChest toolchest = new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
        this.testCloseAndPopulate(expectedRes, expectedCacheRes, (Query)builder.build(), (QueryToolChest)toolchest);
        this.testUseCache(expectedCacheRes, (Query)builder.build(), (QueryToolChest)toolchest);
    }

    @Test
    public void testTimeseries() throws Exception {
        for (boolean descending : new boolean[]{false, true}) {
            TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).descending(descending).build();
            Result row1 = new Result(DateTimes.of((String)"2011-04-01"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)6619L, (Object)"uniques", (Object)9.019833517963864)));
            Result row2 = new Result(DateTimes.of((String)"2011-04-02"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)13L, (Object)"idx", (Object)5827L, (Object)"uniques", (Object)9.019833517963864)));
            ArrayList expectedResults = descending ? Lists.newArrayList((Object[])new Result[]{row2, row1}) : Lists.newArrayList((Object[])new Result[]{row1, row2});
            TimeseriesQueryQueryToolChest toolChest = new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
            this.testCloseAndPopulate(expectedResults, expectedResults, (Query)query, (QueryToolChest)toolChest);
            this.testUseCache(expectedResults, (Query)query, (QueryToolChest)toolChest);
        }
    }

    private void testCloseAndPopulate(List<Result> expectedRes, List<Result> expectedCacheRes, Query query, QueryToolChest toolchest) throws Exception {
        final AssertingClosable closable = new AssertingClosable();
        final Sequence resultSeq = Sequences.wrap((Sequence)Sequences.simple(expectedRes), (SequenceWrapper)new SequenceWrapper(){

            public void before() {
                Assert.assertFalse((boolean)closable.isClosed());
            }

            public void after(boolean isDone, Throwable thrown) throws Exception {
                closable.close();
            }
        });
        final CountDownLatch cacheMustBePutOnce = new CountDownLatch(1);
        Cache cache = new Cache(){
            private final Map<Cache.NamedKey, byte[]> baseMap = new ConcurrentHashMap<Cache.NamedKey, byte[]>();

            public byte[] get(Cache.NamedKey key) {
                return this.baseMap.get(key);
            }

            public void put(Cache.NamedKey key, byte[] value) {
                this.baseMap.put(key, value);
                cacheMustBePutOnce.countDown();
            }

            public Map<Cache.NamedKey, byte[]> getBulk(Iterable<Cache.NamedKey> keys) {
                return null;
            }

            public void close(String namespace) {
            }

            public CacheStats getStats() {
                return null;
            }

            public boolean isLocal() {
                return true;
            }

            public void doMonitor(ServiceEmitter emitter) {
            }
        };
        String segmentIdentifier = "segment";
        SegmentDescriptor segmentDescriptor = new SegmentDescriptor(Intervals.of((String)"2011/2012"), "version", 0);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        CachingQueryRunner runner = new CachingQueryRunner(segmentIdentifier, segmentDescriptor, (ObjectMapper)objectMapper, cache, toolchest, new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, Map responseContext) {
                return resultSeq;
            }
        }, this.backgroundExecutorService, new CacheConfig(){

            public boolean isPopulateCache() {
                return true;
            }

            public boolean isUseCache() {
                return true;
            }
        });
        CacheStrategy cacheStrategy = toolchest.getCacheStrategy(query);
        Cache.NamedKey cacheKey = CacheUtil.computeSegmentCacheKey((String)segmentIdentifier, (SegmentDescriptor)segmentDescriptor, (byte[])cacheStrategy.computeCacheKey(query));
        HashMap context = new HashMap();
        Sequence res = runner.run(QueryPlus.wrap((Query)query), context);
        Assert.assertFalse((String)"sequence must not be closed", (boolean)closable.isClosed());
        Assert.assertNull((String)"cache must be empty", (Object)cache.get(cacheKey));
        ArrayList results = (ArrayList)Sequences.toList((Sequence)res, new ArrayList());
        Assert.assertTrue((boolean)closable.isClosed());
        Assert.assertEquals((Object)expectedRes.toString(), (Object)results.toString());
        Assert.assertTrue((String)"cache must be populated", (boolean)cacheMustBePutOnce.await(10L, TimeUnit.SECONDS));
        byte[] cacheValue = cache.get(cacheKey);
        Assert.assertNotNull((Object)cacheValue);
        Function fn = cacheStrategy.pullFromCache();
        ArrayList cacheResults = Lists.newArrayList((Iterator)Iterators.transform((Iterator)objectMapper.readValues(objectMapper.getFactory().createParser(cacheValue), cacheStrategy.getCacheObjectClazz()), (Function)fn));
        Assert.assertEquals((Object)expectedCacheRes.toString(), (Object)((Object)cacheResults).toString());
    }

    private void testUseCache(List<Result> expectedResults, Query query, QueryToolChest toolchest) throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String segmentIdentifier = "segment";
        SegmentDescriptor segmentDescriptor = new SegmentDescriptor(Intervals.of((String)"2011/2012"), "version", 0);
        CacheStrategy cacheStrategy = toolchest.getCacheStrategy(query);
        Cache.NamedKey cacheKey = CacheUtil.computeSegmentCacheKey((String)segmentIdentifier, (SegmentDescriptor)segmentDescriptor, (byte[])cacheStrategy.computeCacheKey(query));
        Cache cache = MapCache.create((long)0x100000L);
        CacheUtil.populate((Cache)cache, (ObjectMapper)objectMapper, (Cache.NamedKey)cacheKey, (Iterable)Iterables.transform(expectedResults, (Function)cacheStrategy.prepareForCache()));
        CachingQueryRunner runner = new CachingQueryRunner(segmentIdentifier, segmentDescriptor, (ObjectMapper)objectMapper, cache, toolchest, new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, Map responseContext) {
                return Sequences.empty();
            }
        }, this.backgroundExecutorService, new CacheConfig(){

            public boolean isPopulateCache() {
                return true;
            }

            public boolean isUseCache() {
                return true;
            }
        });
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)query), context), new ArrayList());
        Assert.assertEquals((Object)expectedResults.toString(), (Object)results.toString());
    }

    private List<Result> makeTopNResults(boolean cachedResults, Object ... objects) {
        ArrayList retVal = Lists.newArrayList();
        int index = 0;
        while (index < objects.length) {
            DateTime timestamp = (DateTime)objects[index++];
            ArrayList values = Lists.newArrayList();
            while (index < objects.length && !(objects[index] instanceof DateTime)) {
                if (objects.length - index < 3) {
                    throw new ISE("expect 3 values for each entry in the top list, had %d values left.", new Object[]{objects.length - index});
                }
                double imps = ((Number)objects[index + 2]).doubleValue();
                double rows = ((Number)objects[index + 1]).doubleValue();
                if (cachedResults) {
                    values.add(ImmutableMap.of((Object)"top_dim", (Object)objects[index], (Object)"rows", (Object)rows, (Object)"imps", (Object)imps, (Object)"impers", (Object)imps));
                } else {
                    values.add(ImmutableMap.of((Object)"top_dim", (Object)objects[index], (Object)"rows", (Object)rows, (Object)"imps", (Object)imps, (Object)"impers", (Object)imps, (Object)"avg_imps_per_row", (Object)(imps / rows)));
                }
                index += 3;
            }
            retVal.add(new Result(timestamp, (Object)new TopNResultValue((List)values)));
        }
        return retVal;
    }

    private static class AssertingClosable
    implements Closeable {
        private final AtomicBoolean closed = new AtomicBoolean(false);

        private AssertingClosable() {
        }

        @Override
        public void close() throws IOException {
            Assert.assertFalse((boolean)this.closed.get());
            Assert.assertTrue((boolean)this.closed.compareAndSet(false, true));
        }

        public boolean isClosed() {
            return this.closed.get();
        }
    }
}

