/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.metrics;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.metrics.CpuAcctDeltaMonitor;
import org.apache.hive.druid.com.metamx.metrics.StubServiceEmitter;
import org.apache.hive.druid.com.metamx.metrics.cgroups.CgroupDiscoverer;
import org.apache.hive.druid.com.metamx.metrics.cgroups.ProcCgroupDiscoverer;
import org.apache.hive.druid.com.metamx.metrics.cgroups.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class CpuAcctDeltaMonitorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File procDir;
    private File cgroupDir;
    private File cpuacctDir;
    private CgroupDiscoverer discoverer;

    @Before
    public void setUp() throws IOException {
        this.cgroupDir = this.temporaryFolder.newFolder();
        this.procDir = this.temporaryFolder.newFolder();
        this.discoverer = new ProcCgroupDiscoverer(this.procDir.toPath());
        TestUtils.setUpCgroups(this.procDir, this.cgroupDir);
        this.cpuacctDir = new File(this.cgroupDir, "cpu,cpuacct/system.slice/mesos-agent-druid.service/f12ba7e0-fa16-462e-bb9d-652ccc27f0ee");
        Assert.assertTrue((this.cpuacctDir.isDirectory() && this.cpuacctDir.exists() || this.cpuacctDir.mkdirs() ? 1 : 0) != 0);
        TestUtils.copyResource("/cpuacct.usage_all", new File(this.cpuacctDir, "cpuacct.usage_all"));
    }

    @Test
    public void testMonitorWontCrash() throws Exception {
        CpuAcctDeltaMonitor monitor = new CpuAcctDeltaMonitor("some_feed", (Map)ImmutableMap.of(), cgroup -> {
            throw new RuntimeException("Should continue");
        });
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        monitor.doMonitor((ServiceEmitter)emitter);
        monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertTrue((boolean)emitter.getEvents().isEmpty());
    }

    @Test
    public void testSimpleMonitor() throws Exception {
        File cpuacct = new File(this.cpuacctDir, "cpuacct.usage_all");
        try (FileOutputStream fos = new FileOutputStream(cpuacct);){
            fos.write(StringUtils.toUtf8((String)"cpu user system\n"));
            for (int i = 0; i < 128; ++i) {
                fos.write(StringUtils.toUtf8((String)String.format("%d 0 0\n", i)));
            }
        }
        CpuAcctDeltaMonitor monitor = new CpuAcctDeltaMonitor("some_feed", (Map)ImmutableMap.of(), cgroup -> this.cpuacctDir.toPath());
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        Assert.assertFalse((boolean)monitor.doMonitor((ServiceEmitter)emitter));
        Assert.assertEquals((long)0L, (long)emitter.getEvents().size());
        Assert.assertTrue((boolean)cpuacct.delete());
        TestUtils.copyResource("/cpuacct.usage_all", cpuacct);
        Assert.assertTrue((boolean)monitor.doMonitor((ServiceEmitter)emitter));
        Assert.assertEquals((long)257L, (long)emitter.getEvents().size());
    }
}

