/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.metamx.common.Granularity;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.Interval;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.junit.Assert;
import org.junit.Test;

public class TestGranularity {
    final Granularity SECOND = Granularity.SECOND;
    final Granularity MINUTE = Granularity.MINUTE;
    final Granularity HOUR = Granularity.HOUR;
    final Granularity FIFTEEN_MINUTE = Granularity.FIFTEEN_MINUTE;
    final Granularity DAY = Granularity.DAY;
    final Granularity WEEK = Granularity.WEEK;
    final Granularity MONTH = Granularity.MONTH;
    final Granularity YEAR = Granularity.YEAR;

    @Test
    public void testHiveFormat() {
        PathDate[] secondChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 20, 50, 43, 0), null, "dt=2011-03-15-20-50-43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 43, 0), null, "/dt=2011-03-15-20-50-43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 43, 0), null, "valid/dt=2011-03-15-20-50-43/Test1"), new PathDate(null, null, "valid/dt=2011-03-15-20-50/Test2"), new PathDate(null, null, "valid/dt=2011-03-15-20/Test3"), new PathDate(null, null, "valid/dt=2011-03-15/Test4"), new PathDate(null, null, "valid/dt=2011-03/Test5"), new PathDate(null, null, "valid/dt=2011/Test6"), new PathDate(null, null, "null/dt=----/Test7"), new PathDate(null, null, "null/10-2011-23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(null, IllegalFieldValueException.class, "error/dt=2011-10-20-20-42-72/Test11"), new PathDate(null, IllegalFieldValueException.class, "error/dt=2011-10-20-42-90-24/Test11"), new PathDate(null, IllegalFieldValueException.class, "error/dt=2011-10-33-20-42-24/Test11"), new PathDate(null, IllegalFieldValueException.class, "error/dt=2011-13-20-20-42-24/Test11")};
        this.checkToDate(this.SECOND, Granularity.Formatter.HIVE, secondChecks);
    }

    @Test
    public void testSecondToDate() {
        PathDate[] secondChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 20, 50, 43, 0), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 43, 0), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 43, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(null, null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(null, null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(null, null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.SECOND, Granularity.Formatter.DEFAULT, secondChecks);
    }

    @Test
    public void testMinuteToDate() {
        PathDate[] minuteChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 20, 50, 0, 0), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 0, 0), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 15, 20, 50, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(null, null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(null, null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 20, 20, 42, 0, 0), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.MINUTE, Granularity.Formatter.DEFAULT, minuteChecks);
    }

    @Test
    public void testFifteenMinuteToDate() {
        PathDate[] minuteChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 20, 45, 0, 0), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 45, 0, 0), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 45, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 15, 20, 45, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=00/Test2a"), new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=14/Test2b"), new PathDate(new DateTime(2011, 3, 15, 20, 15, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=15/Test2c"), new PathDate(new DateTime(2011, 3, 15, 20, 15, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=29/Test2d"), new PathDate(new DateTime(2011, 3, 15, 20, 30, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=30/Test2e"), new PathDate(new DateTime(2011, 3, 15, 20, 30, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=44/Test2f"), new PathDate(new DateTime(2011, 3, 15, 20, 45, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=45/Test2g"), new PathDate(new DateTime(2011, 3, 15, 20, 45, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=59/Test2h"), new PathDate(null, null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(null, null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 20, 20, 30, 0, 0), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.FIFTEEN_MINUTE, Granularity.Formatter.DEFAULT, minuteChecks);
    }

    @Test
    public void testHourToDate() {
        PathDate[] hourChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 3, 15, 20, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(null, null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 20, 20, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(new DateTime(2011, 10, 20, 20, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.HOUR, Granularity.Formatter.DEFAULT, hourChecks);
    }

    @Test
    public void testSixHourToDate() {
        PathDate[] hourChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 18, 0, 0, 0), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 18, 0, 0, 0), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 18, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 15, 18, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 3, 15, 18, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(null, null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 20, 18, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(new DateTime(2011, 10, 20, 18, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=00/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=02/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 6, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=06/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 6, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=11/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 12, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=12/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 12, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=13/M=90/S=24/Test12"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(Granularity.SIX_HOUR, Granularity.Formatter.DEFAULT, hourChecks);
    }

    @Test
    public void testDayToDate() {
        PathDate[] dayChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 15, 0, 0, 0, 0), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 0, 0, 0, 0), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 15, 0, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 15, 0, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 3, 15, 0, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(new DateTime(2011, 3, 15, 0, 0, 0, 0), null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(null, null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 20, 0, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.DAY, Granularity.Formatter.DEFAULT, dayChecks);
    }

    @Test
    public void testMonthToDate() {
        PathDate[] monthChecks = new PathDate[]{new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0), null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(new DateTime(2011, 3, 1, 0, 0, 0, 0), null, "valid/y=2011/m=03/Test5"), new PathDate(null, null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(null, null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 10, 1, 0, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(new DateTime(2011, 10, 1, 0, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 10, 1, 0, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(new DateTime(2011, 10, 1, 0, 0, 0, 0), null, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(null, IllegalFieldValueException.class, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.MONTH, Granularity.Formatter.DEFAULT, monthChecks);
    }

    @Test
    public void testYearToDate() {
        PathDate[] yearChecks = new PathDate[]{new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "/y=2011/m=03/d=15/H=20/M=50/S=43/Test0"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/S=43/Test1"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/M=50/Test2"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "valid/y=2011/m=03/d=15/H=20/Test3"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "valid/y=2011/m=03/d=15/Test4"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "valid/y=2011/m=03/Test5"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "valid/y=2011/Test6"), new PathDate(null, null, "null/y=/m=/d=/Test7"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "null/m=10/y=2011/d=23/Test8"), new PathDate(null, null, "null/Test9"), new PathDate(null, null, ""), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=20/M=42/S=72/Test11"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=20/M=90/S=24/Test12"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "error/y=2011/m=10/d=20/H=42/M=42/S=24/Test13"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "error/y=2011/m=10/d=33/H=20/M=42/S=24/Test14"), new PathDate(new DateTime(2011, 1, 1, 0, 0, 0, 0), null, "error/y=2011/m=13/d=20/H=20/M=42/S=24/Test15")};
        this.checkToDate(this.YEAR, Granularity.Formatter.DEFAULT, yearChecks);
    }

    private void checkToDate(Granularity granularity, Granularity.Formatter formatter, PathDate[] checks) {
        for (PathDate pd : checks) {
            boolean flag;
            block5: {
                if (pd.exception == null) {
                    Assert.assertEquals((String)String.format("[%s,%s] Expected path %s to return date %s", granularity, formatter, pd.path, pd.date), (Object)pd.date, (Object)granularity.toDate(pd.path, formatter));
                    if (formatter.equals((Object)Granularity.Formatter.DEFAULT)) {
                        Assert.assertEquals((String)String.format("[%s] Expected toDate(%s) to return the same as toDate(%s, DEFAULT)", granularity, pd.path, pd.path), (Object)granularity.toDate(pd.path), (Object)granularity.toDate(pd.path, formatter));
                    }
                    if (pd.date == null) continue;
                    Assert.assertEquals((String)String.format("[%s,%s] Expected date %s to return date %s", granularity, formatter, pd.date, pd.date), (Object)pd.date, (Object)granularity.toDate(granularity.getFormatter(formatter).print((ReadableInstant)pd.date) + "/", formatter));
                    continue;
                }
                flag = false;
                try {
                    granularity.toDate(pd.path, formatter);
                }
                catch (Exception e) {
                    if (e.getClass() != pd.exception) break block5;
                    flag = true;
                }
            }
            Assert.assertTrue((String)String.format("[%s,%s] Expected exception %s for path: %s", granularity, formatter, pd.exception, pd.path), (boolean)flag);
        }
    }

    @Test
    public void testGetUnits() throws Exception {
        Assert.assertEquals((Object)Seconds.seconds((int)1), (Object)this.SECOND.getUnits(1));
        Assert.assertEquals((Object)Minutes.minutes((int)1), (Object)this.MINUTE.getUnits(1));
        Assert.assertEquals((Object)Hours.hours((int)1), (Object)this.HOUR.getUnits(1));
        Assert.assertEquals((Object)Days.days((int)1), (Object)this.DAY.getUnits(1));
        Assert.assertEquals((Object)Weeks.weeks((int)1), (Object)this.WEEK.getUnits(1));
        Assert.assertEquals((Object)Months.months((int)1), (Object)this.MONTH.getUnits(1));
        Assert.assertEquals((Object)Years.years((int)1), (Object)this.YEAR.getUnits(1));
    }

    @Test
    public void testNumIn() throws Exception {
        TestInterval[] intervals;
        for (TestInterval testInterval : intervals = new TestInterval[]{new TestInterval(2, 0, 0, 0, 0, 0, 0), new TestInterval(1, 2, 3, 4, 5, 6, 7), new TestInterval(4, 0, 0, 0, 0, 0, 0)}) {
            Interval interval = testInterval.getInterval();
            Assert.assertEquals((long)testInterval.getYears(), (long)this.YEAR.numIn((ReadableInterval)interval));
            Assert.assertEquals((long)testInterval.getMonths(), (long)this.MONTH.numIn((ReadableInterval)interval));
            Assert.assertEquals((long)testInterval.getWeeks(), (long)this.WEEK.numIn((ReadableInterval)interval));
            Assert.assertEquals((long)testInterval.getDays(), (long)this.DAY.numIn((ReadableInterval)interval));
            Assert.assertEquals((long)testInterval.getHours(), (long)this.HOUR.numIn((ReadableInterval)interval));
            Assert.assertEquals((long)testInterval.getMinutes(), (long)this.MINUTE.numIn((ReadableInterval)interval));
            Assert.assertEquals((long)testInterval.getSeconds(), (long)this.SECOND.numIn((ReadableInterval)interval));
        }
        Assert.assertEquals((long)2L, (long)this.YEAR.numIn((ReadableInterval)new Interval((Object)"P2y3m4d/2011-04-01")));
        Assert.assertEquals((long)27L, (long)this.MONTH.numIn((ReadableInterval)new Interval((Object)"P2y3m4d/2011-04-01")));
        Assert.assertEquals((long)824L, (long)this.DAY.numIn((ReadableInterval)new Interval((Object)"P2y3m4d/2011-04-01")));
    }

    @Test
    public void testTruncate() throws Exception {
        DateTime date = new DateTime((Object)"2011-03-15T22:42:23.898");
        Assert.assertEquals((Object)new DateTime((Object)"2011-01-01T00:00:00.000"), (Object)this.YEAR.truncate(date));
        Assert.assertEquals((Object)new DateTime((Object)"2011-03-01T00:00:00.000"), (Object)this.MONTH.truncate(date));
        Assert.assertEquals((Object)new DateTime((Object)"2011-03-14T00:00:00.000"), (Object)this.WEEK.truncate(date));
        Assert.assertEquals((Object)new DateTime((Object)"2011-03-15T00:00:00.000"), (Object)this.DAY.truncate(date));
        Assert.assertEquals((Object)new DateTime((Object)"2011-03-15T22:00:00.000"), (Object)this.HOUR.truncate(date));
        Assert.assertEquals((Object)new DateTime((Object)"2011-03-15T22:42:00.000"), (Object)this.MINUTE.truncate(date));
        Assert.assertEquals((Object)new DateTime((Object)"2011-03-15T22:42:23.000"), (Object)this.SECOND.truncate(date));
    }

    @Test
    public void testGetIterable() throws Exception {
        DateTime start = new DateTime((Object)"2011-01-01T00:00:00");
        DateTime end = new DateTime((Object)"2011-01-14T00:00:00");
        Iterator intervals = this.DAY.getIterable(start, end).iterator();
        Assert.assertEquals((Object)new Interval((Object)"2011-01-01/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-02/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-03/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-04/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-05/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-06/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-07/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-08/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-09/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-10/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-11/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-12/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-13/P1d"), intervals.next());
        try {
            intervals.next();
        }
        catch (NoSuchElementException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testGetReverseIterable() throws Exception {
        DateTime start = new DateTime((Object)"2011-01-01T00:00:00");
        DateTime end = new DateTime((Object)"2011-01-14T00:00:00");
        Iterator intervals = this.DAY.getReverseIterable(start, end).iterator();
        Assert.assertEquals((Object)new Interval((Object)"2011-01-13/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-12/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-11/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-10/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-09/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-08/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-07/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-06/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-05/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-04/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-03/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-02/P1d"), intervals.next());
        Assert.assertEquals((Object)new Interval((Object)"2011-01-01/P1d"), intervals.next());
        try {
            intervals.next();
        }
        catch (NoSuchElementException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testBucket() {
        DateTime dt = new DateTime((Object)"2011-02-03T04:05:06.100");
        Assert.assertEquals((Object)new Interval((Object)"2011-01-01/2012-01-01"), (Object)this.YEAR.bucket(dt));
        Assert.assertEquals((Object)new Interval((Object)"2011-02-01/2011-03-01"), (Object)this.MONTH.bucket(dt));
        Assert.assertEquals((Object)new Interval((Object)"2011-01-31/2011-02-07"), (Object)this.WEEK.bucket(dt));
        Assert.assertEquals((Object)new Interval((Object)"2011-02-03/2011-02-04"), (Object)this.DAY.bucket(dt));
        Assert.assertEquals((Object)new Interval((Object)"2011-02-03T04/2011-02-03T05"), (Object)this.HOUR.bucket(dt));
        Assert.assertEquals((Object)new Interval((Object)"2011-02-03T04:05:00/2011-02-03T04:06:00"), (Object)this.MINUTE.bucket(dt));
        Assert.assertEquals((Object)new Interval((Object)"2011-02-03T04:05:06/2011-02-03T04:05:07"), (Object)this.SECOND.bucket(dt));
        Assert.assertEquals((Object)new Interval((Object)"2011-01-01/2011-01-02"), (Object)this.DAY.bucket(new DateTime((Object)"2011-01-01")));
    }

    @Test
    public void testWiden() {
        Assert.assertEquals((Object)new Interval((Object)"0/0T01"), (Object)this.HOUR.widen(new Interval((Object)"0/0")));
        Assert.assertEquals((Object)new Interval((Object)"T03/T04"), (Object)this.HOUR.widen(new Interval((Object)"T03:00/T03:00")));
        Assert.assertEquals((Object)new Interval((Object)"T03/T04"), (Object)this.HOUR.widen(new Interval((Object)"T03:00/T03:05")));
        Assert.assertEquals((Object)new Interval((Object)"T03/T04"), (Object)this.HOUR.widen(new Interval((Object)"T03:05/T04:00")));
        Assert.assertEquals((Object)new Interval((Object)"T03/T04"), (Object)this.HOUR.widen(new Interval((Object)"T03:00/T04:00")));
        Assert.assertEquals((Object)new Interval((Object)"T03/T04"), (Object)this.HOUR.widen(new Interval((Object)"T03:00/T03:59:59.999")));
        Assert.assertEquals((Object)new Interval((Object)"T03/T05"), (Object)this.HOUR.widen(new Interval((Object)"T03:00/T04:00:00.001")));
        Assert.assertEquals((Object)new Interval((Object)"T03/T06"), (Object)this.HOUR.widen(new Interval((Object)"T03:05/T05:30")));
        Assert.assertEquals((Object)new Interval((Object)"T03/T04"), (Object)this.HOUR.widen(new Interval((Object)"T03:05/T03:05")));
    }

    private class TestInterval {
        private final DateTime start = new DateTime(2001, 1, 1, 0, 0, 0, 0);
        private final DateTime end;
        private final Interval interval;

        public TestInterval(int years, int months, int days, int hours, int minutes, int seconds, int millis) {
            this.end = this.start.plusYears(years).plusMonths(months).plusDays(days).plusHours(hours).plusMinutes(minutes).plusSeconds(seconds).plusMillis(millis);
            this.interval = new Interval((ReadableInstant)this.start, (ReadableInstant)this.end);
        }

        public Interval getInterval() {
            return this.interval;
        }

        public int getYears() {
            return Years.yearsIn((ReadableInterval)this.interval).getYears();
        }

        public int getMonths() {
            return Months.monthsIn((ReadableInterval)this.interval).getMonths();
        }

        public int getWeeks() {
            return Weeks.weeksIn((ReadableInterval)this.interval).getWeeks();
        }

        public int getDays() {
            return Days.daysIn((ReadableInterval)this.interval).getDays();
        }

        public int getHours() {
            return Hours.hoursIn((ReadableInterval)this.interval).getHours();
        }

        public int getMinutes() {
            return Minutes.minutesIn((ReadableInterval)this.interval).getMinutes();
        }

        public int getSeconds() {
            return Seconds.secondsIn((ReadableInterval)this.interval).getSeconds();
        }
    }

    private class PathDate {
        public final String path;
        public final DateTime date;
        public final Class<? extends Exception> exception;

        private PathDate(DateTime date, Class<? extends Exception> exception, String path) {
            this.path = path;
            this.date = date;
            this.exception = exception;
        }
    }
}

