/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.QuinticFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Sin;
import org.apache.commons.math3.analysis.solvers.BisectionSolver;
import org.junit.Assert;
import org.junit.Test;

public final class BisectionSolverTest {
    @Test
    public void testSinZero() {
        Sin f = new Sin();
        BisectionSolver solver = new BisectionSolver();
        double result = solver.solve(100, (UnivariateFunction)f, 3.0, 4.0);
        Assert.assertEquals((double)result, (double)Math.PI, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, 1.0, 4.0);
        Assert.assertEquals((double)result, (double)Math.PI, (double)solver.getAbsoluteAccuracy());
    }

    @Test
    public void testQuinticZero() {
        QuinticFunction f = new QuinticFunction();
        BisectionSolver solver = new BisectionSolver();
        double result = solver.solve(100, (UnivariateFunction)f, -0.2, 0.2);
        Assert.assertEquals((double)result, (double)0.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, -0.1, 0.3);
        Assert.assertEquals((double)result, (double)0.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, -0.3, 0.45);
        Assert.assertEquals((double)result, (double)0.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, 0.3, 0.7);
        Assert.assertEquals((double)result, (double)0.5, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, 0.2, 0.6);
        Assert.assertEquals((double)result, (double)0.5, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, 0.05, 0.95);
        Assert.assertEquals((double)result, (double)0.5, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, 0.85, 1.25);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, 0.8, 1.2);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, 0.85, 1.75);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, 0.55, 1.45);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (UnivariateFunction)f, 0.85, 5.0);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMath369() {
        Sin f = new Sin();
        BisectionSolver solver = new BisectionSolver();
        Assert.assertEquals((double)Math.PI, (double)solver.solve(100, (UnivariateFunction)f, 3.0, 3.2, 3.1), (double)solver.getAbsoluteAccuracy());
    }
}

