/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSource;

public class TestPerUserPoolDataSource
extends TestConnectionPool {
    private DataSource ds;

    public TestPerUserPoolDataSource(String testName) {
        super(testName);
    }

    @Override
    protected Connection getConnection() throws SQLException {
        return this.ds.getConnection("foo", "bar");
    }

    public void setUp() throws Exception {
        super.setUp();
        DriverAdapterCPDS pcds = new DriverAdapterCPDS();
        pcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        pcds.setUrl("jdbc:apache:commons:testdriver");
        pcds.setUser("foo");
        pcds.setPassword("bar");
        pcds.setAccessToUnderlyingConnectionAllowed(true);
        PerUserPoolDataSource tds = new PerUserPoolDataSource();
        tds.setConnectionPoolDataSource((ConnectionPoolDataSource)pcds);
        tds.setDefaultMaxTotal(this.getMaxTotal());
        tds.setDefaultMaxWaitMillis((long)((int)this.getMaxWaitMillis()));
        tds.setPerUserMaxTotal("foo", Integer.valueOf(this.getMaxTotal()));
        tds.setPerUserMaxWaitMillis("foo", Long.valueOf(this.getMaxWaitMillis()));
        tds.setDefaultTransactionIsolation(2);
        tds.setDefaultAutoCommit(Boolean.TRUE);
        this.ds = tds;
    }

    public void testIncorrectPassword() throws Exception {
        Throwable throwable;
        Connection c;
        block57: {
            try {
                c = this.ds.getConnection("u1", "zlsafjk");
                throwable = null;
                try {
                    TestPerUserPoolDataSource.fail((String)"Able to retrieve connection with incorrect password");
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (c != null) {
                        if (throwable != null) {
                            try {
                                c.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            c.close();
                        }
                    }
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            this.ds.getConnection("u1", "p1").close();
            try {
                c = this.ds.getConnection("u1", "x");
                throwable = null;
                try {
                    TestPerUserPoolDataSource.fail((String)"Able to retrieve connection with incorrect password");
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (c != null) {
                        if (throwable != null) {
                            try {
                                c.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            c.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("Given password did not match")) break block57;
                throw e;
            }
        }
        this.ds.getConnection("u1", "p1").close();
        this.ds.getConnection("foo", "bar").close();
        try {
            c = this.ds.getConnection("foob", "ar");
            throwable = null;
            try {
                TestPerUserPoolDataSource.fail((String)"Should have caused an SQLException");
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (c != null) {
                    if (throwable != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        c.close();
                    }
                }
            }
        }
        catch (SQLException expected) {
            // empty catch block
        }
        try {
            c = this.ds.getConnection("foo", "baz");
            throwable = null;
            try {
                TestPerUserPoolDataSource.fail((String)"Should have generated SQLException");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (c != null) {
                    if (throwable != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        c.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void testSimple() throws Exception {
        Connection conn = this.ds.getConnection();
        TestPerUserPoolDataSource.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        TestPerUserPoolDataSource.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        TestPerUserPoolDataSource.assertNotNull((Object)rset);
        TestPerUserPoolDataSource.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    public void testSimpleWithUsername() throws Exception {
        Connection conn = this.ds.getConnection("u1", "p1");
        TestPerUserPoolDataSource.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        TestPerUserPoolDataSource.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        TestPerUserPoolDataSource.assertNotNull((Object)rset);
        TestPerUserPoolDataSource.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
    }

    public void testClosingWithUserName() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection("u1", "p1");
        }
        c[0].close();
        TestPerUserPoolDataSource.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection("u1", "p1");
        for (Connection element : c) {
            element.close();
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection("u1", "p1");
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Override
    public void testSimple2() throws Exception {
        Connection conn = this.ds.getConnection();
        TestPerUserPoolDataSource.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        TestPerUserPoolDataSource.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        TestPerUserPoolDataSource.assertNotNull((Object)rset);
        TestPerUserPoolDataSource.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        TestPerUserPoolDataSource.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        TestPerUserPoolDataSource.assertNotNull((Object)rset);
        TestPerUserPoolDataSource.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        try (Statement s = conn.createStatement();){
            TestPerUserPoolDataSource.fail((String)"Can't use closed connections");
        }
        catch (SQLException e) {
            // empty catch block
        }
        conn = this.ds.getConnection();
        TestPerUserPoolDataSource.assertNotNull((Object)conn);
        stmt = conn.prepareStatement("select * from dual");
        TestPerUserPoolDataSource.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        TestPerUserPoolDataSource.assertNotNull((Object)rset);
        TestPerUserPoolDataSource.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        TestPerUserPoolDataSource.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        TestPerUserPoolDataSource.assertNotNull((Object)rset);
        TestPerUserPoolDataSource.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        conn = null;
    }

    @Override
    public void testOpening() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
            TestPerUserPoolDataSource.assertTrue((c[i] != null ? 1 : 0) != 0);
            for (int j = 0; j <= i; ++j) {
                TestPerUserPoolDataSource.assertTrue((!c[j].isClosed() ? 1 : 0) != 0);
            }
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Override
    public void testClosing() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
        }
        c[0].close();
        TestPerUserPoolDataSource.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection();
        for (Connection element : c) {
            element.close();
        }
    }

    @Override
    public void testMaxTotal() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
            TestPerUserPoolDataSource.assertTrue((c[i] != null ? 1 : 0) != 0);
        }
        try (Connection conn = this.ds.getConnection();){
            TestPerUserPoolDataSource.fail((String)"Allowed to open more than DefaultMaxTotal connections.");
        }
        catch (SQLException e) {
            // empty catch block
        }
        for (Connection element : c) {
            element.close();
        }
    }

    public void testMaxWaitMillisZero() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        tds.setDefaultMaxWaitMillis(0L);
        tds.setPerUserMaxTotal("u1", Integer.valueOf(1));
        Connection conn = tds.getConnection("u1", "p1");
        try (Connection c2 = tds.getConnection("u1", "p1");){
            TestPerUserPoolDataSource.fail((String)"Expecting Pool Exhausted exception");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn.close();
    }

    public void testPerUserMethods() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        tds.setPerUserMaxTotal("u1", Integer.valueOf(5));
        tds.setPerUserMaxTotal("u2", Integer.valueOf(5));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive());
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive("u1"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive("u2"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle());
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle("u1"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle("u2"));
        Connection conn = tds.getConnection();
        TestPerUserPoolDataSource.assertNotNull((Object)conn);
        TestPerUserPoolDataSource.assertEquals((int)1, (int)tds.getNumActive());
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive("u1"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive("u2"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle());
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle("u1"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle("u2"));
        conn.close();
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive());
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive("u1"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive("u2"));
        TestPerUserPoolDataSource.assertEquals((int)1, (int)tds.getNumIdle());
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle("u1"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle("u2"));
        conn = tds.getConnection("u1", "p1");
        TestPerUserPoolDataSource.assertNotNull((Object)conn);
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive());
        TestPerUserPoolDataSource.assertEquals((int)1, (int)tds.getNumActive("u1"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive("u2"));
        TestPerUserPoolDataSource.assertEquals((int)1, (int)tds.getNumIdle());
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle("u1"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle("u2"));
        conn.close();
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive());
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive("u1"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive("u2"));
        TestPerUserPoolDataSource.assertEquals((int)1, (int)tds.getNumIdle());
        TestPerUserPoolDataSource.assertEquals((int)1, (int)tds.getNumIdle("u1"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle("u2"));
    }

    public void testMultipleThreads1() throws Exception {
        int defaultMaxWaitMillis = 430;
        ((PerUserPoolDataSource)this.ds).setDefaultMaxWaitMillis(430L);
        ((PerUserPoolDataSource)this.ds).setPerUserMaxWaitMillis("foo", new Long(430L));
        this.multipleThreads(1, false, false, 430L);
    }

    public void testMultipleThreads2() throws Exception {
        int defaultMaxWaitMillis = 500;
        ((PerUserPoolDataSource)this.ds).setDefaultMaxWaitMillis(500L);
        ((PerUserPoolDataSource)this.ds).setPerUserMaxWaitMillis("foo", new Long(500L));
        this.multipleThreads(1000, true, true, 500L);
    }

    public void testTransactionIsolationBehavior() throws Exception {
        Connection conn = this.getConnection();
        TestPerUserPoolDataSource.assertNotNull((Object)conn);
        TestPerUserPoolDataSource.assertEquals((int)2, (int)conn.getTransactionIsolation());
        conn.setTransactionIsolation(1);
        conn.close();
        Connection conn2 = this.getConnection();
        TestPerUserPoolDataSource.assertEquals((int)2, (int)conn2.getTransactionIsolation());
        Connection conn3 = this.getConnection();
        TestPerUserPoolDataSource.assertEquals((int)2, (int)conn3.getTransactionIsolation());
        conn2.close();
        conn3.close();
    }

    public void testSerialization() throws Exception {
        Connection conn = this.ds.getConnection();
        conn.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(this.ds);
        byte[] b = baos.toByteArray();
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        ObjectInputStream in = new ObjectInputStream(bais);
        Object obj = in.readObject();
        in.close();
        TestPerUserPoolDataSource.assertEquals((int)1, (int)((PerUserPoolDataSource)obj).getNumIdle());
    }

    public void testUnregisteredUser() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive());
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle());
        Connection conn = tds.getConnection();
        TestPerUserPoolDataSource.assertNotNull((Object)conn);
        TestPerUserPoolDataSource.assertEquals((int)1, (int)tds.getNumActive());
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle());
        conn.close();
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive());
        TestPerUserPoolDataSource.assertEquals((int)1, (int)tds.getNumIdle());
        conn = tds.getConnection("u1", "p1");
        TestPerUserPoolDataSource.assertNotNull((Object)conn);
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive());
        TestPerUserPoolDataSource.assertEquals((int)1, (int)tds.getNumIdle());
        TestPerUserPoolDataSource.assertEquals((int)1, (int)tds.getNumActive("u1"));
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumIdle("u1"));
        conn.close();
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive());
        TestPerUserPoolDataSource.assertEquals((int)1, (int)tds.getNumIdle());
        TestPerUserPoolDataSource.assertEquals((int)0, (int)tds.getNumActive("u1"));
        TestPerUserPoolDataSource.assertEquals((int)1, (int)tds.getNumIdle("u1"));
    }

    public void testDefaultUser1() throws Exception {
        int i;
        TesterDriver.addUser("mkh", "password");
        TesterDriver.addUser("hanafey", "password");
        TesterDriver.addUser("jsmith", "password");
        PerUserPoolDataSource puds = (PerUserPoolDataSource)this.ds;
        puds.setPerUserMaxTotal("jsmith", Integer.valueOf(2));
        String[] users = new String[]{"mkh", "hanafey", "jsmith"};
        String password = "password";
        Connection[] c = new Connection[users.length];
        for (i = 0; i < users.length; ++i) {
            c[i] = puds.getConnection(users[i], password);
            TestPerUserPoolDataSource.assertEquals((String)users[i], (String)this.getUsername(c[i]));
        }
        for (i = 0; i < users.length; ++i) {
            c[i].close();
        }
    }

    public void testDefaultUser2() throws Exception {
        int i;
        TesterDriver.addUser("mkh", "password");
        TesterDriver.addUser("hanafey", "password");
        TesterDriver.addUser("jsmith", "password");
        PerUserPoolDataSource puds = (PerUserPoolDataSource)this.ds;
        puds.setPerUserMaxTotal("jsmith", Integer.valueOf(2));
        String[] users = new String[]{"jsmith", "hanafey", "mkh"};
        String password = "password";
        Connection[] c = new Connection[users.length];
        for (i = 0; i < users.length; ++i) {
            c[i] = puds.getConnection(users[i], password);
            TestPerUserPoolDataSource.assertEquals((String)users[i], (String)this.getUsername(c[i]));
        }
        for (i = 0; i < users.length; ++i) {
            c[i].close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChangePassword() throws Exception {
        try (Connection c = this.ds.getConnection("foo", "bay");){
            TestPerUserPoolDataSource.fail((String)"Should have generated SQLException");
        }
        catch (SQLException expected) {
            // empty catch block
        }
        Connection con1 = this.ds.getConnection("foo", "bar");
        Connection con2 = this.ds.getConnection("foo", "bar");
        Connection con3 = this.ds.getConnection("foo", "bar");
        con1.close();
        con2.close();
        TesterDriver.addUser("foo", "bay");
        try {
            Connection con4 = this.ds.getConnection("foo", "bay");
            TestPerUserPoolDataSource.assertEquals((String)"Should be no idle connections in the pool", (int)0, (int)((PerUserPoolDataSource)this.ds).getNumIdle("foo"));
            con4.close();
            TestPerUserPoolDataSource.assertEquals((String)"Should be one idle connection in the pool", (int)1, (int)((PerUserPoolDataSource)this.ds).getNumIdle("foo"));
            try (Connection c = this.ds.getConnection("foo", "bar");){
                TestPerUserPoolDataSource.fail((String)"Should have generated SQLException");
            }
            catch (SQLException expected) {
                // empty catch block
            }
            Connection con5 = this.ds.getConnection("foo", "bay");
            con3.close();
            this.ds.getConnection("foo", "bay").close();
            TestPerUserPoolDataSource.assertEquals((String)"Should be one idle connection in the pool", (int)1, (int)((PerUserPoolDataSource)this.ds).getNumIdle("foo"));
            con5.close();
        }
        finally {
            TesterDriver.addUser("foo", "bar");
        }
    }
}

