/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSource;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.apache.naming.java.javaURLContextFactory;

public class TestJndi
extends TestCase {
    protected static final String JNDI_SUBCONTEXT = "jdbc";
    protected static final String JNDI_PATH = "jdbc/jndiTestDataSource";
    protected Context context = null;

    public TestJndi(String name) {
        super(name);
    }

    public void testBasicDataSourceBind() throws Exception {
        BasicDataSource dataSource = new BasicDataSource();
        this.checkBind((DataSource)dataSource);
    }

    public void testSharedPoolDataSourceBind() throws Exception {
        SharedPoolDataSource dataSource = new SharedPoolDataSource();
        this.checkBind((DataSource)dataSource);
    }

    public void testPerUserPoolDataSourceBind() throws Exception {
        PerUserPoolDataSource dataSource = new PerUserPoolDataSource();
        this.checkBind((DataSource)dataSource);
    }

    public void setUp() throws Exception {
        this.context = this.getInitialContext();
        this.context.createSubcontext(JNDI_SUBCONTEXT);
    }

    public void tearDown() throws Exception {
        this.context.unbind(JNDI_PATH);
        this.context.destroySubcontext(JNDI_SUBCONTEXT);
    }

    protected void checkBind(DataSource dataSource) throws Exception {
        this.bindDataSource(dataSource);
        this.retrieveDataSource();
    }

    protected void bindDataSource(DataSource dataSource) throws Exception {
        this.context.bind(JNDI_PATH, (Object)dataSource);
    }

    protected DataSource retrieveDataSource() throws Exception {
        InitialContext ctx = this.getInitialContext();
        DataSource dataSource = (DataSource)ctx.lookup(JNDI_PATH);
        if (dataSource == null) {
            TestJndi.fail((String)"DataSource should not be null");
        }
        return dataSource;
    }

    protected InitialContext getInitialContext() throws NamingException {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", javaURLContextFactory.class.getName());
        InitialContext ctx = new InitialContext(environment);
        return ctx;
    }
}

