/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterClassLoader;
import org.apache.commons.dbcp2.TesterConnRequestCountDriver;
import org.apache.commons.dbcp2.TesterConnection;

public class TestBasicDataSource
extends TestConnectionPool {
    protected BasicDataSource ds = null;
    private static final String CATALOG = "test catalog";

    public TestBasicDataSource(String testName) {
        super(testName);
    }

    @Override
    protected Connection getConnection() throws Exception {
        return this.ds.getConnection();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.ds = this.createDataSource();
        this.ds.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
        this.ds.setUrl("jdbc:apache:commons:testdriver");
        this.ds.setMaxTotal(this.getMaxTotal());
        this.ds.setMaxWaitMillis(this.getMaxWaitMillis());
        this.ds.setDefaultAutoCommit(Boolean.TRUE);
        this.ds.setDefaultReadOnly(Boolean.FALSE);
        this.ds.setDefaultTransactionIsolation(2);
        this.ds.setDefaultCatalog(CATALOG);
        this.ds.setUsername("username");
        this.ds.setPassword("password");
        this.ds.setValidationQuery("SELECT DUMMY FROM DUAL");
        this.ds.setConnectionInitSqls(Arrays.asList("SELECT 1", "SELECT 2"));
        this.ds.setDriverClassLoader((ClassLoader)new TesterClassLoader());
        this.ds.setJmxName("org.apache.commons.dbcp2:name=test");
    }

    protected BasicDataSource createDataSource() throws Exception {
        return new BasicDataSource();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.ds.close();
        this.ds = null;
    }

    public void testClose() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection activeConnection = this.getConnection();
        Connection rawActiveConnection = ((DelegatingConnection)activeConnection).getInnermostDelegate();
        TestBasicDataSource.assertFalse((boolean)activeConnection.isClosed());
        TestBasicDataSource.assertFalse((boolean)rawActiveConnection.isClosed());
        Connection idleConnection = this.getConnection();
        Connection rawIdleConnection = ((DelegatingConnection)idleConnection).getInnermostDelegate();
        TestBasicDataSource.assertFalse((boolean)idleConnection.isClosed());
        TestBasicDataSource.assertFalse((boolean)rawIdleConnection.isClosed());
        idleConnection.close();
        TestBasicDataSource.assertTrue((boolean)idleConnection.isClosed());
        TestBasicDataSource.assertFalse((boolean)rawIdleConnection.isClosed());
        this.ds.close();
        TestBasicDataSource.assertTrue((boolean)rawIdleConnection.isClosed());
        TestBasicDataSource.assertFalse((boolean)activeConnection.isClosed());
        TestBasicDataSource.assertFalse((boolean)rawActiveConnection.isClosed());
        activeConnection.close();
        TestBasicDataSource.assertTrue((boolean)activeConnection.isClosed());
        TestBasicDataSource.assertTrue((boolean)rawActiveConnection.isClosed());
        try {
            this.getConnection();
            TestBasicDataSource.fail((String)"Expecting SQLException");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        this.ds.close();
    }

    public void testSetProperties() throws Exception {
        this.ds.setConnectionProperties("name1=value1;name2=value2;name3=value3");
        TestBasicDataSource.assertEquals((int)3, (int)this.ds.getConnectionProperties().size());
        TestBasicDataSource.assertEquals((String)"value1", (String)this.ds.getConnectionProperties().getProperty("name1"));
        TestBasicDataSource.assertEquals((String)"value2", (String)this.ds.getConnectionProperties().getProperty("name2"));
        TestBasicDataSource.assertEquals((String)"value3", (String)this.ds.getConnectionProperties().getProperty("name3"));
        this.ds.setConnectionProperties("name1=value1;name2=value2");
        TestBasicDataSource.assertEquals((int)2, (int)this.ds.getConnectionProperties().size());
        TestBasicDataSource.assertEquals((String)"value1", (String)this.ds.getConnectionProperties().getProperty("name1"));
        TestBasicDataSource.assertEquals((String)"value2", (String)this.ds.getConnectionProperties().getProperty("name2"));
        TestBasicDataSource.assertFalse((boolean)this.ds.getConnectionProperties().containsKey("name3"));
        this.ds.setConnectionProperties("name1=value1;name2");
        TestBasicDataSource.assertEquals((int)2, (int)this.ds.getConnectionProperties().size());
        TestBasicDataSource.assertEquals((String)"value1", (String)this.ds.getConnectionProperties().getProperty("name1"));
        TestBasicDataSource.assertEquals((String)"", (String)this.ds.getConnectionProperties().getProperty("name2"));
        this.ds.setConnectionProperties("name1=value1;name2=");
        TestBasicDataSource.assertEquals((int)2, (int)this.ds.getConnectionProperties().size());
        TestBasicDataSource.assertEquals((String)"value1", (String)this.ds.getConnectionProperties().getProperty("name1"));
        TestBasicDataSource.assertEquals((String)"", (String)this.ds.getConnectionProperties().getProperty("name2"));
        this.ds.setConnectionProperties("name1=value1");
        TestBasicDataSource.assertEquals((int)1, (int)this.ds.getConnectionProperties().size());
        TestBasicDataSource.assertEquals((String)"value1", (String)this.ds.getConnectionProperties().getProperty("name1"));
        this.ds.setConnectionProperties("name1=value1;");
        TestBasicDataSource.assertEquals((int)1, (int)this.ds.getConnectionProperties().size());
        TestBasicDataSource.assertEquals((String)"value1", (String)this.ds.getConnectionProperties().getProperty("name1"));
        this.ds.setConnectionProperties("name1");
        TestBasicDataSource.assertEquals((int)1, (int)this.ds.getConnectionProperties().size());
        TestBasicDataSource.assertEquals((String)"", (String)this.ds.getConnectionProperties().getProperty("name1"));
        try {
            this.ds.setConnectionProperties(null);
            TestBasicDataSource.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testTransactionIsolationBehavior() throws Exception {
        Connection conn = this.getConnection();
        TestBasicDataSource.assertNotNull((Object)conn);
        TestBasicDataSource.assertEquals((int)2, (int)conn.getTransactionIsolation());
        conn.setTransactionIsolation(1);
        conn.close();
        Connection conn2 = this.getConnection();
        TestBasicDataSource.assertEquals((int)2, (int)conn2.getTransactionIsolation());
        Connection conn3 = this.getConnection();
        TestBasicDataSource.assertEquals((int)2, (int)conn3.getTransactionIsolation());
        conn2.close();
        conn3.close();
    }

    @Override
    public void testPooling() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        super.testPooling();
    }

    public void testNoAccessToUnderlyingConnectionAllowed() throws Exception {
        TestBasicDataSource.assertEquals((boolean)false, (boolean)this.ds.isAccessToUnderlyingConnectionAllowed());
        Connection conn = this.getConnection();
        Connection dconn = ((DelegatingConnection)conn).getDelegate();
        TestBasicDataSource.assertNull((Object)dconn);
        dconn = ((DelegatingConnection)conn).getInnermostDelegate();
        TestBasicDataSource.assertNull((Object)dconn);
    }

    public void testAccessToUnderlyingConnectionAllowed() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        TestBasicDataSource.assertEquals((boolean)true, (boolean)this.ds.isAccessToUnderlyingConnectionAllowed());
        Connection conn = this.getConnection();
        Connection dconn = ((DelegatingConnection)conn).getDelegate();
        TestBasicDataSource.assertNotNull((Object)dconn);
        dconn = ((DelegatingConnection)conn).getInnermostDelegate();
        TestBasicDataSource.assertNotNull((Object)dconn);
        TestBasicDataSource.assertTrue((boolean)(dconn instanceof TesterConnection));
    }

    public void testEmptyValidationQuery() throws Exception {
        TestBasicDataSource.assertNotNull((Object)this.ds.getValidationQuery());
        this.ds.setValidationQuery("");
        TestBasicDataSource.assertNull((Object)this.ds.getValidationQuery());
        this.ds.setValidationQuery("   ");
        TestBasicDataSource.assertNull((Object)this.ds.getValidationQuery());
    }

    public void testInvalidValidationQuery() {
        block14: {
            this.ds.setValidationQuery("invalid");
            try (Connection c = this.ds.getConnection();){
                TestBasicDataSource.fail((String)"expected SQLException");
            }
            catch (SQLException e) {
                if (e.toString().indexOf("invalid") >= 0) break block14;
                TestBasicDataSource.fail((String)"expected detailed error message");
            }
        }
    }

    public void testValidationQueryTimoutFail() {
        block14: {
            this.ds.setTestOnBorrow(true);
            this.ds.setValidationQueryTimeout(3);
            try (Connection c = this.ds.getConnection();){
                TestBasicDataSource.fail((String)"expected SQLException");
            }
            catch (SQLException ex) {
                if (ex.toString().indexOf("timeout") >= 0) break block14;
                TestBasicDataSource.fail((String)"expected timeout error message");
            }
        }
    }

    public void testValidationQueryTimeoutZero() throws Exception {
        this.ds.setTestOnBorrow(true);
        this.ds.setTestOnReturn(true);
        this.ds.setValidationQueryTimeout(0);
        Connection con = this.ds.getConnection();
        con.close();
    }

    public void testValidationQueryTimeoutNegative() throws Exception {
        this.ds.setTestOnBorrow(true);
        this.ds.setTestOnReturn(true);
        this.ds.setValidationQueryTimeout(-1);
        Connection con = this.ds.getConnection();
        con.close();
    }

    public void testValidationQueryTimeoutSucceed() throws Exception {
        this.ds.setTestOnBorrow(true);
        this.ds.setTestOnReturn(true);
        this.ds.setValidationQueryTimeout(100);
        Connection con = this.ds.getConnection();
        con.close();
    }

    public void testEmptyInitConnectionSql() throws Exception {
        this.ds.setConnectionInitSqls(Arrays.asList("", "   "));
        TestBasicDataSource.assertNotNull((Object)this.ds.getConnectionInitSqls());
        TestBasicDataSource.assertEquals((int)0, (int)this.ds.getConnectionInitSqls().size());
        this.ds.setConnectionInitSqls(null);
        TestBasicDataSource.assertNotNull((Object)this.ds.getConnectionInitSqls());
        TestBasicDataSource.assertEquals((int)0, (int)this.ds.getConnectionInitSqls().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidConnectionInitSql() {
        block8: {
            try {
                this.ds.setConnectionInitSqls(Arrays.asList("SELECT 1", "invalid"));
                Connection c = this.ds.getConnection();
                Throwable throwable = null;
                if (c != null) {
                    if (throwable != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        c.close();
                    }
                }
                TestBasicDataSource.fail((String)"expected SQLException");
            }
            catch (SQLException e) {
                if (e.toString().indexOf("invalid") >= 0) break block8;
                TestBasicDataSource.fail((String)"expected detailed error message");
            }
        }
    }

    public void testSetValidationTestProperties() {
        TestBasicDataSource.assertEquals((boolean)true, (boolean)this.ds.getTestOnBorrow());
        TestBasicDataSource.assertEquals((boolean)false, (boolean)this.ds.getTestOnReturn());
        TestBasicDataSource.assertEquals((boolean)false, (boolean)this.ds.getTestWhileIdle());
        this.ds.setTestOnBorrow(true);
        this.ds.setTestOnReturn(true);
        this.ds.setTestWhileIdle(true);
        TestBasicDataSource.assertEquals((boolean)true, (boolean)this.ds.getTestOnBorrow());
        TestBasicDataSource.assertEquals((boolean)true, (boolean)this.ds.getTestOnReturn());
        TestBasicDataSource.assertEquals((boolean)true, (boolean)this.ds.getTestWhileIdle());
        this.ds.setTestOnBorrow(false);
        this.ds.setTestOnReturn(false);
        this.ds.setTestWhileIdle(false);
        TestBasicDataSource.assertEquals((boolean)false, (boolean)this.ds.getTestOnBorrow());
        TestBasicDataSource.assertEquals((boolean)false, (boolean)this.ds.getTestOnReturn());
        TestBasicDataSource.assertEquals((boolean)false, (boolean)this.ds.getTestWhileIdle());
    }

    public void testDefaultCatalog() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.getConnection();
            TestBasicDataSource.assertTrue((c[i] != null ? 1 : 0) != 0);
            TestBasicDataSource.assertEquals((String)CATALOG, (String)c[i].getCatalog());
        }
        for (Connection element : c) {
            element.setCatalog("error");
            element.close();
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.getConnection();
            TestBasicDataSource.assertTrue((c[i] != null ? 1 : 0) != 0);
            TestBasicDataSource.assertEquals((String)CATALOG, (String)c[i].getCatalog());
        }
        for (Connection element : c) {
            element.close();
        }
    }

    public void testSetAutoCommitTrueOnClose() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        this.ds.setDefaultAutoCommit(Boolean.FALSE);
        Connection conn = this.getConnection();
        TestBasicDataSource.assertNotNull((Object)conn);
        TestBasicDataSource.assertEquals((boolean)false, (boolean)conn.getAutoCommit());
        Connection dconn = ((DelegatingConnection)conn).getInnermostDelegate();
        TestBasicDataSource.assertNotNull((Object)dconn);
        TestBasicDataSource.assertEquals((boolean)false, (boolean)dconn.getAutoCommit());
        conn.close();
        TestBasicDataSource.assertEquals((boolean)true, (boolean)dconn.getAutoCommit());
    }

    public void testInitialSize() throws Exception {
        this.ds.setMaxTotal(20);
        this.ds.setMaxIdle(20);
        this.ds.setInitialSize(10);
        Connection conn = this.getConnection();
        TestBasicDataSource.assertNotNull((Object)conn);
        conn.close();
        TestBasicDataSource.assertEquals((int)0, (int)this.ds.getNumActive());
        TestBasicDataSource.assertEquals((int)10, (int)this.ds.getNumIdle());
    }

    public void testIsClosedFailure() throws SQLException {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn = this.ds.getConnection();
        TestBasicDataSource.assertNotNull((Object)conn);
        TestBasicDataSource.assertEquals((int)1, (int)this.ds.getNumActive());
        TesterConnection tconn = (TesterConnection)((DelegatingConnection)conn).getInnermostDelegate();
        tconn.setFailure(new IOException("network error"));
        try {
            conn.close();
            TestBasicDataSource.fail((String)"Expected SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        TestBasicDataSource.assertEquals((int)0, (int)this.ds.getNumActive());
    }

    public void testPropertyTestOnReturn() throws Exception {
        this.ds.setValidationQuery("select 1 from dual");
        this.ds.setTestOnBorrow(false);
        this.ds.setTestWhileIdle(false);
        this.ds.setTestOnReturn(true);
        Connection conn = this.ds.getConnection();
        TestBasicDataSource.assertNotNull((Object)conn);
        TestBasicDataSource.assertEquals((boolean)false, (boolean)this.ds.getConnectionPool().getTestOnBorrow());
        TestBasicDataSource.assertEquals((boolean)false, (boolean)this.ds.getConnectionPool().getTestWhileIdle());
        TestBasicDataSource.assertEquals((boolean)true, (boolean)this.ds.getConnectionPool().getTestOnReturn());
    }

    public void testRollbackReadOnly() throws Exception {
        this.ds.setDefaultReadOnly(Boolean.TRUE);
        this.ds.setDefaultAutoCommit(Boolean.FALSE);
        Connection conn = this.ds.getConnection();
        TestBasicDataSource.assertNotNull((Object)conn);
        conn.close();
    }

    public void testMaxTotalZero() throws Exception {
        this.ds.setMaxTotal(0);
        try {
            Connection conn = this.ds.getConnection();
            TestBasicDataSource.assertNotNull((Object)conn);
            TestBasicDataSource.fail((String)"SQLException expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateDataSourceCleanupThreads() throws Exception {
        this.ds.close();
        this.ds = null;
        this.ds = this.createDataSource();
        this.ds.setDriverClassName("org.apache.commons.dbcp2.TesterDriver");
        this.ds.setUrl("jdbc:apache:commons:testdriver");
        this.ds.setMaxTotal(this.getMaxTotal());
        this.ds.setMaxWaitMillis(this.getMaxWaitMillis());
        this.ds.setDefaultAutoCommit(Boolean.TRUE);
        this.ds.setDefaultReadOnly(Boolean.FALSE);
        this.ds.setDefaultTransactionIsolation(2);
        this.ds.setDefaultCatalog(CATALOG);
        this.ds.setUsername("username");
        this.ds.setTimeBetweenEvictionRunsMillis(100L);
        this.ds.setPassword("wrong");
        this.ds.setValidationQuery("SELECT DUMMY FROM DUAL");
        int threadCount = Thread.activeCount();
        for (int i = 0; i < 10; ++i) {
            try {
                Connection c = this.ds.getConnection();
                Throwable throwable = null;
                if (c == null) continue;
                if (throwable != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                c.close();
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        TestBasicDataSource.assertTrue((Thread.activeCount() <= threadCount + 1 ? 1 : 0) != 0);
    }

    public void testDriverClassLoader() throws Exception {
        this.getConnection();
        ClassLoader cl = this.ds.getDriverClassLoader();
        TestBasicDataSource.assertNotNull((Object)cl);
        TestBasicDataSource.assertTrue((boolean)(cl instanceof TesterClassLoader));
        TestBasicDataSource.assertTrue((boolean)((TesterClassLoader)cl).didLoad(this.ds.getDriverClassName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateDataSourceCleanupEvictor() throws Exception {
        this.ds.close();
        this.ds = null;
        this.ds = this.createDataSource();
        this.ds.setDriverClassName("org.apache.commons.dbcp2.TesterConnRequestCountDriver");
        this.ds.setUrl("jdbc:apache:commons:testerConnRequestCountDriver");
        this.ds.setValidationQuery("SELECT DUMMY FROM DUAL");
        this.ds.setUsername("username");
        this.ds.setPassword("wrong");
        this.ds.setTimeBetweenEvictionRunsMillis(100L);
        this.ds.setMinIdle(2);
        Class<TesterConnRequestCountDriver> clazz = TesterConnRequestCountDriver.class;
        synchronized (TesterConnRequestCountDriver.class) {
            TesterConnRequestCountDriver.initConnRequestCount();
            for (int i = 0; i < 10; ++i) {
                try {
                    DataSource ds2 = this.ds.createDataSource();
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            Thread.sleep(1000L);
            TestBasicDataSource.assertEquals((int)10, (int)TesterConnRequestCountDriver.getConnectionRequestCount());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TestBasicDataSource.assertNull((Object)this.ds.getConnectionPool());
            return;
        }
    }
}

