/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import junit.framework.TestCase;
import org.apache.commons.compress.harmony.unpack200.Segment;

public class SegmentTest
extends TestCase {
    InputStream in;
    JarOutputStream out;
    File file;

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.file.delete();
    }

    public void testJustResources() throws Exception {
        this.in = Segment.class.getResourceAsStream("/pack200/JustResources.pack");
        this.file = File.createTempFile("just", "resources.jar");
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Segment segment = new Segment();
        segment.unpack(this.in, this.out);
    }

    public void testInterfaceOnly() throws Exception {
        this.in = Segment.class.getResourceAsStream("/pack200/InterfaceOnly.pack");
        this.file = File.createTempFile("Interface", "Only.jar");
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Segment segment = new Segment();
        segment.unpack(this.in, this.out);
    }

    public void testHelloWorld() throws Exception {
        this.in = Segment.class.getResourceAsStream("/pack200/HelloWorld.pack");
        this.file = File.createTempFile("hello", "world.jar");
        this.file.deleteOnExit();
        this.out = new JarOutputStream(new FileOutputStream(this.file));
        Segment segment = new Segment();
        segment.unpack(this.in, this.out);
        this.out.close();
        this.out = null;
        JarFile jarFile = new JarFile(this.file);
        JarEntry entry = jarFile.getJarEntry("org/apache/harmony/archive/tests/internal/pack200/HelloWorld.class");
        SegmentTest.assertNotNull((Object)entry);
        InputStream ours = jarFile.getInputStream(entry);
        JarFile jarFile2 = new JarFile(new File(Segment.class.getResource("/pack200/hw.jar").toURI()));
        JarEntry entry2 = jarFile2.getJarEntry("org/apache/harmony/archive/tests/internal/pack200/HelloWorld.class");
        SegmentTest.assertNotNull((Object)entry2);
        InputStream expected = jarFile2.getInputStream(entry2);
        BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
        BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));
        String line1 = reader1.readLine();
        String line2 = reader2.readLine();
        int i = 1;
        while (line1 != null || line2 != null) {
            SegmentTest.assertEquals((String)"Unpacked class files differ", (String)line2, (String)line1);
            line1 = reader1.readLine();
            line2 = reader2.readLine();
            ++i;
        }
        reader1.close();
        reader2.close();
    }
}

