/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.compress.harmony.unpack200.SegmentConstantPoolArrayCache;

public class SegmentConstantPoolArrayCacheTest
extends TestCase {
    public void testSingleSimpleArray() {
        SegmentConstantPoolArrayCache arrayCache = new SegmentConstantPoolArrayCache();
        String[] array = new String[]{"Zero", "One", "Two", "Three", "Four"};
        List list = arrayCache.indexesForArrayKey(array, "Three");
        SegmentConstantPoolArrayCacheTest.assertEquals((int)1, (int)list.size());
        SegmentConstantPoolArrayCacheTest.assertEquals((int)3, (int)((Integer)list.get(0)));
    }

    public void testSingleMultipleHitArray() {
        SegmentConstantPoolArrayCache arrayCache = new SegmentConstantPoolArrayCache();
        String[] array = new String[]{"Zero", "OneThreeFour", "Two", "OneThreeFour", "OneThreeFour"};
        List list = arrayCache.indexesForArrayKey(array, "OneThreeFour");
        SegmentConstantPoolArrayCacheTest.assertEquals((int)3, (int)list.size());
        SegmentConstantPoolArrayCacheTest.assertEquals((int)1, (int)((Integer)list.get(0)));
        SegmentConstantPoolArrayCacheTest.assertEquals((int)3, (int)((Integer)list.get(1)));
        SegmentConstantPoolArrayCacheTest.assertEquals((int)4, (int)((Integer)list.get(2)));
    }

    public void testMultipleArrayMultipleHit() {
        SegmentConstantPoolArrayCache arrayCache = new SegmentConstantPoolArrayCache();
        String[] arrayOne = new String[]{"Zero", "Shared", "Two", "Shared", "Shared"};
        String[] arrayTwo = new String[]{"Shared", "One", "Shared", "Shared", "Shared"};
        List listOne = arrayCache.indexesForArrayKey(arrayOne, "Shared");
        List listTwo = arrayCache.indexesForArrayKey(arrayTwo, "Shared");
        listOne = arrayCache.indexesForArrayKey(arrayOne, "Two");
        listTwo = arrayCache.indexesForArrayKey(arrayTwo, "Shared");
        SegmentConstantPoolArrayCacheTest.assertEquals((int)1, (int)listOne.size());
        SegmentConstantPoolArrayCacheTest.assertEquals((int)2, (int)((Integer)listOne.get(0)));
        listOne = arrayCache.indexesForArrayKey(arrayOne, "Shared");
        SegmentConstantPoolArrayCacheTest.assertEquals((int)3, (int)listOne.size());
        SegmentConstantPoolArrayCacheTest.assertEquals((int)1, (int)((Integer)listOne.get(0)));
        SegmentConstantPoolArrayCacheTest.assertEquals((int)3, (int)((Integer)listOne.get(1)));
        SegmentConstantPoolArrayCacheTest.assertEquals((int)4, (int)((Integer)listOne.get(2)));
        SegmentConstantPoolArrayCacheTest.assertEquals((int)4, (int)listTwo.size());
        SegmentConstantPoolArrayCacheTest.assertEquals((int)0, (int)((Integer)listTwo.get(0)));
        SegmentConstantPoolArrayCacheTest.assertEquals((int)2, (int)((Integer)listTwo.get(1)));
        SegmentConstantPoolArrayCacheTest.assertEquals((int)3, (int)((Integer)listTwo.get(2)));
        SegmentConstantPoolArrayCacheTest.assertEquals((int)4, (int)((Integer)listTwo.get(3)));
        List listThree = arrayCache.indexesForArrayKey(arrayOne, "Not found");
        SegmentConstantPoolArrayCacheTest.assertEquals((int)0, (int)listThree.size());
    }
}

