/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.dump;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.dump.DumpArchiveEntry;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.commons.compress.archivers.dump.ShortFileException;
import org.apache.commons.compress.archivers.dump.UnrecognizedFormatException;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class DumpArchiveInputStreamTest
extends AbstractTestCase {
    @Test
    public void testNotADumpArchive() throws Exception {
        try (InputStream is = Files.newInputStream(DumpArchiveInputStreamTest.getFile("bla.zip").toPath(), new OpenOption[0]);){
            new DumpArchiveInputStream(is).close();
            Assert.fail((String)"expected an exception");
        }
        catch (ArchiveException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof ShortFileException));
        }
    }

    @Test
    public void testNotADumpArchiveButBigEnough() throws Exception {
        try (InputStream is = Files.newInputStream(DumpArchiveInputStreamTest.getFile("zip64support.tar.bz2").toPath(), new OpenOption[0]);){
            new DumpArchiveInputStream(is).close();
            Assert.fail((String)"expected an exception");
        }
        catch (ArchiveException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof UnrecognizedFormatException));
        }
    }

    @Test
    public void testConsumesArchiveCompletely() throws Exception {
        InputStream is = DumpArchiveInputStreamTest.class.getResourceAsStream("/archive_with_trailer.dump");
        DumpArchiveInputStream dump = new DumpArchiveInputStream(is);
        while (dump.getNextDumpEntry() != null) {
        }
        byte[] expected = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10};
        byte[] actual = new byte[expected.length];
        is.read(actual);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        dump.close();
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (InputStream in = Files.newInputStream(DumpArchiveInputStreamTest.getFile("bla.dump").toPath(), new OpenOption[0]);
             DumpArchiveInputStream archive = new DumpArchiveInputStream(in);){
            DumpArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read());
            Assert.assertEquals((long)-1L, (long)archive.read());
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = Files.newInputStream(DumpArchiveInputStreamTest.getFile("bla.dump").toPath(), new OpenOption[0]);
             DumpArchiveInputStream archive = new DumpArchiveInputStream(in);){
            DumpArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
        }
    }
}

