/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public final class ArTestCase
extends AbstractTestCase {
    @Test
    public void testArArchiveCreation() throws Exception {
        File output = new File(this.dir, "bla.ar");
        File file1 = ArTestCase.getFile("test1.xml");
        File file2 = ArTestCase.getFile("test2.xml");
        OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
        ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("ar", out);
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test1.xml", file1.length()));
        IOUtils.copy((InputStream)Files.newInputStream(file1.toPath(), new OpenOption[0]), (OutputStream)os);
        os.closeArchiveEntry();
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test2.xml", file2.length()));
        IOUtils.copy((InputStream)Files.newInputStream(file2.toPath(), new OpenOption[0]), (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
    }

    @Test
    public void testArUnarchive() throws Exception {
        File output = new File(this.dir, "bla.ar");
        File file1 = ArTestCase.getFile("test1.xml");
        File file2 = ArTestCase.getFile("test2.xml");
        OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
        ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("ar", out);
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test1.xml", file1.length()));
        IOUtils.copy((InputStream)Files.newInputStream(file1.toPath(), new OpenOption[0]), (OutputStream)os);
        os.closeArchiveEntry();
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test2.xml", file2.length()));
        IOUtils.copy((InputStream)Files.newInputStream(file2.toPath(), new OpenOption[0]), (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
        out.close();
        try (InputStream is = Files.newInputStream(output.toPath(), new OpenOption[0]);
             ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));){
            ArArchiveEntry entry = (ArArchiveEntry)in.getNextEntry();
            File target = new File(this.dir, entry.getName());
            try (OutputStream out2 = Files.newOutputStream(target.toPath(), new OpenOption[0]);){
                IOUtils.copy((InputStream)in, (OutputStream)out2);
            }
        }
    }

    @Test
    public void testArDelete() throws Exception {
        ArArchiveEntry entry;
        ArArchiveEntry entry2;
        File output = new File(this.dir, "bla.ar");
        File file1 = ArTestCase.getFile("test1.xml");
        File file2 = ArTestCase.getFile("test2.xml");
        OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
        ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("ar", out);
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test1.xml", file1.length()));
        IOUtils.copy((InputStream)Files.newInputStream(file1.toPath(), new OpenOption[0]), (OutputStream)os);
        os.closeArchiveEntry();
        os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test2.xml", file2.length()));
        IOUtils.copy((InputStream)Files.newInputStream(file2.toPath(), new OpenOption[0]), (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
        out.close();
        Assert.assertEquals((long)(68L + file1.length() + file1.length() % 2L + 60L + file2.length() + file2.length() % 2L), (long)output.length());
        File output2 = new File(this.dir, "bla2.ar");
        int copied = 0;
        int deleted = 0;
        InputStream is = Files.newInputStream(output.toPath(), new OpenOption[0]);
        OutputStream os2 = Files.newOutputStream(output2.toPath(), new OpenOption[0]);
        ArchiveOutputStream aos = new ArchiveStreamFactory().createArchiveOutputStream("ar", os2);
        ArchiveInputStream ais = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));
        while ((entry2 = (ArArchiveEntry)ais.getNextEntry()) != null) {
            if ("test1.xml".equals(entry2.getName())) {
                aos.putArchiveEntry((ArchiveEntry)entry2);
                IOUtils.copy((InputStream)ais, (OutputStream)aos);
                aos.closeArchiveEntry();
                ++copied;
                continue;
            }
            IOUtils.copy((InputStream)ais, (OutputStream)new ByteArrayOutputStream());
            ++deleted;
        }
        ais.close();
        aos.close();
        is.close();
        os2.close();
        Assert.assertEquals((long)1L, (long)copied);
        Assert.assertEquals((long)1L, (long)deleted);
        Assert.assertEquals((long)(68L + file1.length() + file1.length() % 2L), (long)output2.length());
        long files = 0L;
        long sum = 0L;
        InputStream is2 = Files.newInputStream(output2.toPath(), new OpenOption[0]);
        ArchiveInputStream ais2 = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is2));
        while ((entry = (ArArchiveEntry)ais2.getNextEntry()) != null) {
            IOUtils.copy((InputStream)ais2, (OutputStream)new ByteArrayOutputStream());
            sum += entry.getLength();
            ++files;
        }
        ais2.close();
        is2.close();
        Assert.assertEquals((long)1L, (long)files);
        Assert.assertEquals((long)file1.length(), (long)sum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void XtestDirectoryEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        try {
            archive = File.createTempFile("test.", ".ar", tmp[0]);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            long beforeArchiveWrite = tmp[0].lastModified();
            ArArchiveEntry in = new ArArchiveEntry(tmp[0], "foo");
            aos.putArchiveEntry((ArchiveEntry)in);
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo/", (Object)out.getName());
            Assert.assertEquals((long)0L, (long)out.getSize());
            Assert.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            ArTestCase.tryHardToDelete(tmp[1]);
            ArTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void XtestExplicitDirectoryEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        try {
            archive = File.createTempFile("test.", ".ar", tmp[0]);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            long beforeArchiveWrite = tmp[0].lastModified();
            ArArchiveEntry in = new ArArchiveEntry("foo", 0L, 0, 0, 0, tmp[1].lastModified() / 1000L);
            aos.putArchiveEntry((ArchiveEntry)in);
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo/", (Object)out.getName());
            Assert.assertEquals((long)0L, (long)out.getSize());
            Assert.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            ArTestCase.tryHardToDelete(tmp[1]);
            ArTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        InputStream fis = null;
        File directory = tmp[0];
        File file = tmp[1];
        try {
            archive = File.createTempFile("test.", ".ar", directory);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry in = new ArArchiveEntry(file, "foo");
            aos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)file.length()];
            fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
            while (fis.read(b) > 0) {
                aos.write(b);
            }
            fis.close();
            fis = null;
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo", (Object)out.getName());
            Assert.assertEquals((long)file.length(), (long)out.getSize());
            Assert.assertEquals((long)(file.lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            ArTestCase.tryHardToDelete(file);
            ArTestCase.rmdir(directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileEntryFromPath() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        InputStream fis = null;
        File directory = tmp[0];
        File file = tmp[1];
        try {
            archive = File.createTempFile("test.", ".ar", directory);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry in = new ArArchiveEntry(file.toPath(), "foo", new LinkOption[0]);
            aos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)file.length()];
            fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
            while (fis.read(b) > 0) {
                aos.write(b);
            }
            fis.close();
            fis = null;
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo", (Object)out.getName());
            Assert.assertEquals((long)file.length(), (long)out.getSize());
            Assert.assertEquals((long)(file.lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            ArTestCase.tryHardToDelete(file);
            ArTestCase.rmdir(directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitFileEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        InputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".ar", tmp[0]);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry in = new ArArchiveEntry("foo", tmp[1].length(), 0, 0, 0, tmp[1].lastModified() / 1000L);
            aos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = Files.newInputStream(tmp[1].toPath(), new OpenOption[0]);
            while (fis.read(b) > 0) {
                aos.write(b);
            }
            fis.close();
            fis = null;
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo", (Object)out.getName());
            Assert.assertEquals((long)tmp[1].length(), (long)out.getSize());
            Assert.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assert.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            ArTestCase.tryHardToDelete(tmp[1]);
            ArTestCase.rmdir(tmp[0]);
        }
    }
}

