/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.tweak.transactions;

import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.exceptions.TransactionFailedException;
import org.skife.jdbi.v2.tweak.TransactionHandler;
import org.skife.jdbi.v2.tweak.transactions.SerializableTransactionRunner;

public class TestSerializableTransactionRunner
extends DBITestCase {
    @Override
    protected TransactionHandler getTransactionHandler() {
        return new SerializableTransactionRunner();
    }

    @Test
    public void testEventuallyFails() throws Exception {
        final AtomicInteger tries = new AtomicInteger(5);
        BasicHandle handle = this.openHandle();
        try {
            handle.inTransaction(TransactionIsolationLevel.SERIALIZABLE, (TransactionCallback)new TransactionCallback<Void>(){

                public Void inTransaction(Handle conn, TransactionStatus status) throws Exception {
                    tries.decrementAndGet();
                    throw new SQLException("serialization", "40001");
                }
            });
        }
        catch (TransactionFailedException e) {
            Assert.assertEquals((Object)"40001", (Object)((SQLException)e.getCause()).getSQLState());
        }
        Assert.assertEquals((long)0L, (long)tries.get());
    }

    @Test
    public void testEventuallySucceeds() throws Exception {
        final AtomicInteger tries = new AtomicInteger(3);
        BasicHandle handle = this.openHandle();
        handle.inTransaction(TransactionIsolationLevel.SERIALIZABLE, (TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle conn, TransactionStatus status) throws Exception {
                if (tries.decrementAndGet() == 0) {
                    return null;
                }
                throw new SQLException("serialization", "40001");
            }
        });
        Assert.assertEquals((long)0L, (long)tries.get());
    }
}

