/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.stringtemplate;

import java.util.HashMap;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.stringtemplate.Kombucha;
import org.skife.jdbi.v2.sqlobject.stringtemplate.StringTemplate3StatementLocator;
import org.skife.jdbi.v2.sqlobject.stringtemplate.SuperDrink;
import org.skife.jdbi.v2.sqlobject.stringtemplate.TestingStatementContext;

public class TestStringTemplate3StatementLocatorWithSuperGroupAndCache {
    @Test
    public void testSuperTemplate() throws Exception {
        StringTemplate3StatementLocator locator = StringTemplate3StatementLocator.builder(Kombucha.class).withSuperGroup(SuperDrink.class).withErrorListener(StringTemplateGroup.DEFAULT_ERROR_LISTENER).allowImplicitTemplateGroup().treatLiteralsAsTemplates().shouldCache().build();
        TestingStatementContext ctx = new TestingStatementContext(new HashMap<String, Object>());
        String getIngredients = locator.locate("getIngredients", (StatementContext)ctx);
        Assert.assertEquals((Object)"select tea\n, mushroom\n, sugar from kombucha;", (Object)getIngredients);
        String awesomeness = locator.locate("awesomeness", (StatementContext)ctx);
        Assert.assertEquals((Object)"awesomeness;", (Object)awesomeness);
    }

    @Test
    public void testLocatorWithAttributes() throws Exception {
        StringTemplate3StatementLocator locator = StringTemplate3StatementLocator.builder(Kombucha.class).withSuperGroup(SuperDrink.class).withErrorListener(StringTemplateGroup.DEFAULT_ERROR_LISTENER).allowImplicitTemplateGroup().treatLiteralsAsTemplates().shouldCache().build();
        TestingStatementContext ctx = new TestingStatementContext(new HashMap<String, Object>());
        ctx.setAttribute("historyTableName", "superDrink");
        String getFromHistoryTableName = locator.locate("getFromHistoryTableName", (StatementContext)ctx);
        Assert.assertEquals((Object)"select tea\n, mushroom\n, sugar from superDrink;", (Object)getFromHistoryTableName);
        Assert.assertTrue((boolean)StringTemplate3StatementLocator.templateCached(Kombucha.class, SuperDrink.class));
        String getFromHistoryTableNameAgain = locator.locate("getFromHistoryTableName", (StatementContext)ctx);
        Assert.assertEquals((Object)"select tea\n, mushroom\n, sugar from superDrink;", (Object)getFromHistoryTableNameAgain);
    }
}

