/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.spring;

import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.spi.LoggingEvent;
import org.skife.jdbi.derby.DerbyHelper;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.spring.Callback;
import org.skife.jdbi.v2.spring.DBIUtil;
import org.skife.jdbi.v2.spring.ForceRollback;
import org.skife.jdbi.v2.spring.Service;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.IntegerMapper;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

public class TestDBIFactoryBean
extends AbstractDependencyInjectionSpringContextTests {
    protected Service service;
    protected DataSource derby;
    protected DerbyHelper derbyHelper;

    public void setService(Service service) {
        this.service = service;
    }

    public void setDerby(DataSource derby) {
        this.derby = derby;
    }

    public void setDerbyHelper(DerbyHelper derbyHelper) {
        this.derbyHelper = derbyHelper;
    }

    public void onSetUp() throws Exception {
        TestDBIFactoryBean.assertNotNull((Object)this.derbyHelper);
        this.derbyHelper.dropAndCreateSomething();
    }

    protected String[] getConfigLocations() {
        return new String[]{"org/skife/jdbi/v2/spring/test-context.xml"};
    }

    public void testServiceIsActuallySet() throws Exception {
        TestDBIFactoryBean.assertNotNull((Object)this.service);
    }

    public void testFailsViaException() throws Exception {
        try {
            this.service.inPropagationRequired(new Callback(){

                @Override
                public void call(IDBI dbi) {
                    Handle h = DBIUtil.getHandle((IDBI)dbi);
                    int count = h.insert("insert into something (id, name) values (7, 'ignored')", new Object[0]);
                    if (count == 1) {
                        throw new ForceRollback();
                    }
                    throw new RuntimeException("!ZABAK");
                }
            });
        }
        catch (ForceRollback e) {
            TestDBIFactoryBean.assertTrue((boolean)true);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            TestDBIFactoryBean.fail((String)"unexpected exception");
        }
        Handle h = DBI.open((DataSource)this.derby);
        int count = (Integer)h.createQuery("select count(*) from something").map((ResultSetMapper)new IntegerMapper()).first();
        TestDBIFactoryBean.assertEquals((int)0, (int)count);
        h.close();
    }

    public void testNested() throws Exception {
        try {
            this.service.inPropagationRequired(new Callback(){

                @Override
                public void call(IDBI outer) {
                    Handle h = DBIUtil.getHandle((IDBI)outer);
                    h.insert("insert into something (id, name) values (7, 'ignored')", new Object[0]);
                    try {
                        TestDBIFactoryBean.this.service.inNested(new Callback(){

                            @Override
                            public void call(IDBI inner) {
                                Handle h = DBIUtil.getHandle((IDBI)inner);
                                h.insert("insert into something (id, name) values (8, 'ignored again')", new Object[0]);
                                int count = (Integer)h.createQuery("select count(*) from something").map((ResultSetMapper)new IntegerMapper()).first();
                                TestCase.assertEquals((int)2, (int)count);
                                throw new ForceRollback();
                            }
                        });
                        TestCase.fail((String)"should have thrown an exception");
                    }
                    catch (ForceRollback e) {
                        TestCase.assertTrue((boolean)true);
                    }
                    int count = (Integer)h.createQuery("select count(*) from something").map((ResultSetMapper)new IntegerMapper()).first();
                    TestCase.assertEquals((int)1, (int)count);
                    throw new ForceRollback();
                }
            });
            TestDBIFactoryBean.fail((String)"should have thrown an exception");
        }
        catch (ForceRollback e) {
            TestDBIFactoryBean.assertTrue((boolean)true);
        }
        this.service.inPropagationRequired(new Callback(){

            @Override
            public void call(IDBI dbi) {
                Handle h = DBIUtil.getHandle((IDBI)dbi);
                int count = (Integer)h.createQuery("select count(*) from something").map((ResultSetMapper)new IntegerMapper()).first();
                TestCase.assertEquals((int)0, (int)count);
            }
        });
    }

    public void testRequiresNew() throws Exception {
        this.service.inPropagationRequired(new Callback(){

            @Override
            public void call(IDBI outer) {
                Handle h = DBIUtil.getHandle((IDBI)outer);
                h.insert("insert into something (id, name) values (7, 'ignored')", new Object[0]);
                try {
                    TestDBIFactoryBean.this.service.inRequiresNewReadUncommitted(new Callback(){

                        @Override
                        public void call(IDBI inner) {
                            Handle h = DBIUtil.getHandle((IDBI)inner);
                            int count = (Integer)h.createQuery("select count(*) from something").map((ResultSetMapper)new IntegerMapper()).first();
                            TestCase.assertEquals((int)1, (int)count);
                            h.insert("insert into something (id, name) values (8, 'ignored again')", new Object[0]);
                            throw new ForceRollback();
                        }
                    });
                }
                catch (ForceRollback e) {
                    TestCase.assertTrue((boolean)true);
                }
                int count = (Integer)h.createQuery("select count(*) from something").map((ResultSetMapper)new IntegerMapper()).first();
                TestCase.assertEquals((int)1, (int)count);
            }
        });
    }

    static {
        BasicConfigurator.configure((Appender)new AppenderSkeleton(){

            protected void append(LoggingEvent event) {
            }

            public boolean requiresLayout() {
                return false;
            }

            public void close() {
            }
        });
    }
}

