/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.docs;

import java.util.Arrays;
import java.util.UUID;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.TestContainerFactory;
import org.skife.jdbi.v2.logging.PrintStreamLog;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterContainerMapper;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.tweak.SQLLog;

public class TestPaging {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi.setSQLLog((SQLLog)new PrintStreamLog(System.out));
        this.handle = this.dbi.open();
        this.handle.execute("create table something( id integer primary key, name varchar(100) )", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.close();
    }

    @Test
    public void pagingExample() throws Exception {
        Sql sql = (Sql)this.handle.attach(Sql.class);
        int[] rs = sql.insert(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13), Arrays.asList("Ami", "Brian", "Cora", "David", "Eric", "Fernando", "Greta", "Holly", "Inigo", "Joy", "Keith", "Lisa", "Molly"));
        Assert.assertThat((Object)rs, (Matcher)CoreMatchers.equalTo((Object)new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
        ImmutableList<Something> page_one = sql.loadPage(-1, 5);
        Assert.assertThat(page_one, (Matcher)CoreMatchers.equalTo((Object)ImmutableList.of((Object)new Something(1, "Ami"), (Object)new Something(2, "Brian"), (Object)new Something(3, "Cora"), (Object)new Something(4, "David"), (Object)new Something(5, "Eric"))));
        ImmutableList<Something> page_two = sql.loadPage(((Something)page_one.get(page_one.size() - 1)).getId(), 5);
        Assert.assertThat(page_two, (Matcher)CoreMatchers.equalTo((Object)ImmutableList.of((Object)new Something(6, "Fernando"), (Object)new Something(7, "Greta"), (Object)new Something(8, "Holly"), (Object)new Something(9, "Inigo"), (Object)new Something(10, "Joy"))));
    }

    @RegisterContainerMapper(value={TestContainerFactory.ImmutableListContainerFactory.class})
    @RegisterMapper(value={SomethingMapper.class})
    public static interface Sql {
        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public int[] insert(@Bind(value="id") Iterable<Integer> var1, @Bind(value="name") Iterable<String> var2);

        @SqlQuery(value="select id, name from something where id > :end_of_last_page order by id limit :size")
        public ImmutableList<Something> loadPage(@Bind(value="end_of_last_page") int var1, @Bind(value="size") int var2);
    }
}

