/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.HandyMapThing;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder2;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.NoResultsException;
import org.skife.jdbi.v2.exceptions.StatementException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestQueries
extends DBITestCase {
    private BasicHandle h;

    @Override
    public void doSetUp() throws Exception {
        this.h = this.openHandle();
    }

    @Override
    public void doTearDown() throws Exception {
        if (this.h != null) {
            this.h.close();
        }
    }

    @Test
    public void testCreateQueryObject() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        List results = this.h.createQuery("select * from something order by id").list();
        Assert.assertEquals((long)2L, (long)results.size());
        Map first_row = (Map)results.get(0);
        Assert.assertEquals((Object)"eric", first_row.get("name"));
    }

    @Test
    public void testMappedQueryObject() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'brian')", new Object[0]);
        Query query = this.h.createQuery("select * from something order by id").map(Something.class);
        List r = query.list();
        Something eric = (Something)r.get(0);
        Assert.assertEquals((Object)"eric", (Object)eric.getName());
        Assert.assertEquals((long)1L, (long)eric.getId());
    }

    @Test
    public void testMappedQueryObjectWithNulls() throws Exception {
        this.h.insert("insert into something (id, name, integerValue) values (1, 'eric', null)", new Object[0]);
        Query query = this.h.createQuery("select * from something order by id").map(Something.class);
        List r = query.list();
        Something eric = (Something)r.get(0);
        Assert.assertEquals((Object)"eric", (Object)eric.getName());
        Assert.assertEquals((long)1L, (long)eric.getId());
        Assert.assertNull((Object)eric.getIntegerValue());
    }

    @Test
    public void testMappedQueryObjectWithNullForPrimitiveIntField() throws Exception {
        this.h.insert("insert into something (id, name, intValue) values (1, 'eric', null)", new Object[0]);
        Query query = this.h.createQuery("select * from something order by id").map(Something.class);
        List r = query.list();
        Something eric = (Something)r.get(0);
        Assert.assertEquals((Object)"eric", (Object)eric.getName());
        Assert.assertEquals((long)1L, (long)eric.getId());
        Assert.assertEquals((long)0L, (long)eric.getIntValue());
    }

    @Test
    public void testMapper() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'brian')", new Object[0]);
        Query query = this.h.createQuery("select name from something order by id").map((ResultSetMapper)new ResultSetMapper<String>(){

            public String map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                return r.getString(1);
            }
        });
        String name = (String)query.list().get(0);
        Assert.assertEquals((Object)"eric", (Object)name);
    }

    @Test
    public void testConvenienceMethod() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'brian')", new Object[0]);
        List r = this.h.select("select * from something order by id", new Object[0]);
        Assert.assertEquals((long)2L, (long)r.size());
        Assert.assertEquals((Object)"eric", ((Map)r.get(0)).get("name"));
    }

    @Test
    public void testConvenienceMethodWithParam() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'brian')", new Object[0]);
        List r = this.h.select("select * from something where id = ?", new Object[]{1});
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((Object)"eric", ((Map)r.get(0)).get("name"));
    }

    @Test
    public void testPositionalArgWithNamedParam() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'brian')", new Object[0]);
        List r = ((Query)this.h.createQuery("select * from something where name = :name").bind(0, "eric")).map(Something.class).list();
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((Object)"eric", (Object)((Something)r.get(0)).getName());
    }

    @Test
    public void testMixedSetting() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'brian')", new Object[0]);
        List r = ((Query)((Query)this.h.createQuery("select * from something where name = :name and id = :id").bind(0, "eric")).bind("id", 1)).map(Something.class).list();
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((Object)"eric", (Object)((Something)r.get(0)).getName());
    }

    @Test
    public void testHelpfulErrorOnNothingSet() throws Exception {
        try {
            this.h.createQuery("select * from something where name = :name").list();
            Assert.fail((String)"should have raised exception");
        }
        catch (UnableToExecuteStatementException e) {
            Assert.assertTrue((String)"execution goes through here", (boolean)true);
        }
        catch (Exception e) {
            Assert.fail((String)"Raised incorrect exception");
        }
    }

    @Test
    public void testFirstResult() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'brian')", new Object[0]);
        Something r = (Something)this.h.createQuery("select * from something order by id").map(Something.class).first();
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((Object)"eric", (Object)r.getName());
    }

    @Test
    public void testIteratedResult() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'brian')", new Object[0]);
        ResultIterator i = this.h.createQuery("select * from something order by id").map(Something.class).iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Something first = (Something)i.next();
        Assert.assertEquals((Object)"eric", (Object)first.getName());
        Assert.assertTrue((boolean)i.hasNext());
        Something second = (Something)i.next();
        Assert.assertEquals((long)2L, (long)second.getId());
        Assert.assertFalse((boolean)i.hasNext());
        i.close();
    }

    @Test
    public void testIteratorBehavior() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'brian')", new Object[0]);
        ResultIterator i = this.h.createQuery("select * from something order by id").map(Something.class).iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Assert.assertTrue((boolean)i.hasNext());
        Something first = (Something)i.next();
        Assert.assertEquals((Object)"eric", (Object)first.getName());
        Assert.assertTrue((boolean)i.hasNext());
        Something second = (Something)i.next();
        Assert.assertEquals((long)2L, (long)second.getId());
        Assert.assertFalse((boolean)i.hasNext());
        i.close();
    }

    @Test
    public void testIteratorBehavior2() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'brian')", new Object[0]);
        ResultIterator i = this.h.createQuery("select * from something order by id").map(Something.class).iterator();
        Something first = (Something)i.next();
        Assert.assertEquals((Object)"eric", (Object)first.getName());
        Something second = (Something)i.next();
        Assert.assertEquals((long)2L, (long)second.getId());
        Assert.assertFalse((boolean)i.hasNext());
        i.close();
    }

    @Test
    public void testIteratorBehavior3() throws Exception {
        this.h.insert("insert into something (id, name) values (1, 'eric')", new Object[0]);
        this.h.insert("insert into something (id, name) values (2, 'eric')", new Object[0]);
        int count = 0;
        for (Something s : this.h.createQuery("select * from something order by id").map(Something.class)) {
            ++count;
            Assert.assertEquals((Object)"eric", (Object)s.getName());
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testFetchSize() throws Exception {
        this.h.createScript("default-data").execute();
        Query q = this.h.createQuery("select id, name from something order by id").map(Something.class);
        q.setFetchSize(1);
        ResultIterator r = q.iterator();
        Assert.assertTrue((boolean)r.hasNext());
        r.next();
        Assert.assertTrue((boolean)r.hasNext());
        r.next();
        Assert.assertFalse((boolean)r.hasNext());
    }

    @Test
    public void testFirstWithNoResult() throws Exception {
        Something s = (Something)this.h.createQuery("select id, name from something").map(Something.class).first();
        Assert.assertNull((Object)s);
    }

    @Test
    public void testListWithMaxRows() throws Exception {
        this.h.prepareBatch("insert into something (id, name) values (:id, :name)").add(new Object[]{1, "Brian"}).add(new Object[]{2, "Keith"}).add(new Object[]{3, "Eric"}).execute();
        Assert.assertEquals((long)1L, (long)this.h.createQuery("select id, name from something").map(Something.class).list(1).size());
        Assert.assertEquals((long)2L, (long)this.h.createQuery("select id, name from something").map(Something.class).list(2).size());
    }

    @Test
    public void testFold() throws Exception {
        this.h.prepareBatch("insert into something (id, name) values (:id, :name)").add(new Object[]{1, "Brian"}).add(new Object[]{2, "Keith"}).execute();
        Map rs = (Map)this.h.createQuery("select id, name from something").fold(new HashMap(), (Folder2)new Folder2<Map<String, Integer>>(){

            public Map<String, Integer> fold(Map<String, Integer> a, ResultSet rs, StatementContext context) throws SQLException {
                a.put(rs.getString("name"), rs.getInt("id"));
                return a;
            }
        });
        Assert.assertEquals((long)2L, (long)rs.size());
        Assert.assertEquals((Object)1, rs.get("Brian"));
        Assert.assertEquals((Object)2, rs.get("Keith"));
    }

    @Test
    public void testFold3() throws Exception {
        this.h.prepareBatch("insert into something (id, name) values (:id, :name)").add(new Object[]{1, "Brian"}).add(new Object[]{2, "Keith"}).execute();
        List rs = (List)this.h.createQuery("select name from something order by id").map((ResultSetMapper)StringMapper.FIRST).fold(new ArrayList(), (Folder3)new Folder3<List<String>, String>(){

            public List<String> fold(List<String> a, String rs, FoldController ctl, StatementContext ctx) throws SQLException {
                a.add(rs);
                return a;
            }
        });
        Assert.assertEquals((long)2L, (long)rs.size());
        Assert.assertEquals(Arrays.asList("Brian", "Keith"), (Object)rs);
    }

    @Test
    public void testUsefulArgumentOutputForDebug() throws Exception {
        try {
            ((Update)((Update)((Update)((Update)this.h.createStatement("insert into something (id, name) values (:id, :name)").bind("name", "brian")).bind(7, 8)).bindFromMap(new HandyMapThing<String>().add("one", "two"))).bindFromProperties(new Object())).execute();
        }
        catch (StatementException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("arguments:{ positional:{7:8}, named:{name:'brian'}, finder:[{one=two},{lazy bean proprty arguments \"java.lang.Object"));
        }
    }

    @Test
    public void testStatementCustomizersPersistAfterMap() throws Exception {
        this.h.insert("insert into something (id, name) values (?, ?)", new Object[]{1, "hello"});
        this.h.insert("insert into something (id, name) values (?, ?)", new Object[]{2, "world"});
        List rs = this.h.createQuery("select id, name from something").setMaxRows(1).map(Something.class).list();
        Assert.assertEquals((long)1L, (long)rs.size());
    }

    @Test
    public void testQueriesWithNullResultSets() throws Exception {
        try {
            this.h.select("insert into something (id, name) values (?, ?)", new Object[]{1, "hello"});
        }
        catch (NoResultsException e) {
            return;
        }
        Assert.fail((String)"expected NoResultsException");
    }
}

