/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.math.BigDecimal;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BigDecimalArgument;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.MapArguments;
import org.skife.jdbi.v2.ObjectArgument;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

public class TestMapArguments {
    @Test
    public void testBind() throws Exception {
        HashMap<String, BigDecimal> args = new HashMap<String, BigDecimal>();
        args.put("foo", BigDecimal.ONE);
        Foreman foreman = new Foreman();
        ConcreteStatementContext ctx = new ConcreteStatementContext(new HashMap());
        MapArguments mapArguments = new MapArguments(foreman, (StatementContext)ctx, args);
        Argument argument = mapArguments.find("foo");
        Assert.assertThat((Object)argument, (Matcher)CoreMatchers.instanceOf(BigDecimalArgument.class));
    }

    @Test
    public void testNullBinding() throws Exception {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("foo", null);
        Foreman foreman = new Foreman();
        ConcreteStatementContext ctx = new ConcreteStatementContext(new HashMap());
        MapArguments mapArguments = new MapArguments(foreman, (StatementContext)ctx, args);
        Argument argument = mapArguments.find("foo");
        Assert.assertThat((Object)argument, (Matcher)CoreMatchers.instanceOf(ObjectArgument.class));
    }
}

