/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.webdav;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.servlets.WebdavServlet;
import org.apache.catalina.startup.Embedded;
import org.apache.coyote.http11.Http11NioProtocol;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.webdav.WebDavCompletionHandlerBase;
import org.asynchttpclient.webdav.WebDavResponse;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class WebDavBasicTest
extends AbstractBasicTest {
    protected Embedded embedded;

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.embedded = new Embedded();
        String path = new File(".").getAbsolutePath();
        this.embedded.setCatalinaHome(path);
        Engine engine = this.embedded.createEngine();
        engine.setDefaultHost("localhost");
        Host host = this.embedded.createHost("localhost", path);
        engine.addChild((Container)host);
        Context c = this.embedded.createContext("/", path);
        c.setReloadable(false);
        Wrapper w = c.createWrapper();
        w.addMapping("/*");
        w.setServletClass(WebdavServlet.class.getName());
        w.addInitParameter("readonly", "false");
        w.addInitParameter("listings", "true");
        w.setLoadOnStartup(0);
        c.addChild((Container)w);
        host.addChild((Container)c);
        Connector connector = this.embedded.createConnector("localhost", 0, Http11NioProtocol.class.getName());
        connector.setContainer((Container)host);
        this.embedded.addEngine(engine);
        this.embedded.addConnector(connector);
        this.embedded.start();
        this.port1 = connector.getLocalPort();
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws InterruptedException, Exception {
        this.embedded.stop();
    }

    @Override
    protected String getTargetUrl() {
        return String.format("http://localhost:%s/folder1", this.port1);
    }

    @AfterMethod(alwaysRun=true)
    public void clean() throws InterruptedException, Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            c.executeRequest(Dsl.delete((String)this.getTargetUrl())).get();
        }
    }

    @Test(groups={"standalone"})
    public void mkcolWebDavTest1() throws InterruptedException, IOException, ExecutionException {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            Request mkcolRequest = ((RequestBuilder)new RequestBuilder("MKCOL").setUrl(this.getTargetUrl())).build();
            Response response = (Response)c.executeRequest(mkcolRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)201);
        }
    }

    @Test(groups={"standalone"})
    public void mkcolWebDavTest2() throws InterruptedException, IOException, ExecutionException {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            Request mkcolRequest = ((RequestBuilder)new RequestBuilder("MKCOL").setUrl(this.getTargetUrl() + "/folder2")).build();
            Response response = (Response)c.executeRequest(mkcolRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)409);
        }
    }

    @Test(groups={"standalone"})
    public void basicPropFindWebDavTest() throws InterruptedException, IOException, ExecutionException {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            Request propFindRequest = ((RequestBuilder)new RequestBuilder("PROPFIND").setUrl(this.getTargetUrl())).build();
            Response response = (Response)c.executeRequest(propFindRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)404);
        }
    }

    @Test(groups={"standalone"})
    public void propFindWebDavTest() throws InterruptedException, IOException, ExecutionException {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            Request mkcolRequest = ((RequestBuilder)new RequestBuilder("MKCOL").setUrl(this.getTargetUrl())).build();
            Response response = (Response)c.executeRequest(mkcolRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)201);
            Request putRequest = ((RequestBuilder)Dsl.put((String)String.format("http://localhost:%s/folder1/Test.txt", this.port1)).setBody("this is a test")).build();
            response = (Response)c.executeRequest(putRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)201);
            Request propFindRequest = ((RequestBuilder)new RequestBuilder("PROPFIND").setUrl(String.format("http://localhost:%s/folder1/Test.txt", this.port1))).build();
            response = (Response)c.executeRequest(propFindRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)207);
            Assert.assertTrue((boolean)response.getResponseBody().contains("HTTP/1.1 200 OK"), (String)("Got " + response.getResponseBody()));
        }
    }

    @Test(groups={"standalone"})
    public void propFindCompletionHandlerWebDavTest() throws InterruptedException, IOException, ExecutionException {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            Request mkcolRequest = ((RequestBuilder)new RequestBuilder("MKCOL").setUrl(this.getTargetUrl())).build();
            Response response = (Response)c.executeRequest(mkcolRequest).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)201);
            Request propFindRequest = ((RequestBuilder)new RequestBuilder("PROPFIND").setUrl(this.getTargetUrl())).build();
            WebDavResponse webDavResponse = (WebDavResponse)c.executeRequest(propFindRequest, (AsyncHandler)new WebDavCompletionHandlerBase<WebDavResponse>(){

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                }

                public WebDavResponse onCompleted(WebDavResponse response) throws Exception {
                    return response;
                }
            }).get();
            Assert.assertEquals((int)webDavResponse.getStatusCode(), (int)207);
            Assert.assertTrue((boolean)webDavResponse.getResponseBody().contains("HTTP/1.1 200 OK"), (String)("Got " + response.getResponseBody()));
        }
    }
}

