/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.util;

import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Param;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.netty.util.ByteBufUtils;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.HttpUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HttpUtilsTest {
    @Test
    public void testGetAuthority() {
        Uri uri = Uri.create((String)"http://stackoverflow.com/questions/17814461/jacoco-maven-testng-0-test-coverage");
        String authority = HttpUtils.getAuthority((Uri)uri);
        Assert.assertEquals((String)authority, (String)"stackoverflow.com:80", (String)"Incorrect authority returned from getAuthority");
    }

    @Test
    public void testGetAuthorityWithPortInUrl() {
        Uri uri = Uri.create((String)"http://stackoverflow.com:8443/questions/17814461/jacoco-maven-testng-0-test-coverage");
        String authority = HttpUtils.getAuthority((Uri)uri);
        Assert.assertEquals((String)authority, (String)"stackoverflow.com:8443", (String)"Incorrect authority returned from getAuthority");
    }

    @Test
    public void testGetBaseUrl() {
        Uri uri = Uri.create((String)"http://stackoverflow.com:8443/questions/17814461/jacoco-maven-testng-0-test-coverage");
        String baseUrl = HttpUtils.getBaseUrl((Uri)uri);
        Assert.assertEquals((String)baseUrl, (String)"http://stackoverflow.com:8443", (String)"Incorrect base URL returned from getBaseURL");
    }

    @Test
    public void testIsSameBaseUrlReturnsFalseWhenPortDifferent() {
        Uri uri1 = Uri.create((String)"http://stackoverflow.com:8443/questions/17814461/jacoco-maven-testng-0-test-coverage");
        Uri uri2 = Uri.create((String)"http://stackoverflow.com:8442/questions/1057564/pretty-git-branch-graphs");
        Assert.assertFalse((boolean)HttpUtils.isSameBase((Uri)uri1, (Uri)uri2), (String)"Base URLs should be different, but true was returned from isSameBase");
    }

    @Test
    public void testIsSameBaseUrlReturnsFalseWhenSchemeDifferent() {
        Uri uri1 = Uri.create((String)"http://stackoverflow.com:8443/questions/17814461/jacoco-maven-testng-0-test-coverage");
        Uri uri2 = Uri.create((String)"ws://stackoverflow.com:8443/questions/1057564/pretty-git-branch-graphs");
        Assert.assertFalse((boolean)HttpUtils.isSameBase((Uri)uri1, (Uri)uri2), (String)"Base URLs should be different, but true was returned from isSameBase");
    }

    @Test
    public void testIsSameBaseUrlReturnsFalseWhenHostDifferent() {
        Uri uri1 = Uri.create((String)"http://stackoverflow.com:8443/questions/17814461/jacoco-maven-testng-0-test-coverage");
        Uri uri2 = Uri.create((String)"http://example.com:8443/questions/1057564/pretty-git-branch-graphs");
        Assert.assertFalse((boolean)HttpUtils.isSameBase((Uri)uri1, (Uri)uri2), (String)"Base URLs should be different, but true was returned from isSameBase");
    }

    @Test
    public void testGetPathWhenPathIsNonEmpty() {
        Uri uri = Uri.create((String)"http://stackoverflow.com:8443/questions/17814461/jacoco-maven-testng-0-test-coverage");
        String path = HttpUtils.getNonEmptyPath((Uri)uri);
        Assert.assertEquals((String)path, (String)"/questions/17814461/jacoco-maven-testng-0-test-coverage", (String)"Incorrect path returned from getNonEmptyPath");
    }

    @Test
    public void testGetPathWhenPathIsEmpty() {
        Uri uri = Uri.create((String)"http://stackoverflow.com");
        String path = HttpUtils.getNonEmptyPath((Uri)uri);
        Assert.assertEquals((String)path, (String)"/", (String)"Incorrect path returned from getNonEmptyPath");
    }

    @Test
    public void testIsSameBaseUrlReturnsTrueWhenOneUriHasDefaultPort() {
        Uri uri1 = Uri.create((String)"http://stackoverflow.com:80/questions/17814461/jacoco-maven-testng-0-test-coverage");
        Uri uri2 = Uri.create((String)"http://stackoverflow.com/questions/1057564/pretty-git-branch-graphs");
        Assert.assertTrue((boolean)HttpUtils.isSameBase((Uri)uri1, (Uri)uri2), (String)"Base URLs should be same, but false was returned from isSameBase");
    }

    @Test
    public void testParseCharsetWithoutQuotes() {
        Charset charset = HttpUtils.parseCharset((String)"Content-type: application/json; charset=utf-8");
        Assert.assertEquals((Object)charset, (Object)StandardCharsets.UTF_8, (String)"parseCharset returned wrong Charset");
    }

    @Test
    public void testParseCharsetWithSingleQuotes() {
        Charset charset = HttpUtils.parseCharset((String)"Content-type: application/json; charset='utf-8'");
        Assert.assertEquals((Object)charset, (Object)StandardCharsets.UTF_8, (String)"parseCharset returned wrong Charset");
    }

    @Test
    public void testParseCharsetWithDoubleQuotes() {
        Charset charset = HttpUtils.parseCharset((String)"Content-type: application/json; charset=\"utf-8\"");
        Assert.assertEquals((Object)charset, (Object)StandardCharsets.UTF_8, (String)"parseCharset returned wrong Charset");
    }

    @Test
    public void testParseCharsetReturnsNullWhenNoCharset() {
        Charset charset = HttpUtils.parseCharset((String)"Content-type: application/json");
        Assert.assertNull((Object)charset, (String)"parseCharset should return null when charset is not specified in header value");
    }

    @Test
    public void testGetHostHeaderNoVirtualHost() {
        Request request = Dsl.get((String)"http://stackoverflow.com/questions/1057564/pretty-git-branch-graphs").build();
        Uri uri = Uri.create((String)"http://stackoverflow.com/questions/1057564/pretty-git-branch-graphs");
        String hostHeader = HttpUtils.hostHeader((Request)request, (Uri)uri);
        Assert.assertEquals((String)hostHeader, (String)"stackoverflow.com", (String)"Incorrect hostHeader returned");
    }

    @Test
    public void testGetHostHeaderHasVirtualHost() {
        Request request = ((RequestBuilder)Dsl.get((String)"http://stackoverflow.com/questions/1057564").setVirtualHost("example.com")).build();
        Uri uri = Uri.create((String)"http://stackoverflow.com/questions/1057564/pretty-git-branch-graphs");
        String hostHeader = HttpUtils.hostHeader((Request)request, (Uri)uri);
        Assert.assertEquals((String)hostHeader, (String)"example.com", (String)"Incorrect hostHeader returned");
    }

    @Test
    public void testDefaultFollowRedirect() {
        Request request = ((RequestBuilder)Dsl.get((String)"http://stackoverflow.com/questions/1057564").setVirtualHost("example.com")).build();
        DefaultAsyncHttpClientConfig config = new DefaultAsyncHttpClientConfig.Builder().build();
        boolean followRedirect = HttpUtils.followRedirect((AsyncHttpClientConfig)config, (Request)request);
        Assert.assertFalse((boolean)followRedirect, (String)"Default value of redirect should be false");
    }

    @Test
    public void testGetFollowRedirectInRequest() {
        Request request = ((RequestBuilder)Dsl.get((String)"http://stackoverflow.com/questions/1057564").setFollowRedirect(true)).build();
        DefaultAsyncHttpClientConfig config = new DefaultAsyncHttpClientConfig.Builder().build();
        boolean followRedirect = HttpUtils.followRedirect((AsyncHttpClientConfig)config, (Request)request);
        Assert.assertTrue((boolean)followRedirect, (String)"Follow redirect must be true as set in the request");
    }

    @Test
    public void testGetFollowRedirectInConfig() {
        Request request = Dsl.get((String)"http://stackoverflow.com/questions/1057564").build();
        DefaultAsyncHttpClientConfig config = new DefaultAsyncHttpClientConfig.Builder().setFollowRedirect(true).build();
        boolean followRedirect = HttpUtils.followRedirect((AsyncHttpClientConfig)config, (Request)request);
        Assert.assertTrue((boolean)followRedirect, (String)"Follow redirect should be equal to value specified in config when not specified in request");
    }

    @Test
    public void testGetFollowRedirectPriorityGivenToRequest() {
        Request request = ((RequestBuilder)Dsl.get((String)"http://stackoverflow.com/questions/1057564").setFollowRedirect(false)).build();
        DefaultAsyncHttpClientConfig config = new DefaultAsyncHttpClientConfig.Builder().setFollowRedirect(true).build();
        boolean followRedirect = HttpUtils.followRedirect((AsyncHttpClientConfig)config, (Request)request);
        Assert.assertFalse((boolean)followRedirect, (String)"Follow redirect value set in request should be given priority");
    }

    private void formUrlEncoding(Charset charset) throws Exception {
        String key = "key";
        String value = "\u4e2d\u6587";
        ArrayList<Param> params = new ArrayList<Param>();
        params.add(new Param(key, value));
        ByteBuffer ahcBytes = HttpUtils.urlEncodeFormParams(params, (Charset)charset);
        String ahcString = HttpUtilsTest.toUsAsciiString(ahcBytes);
        String jdkString = key + "=" + URLEncoder.encode(value, charset.name());
        Assert.assertEquals((String)ahcString, (String)jdkString);
    }

    @Test
    public void formUrlEncodingShouldSupportUtf8Charset() throws Exception {
        this.formUrlEncoding(StandardCharsets.UTF_8);
    }

    @Test
    public void formUrlEncodingShouldSupportNonUtf8Charset() throws Exception {
        this.formUrlEncoding(Charset.forName("GBK"));
    }

    private static String toUsAsciiString(ByteBuffer buf) throws CharacterCodingException {
        ByteBuf bb = Unpooled.wrappedBuffer((ByteBuffer)buf);
        try {
            String string = ByteBufUtils.byteBuf2String((Charset)StandardCharsets.US_ASCII, (ByteBuf)bb);
            return string;
        }
        finally {
            bb.release();
        }
    }

    @Test
    public void computeOriginForPlainUriWithImplicitPort() {
        Assert.assertEquals((String)HttpUtils.computeOriginHeader((Uri)Uri.create((String)"ws://foo.com/bar")), (String)"http://foo.com");
    }

    @Test
    public void computeOriginForPlainUriWithDefaultPort() {
        Assert.assertEquals((String)HttpUtils.computeOriginHeader((Uri)Uri.create((String)"ws://foo.com:80/bar")), (String)"http://foo.com");
    }

    @Test
    public void computeOriginForPlainUriWithNonDefaultPort() {
        Assert.assertEquals((String)HttpUtils.computeOriginHeader((Uri)Uri.create((String)"ws://foo.com:81/bar")), (String)"http://foo.com:81");
    }

    @Test
    public void computeOriginForSecuredUriWithImplicitPort() {
        Assert.assertEquals((String)HttpUtils.computeOriginHeader((Uri)Uri.create((String)"wss://foo.com/bar")), (String)"https://foo.com");
    }

    @Test
    public void computeOriginForSecuredUriWithDefaultPort() {
        Assert.assertEquals((String)HttpUtils.computeOriginHeader((Uri)Uri.create((String)"wss://foo.com:443/bar")), (String)"https://foo.com");
    }

    @Test
    public void computeOriginForSecuredUriWithNonDefaultPort() {
        Assert.assertEquals((String)HttpUtils.computeOriginHeader((Uri)Uri.create((String)"wss://foo.com:444/bar")), (String)"https://foo.com:444");
    }
}

