/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.test;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Response;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.netty.request.NettyRequest;
import org.testng.Assert;

public class EventCollectingHandler
extends AsyncCompletionHandlerBase
implements AsyncHandlerExtensions {
    public static final String COMPLETED_EVENT = "Completed";
    public static final String STATUS_RECEIVED_EVENT = "StatusReceived";
    public static final String HEADERS_RECEIVED_EVENT = "HeadersReceived";
    public static final String HEADERS_WRITTEN_EVENT = "HeadersWritten";
    public static final String CONTENT_WRITTEN_EVENT = "ContentWritten";
    public static final String CONNECTION_OPEN_EVENT = "ConnectionOpen";
    public static final String HOSTNAME_RESOLUTION_EVENT = "HostnameResolution";
    public static final String HOSTNAME_RESOLUTION_SUCCESS_EVENT = "HostnameResolutionSuccess";
    public static final String HOSTNAME_RESOLUTION_FAILURE_EVENT = "HostnameResolutionFailure";
    public static final String CONNECTION_SUCCESS_EVENT = "ConnectionSuccess";
    public static final String CONNECTION_FAILURE_EVENT = "ConnectionFailure";
    public static final String TLS_HANDSHAKE_EVENT = "TlsHandshake";
    public static final String TLS_HANDSHAKE_SUCCESS_EVENT = "TlsHandshakeSuccess";
    public static final String TLS_HANDSHAKE_FAILURE_EVENT = "TlsHandshakeFailure";
    public static final String CONNECTION_POOL_EVENT = "ConnectionPool";
    public static final String CONNECTION_POOLED_EVENT = "ConnectionPooled";
    public static final String CONNECTION_OFFER_EVENT = "ConnectionOffer";
    public static final String REQUEST_SEND_EVENT = "RequestSend";
    public static final String RETRY_EVENT = "Retry";
    public Queue<String> firedEvents = new ConcurrentLinkedQueue<String>();
    private CountDownLatch completionLatch = new CountDownLatch(1);

    public void waitForCompletion(int timeout, TimeUnit unit) throws InterruptedException {
        if (!this.completionLatch.await(timeout, unit)) {
            Assert.fail((String)"Timeout out");
        }
    }

    public Response onCompleted(Response response) throws Exception {
        this.firedEvents.add(COMPLETED_EVENT);
        try {
            Response response2 = super.onCompleted(response);
            return response2;
        }
        finally {
            this.completionLatch.countDown();
        }
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        this.firedEvents.add(STATUS_RECEIVED_EVENT);
        return super.onStatusReceived(status);
    }

    public AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.firedEvents.add(HEADERS_RECEIVED_EVENT);
        return super.onHeadersReceived(headers);
    }

    public AsyncHandler.State onHeadersWritten() {
        this.firedEvents.add(HEADERS_WRITTEN_EVENT);
        return super.onHeadersWritten();
    }

    public AsyncHandler.State onContentWritten() {
        this.firedEvents.add(CONTENT_WRITTEN_EVENT);
        return super.onContentWritten();
    }

    public void onTcpConnectAttempt(InetSocketAddress address) {
        this.firedEvents.add(CONNECTION_OPEN_EVENT);
    }

    public void onTcpConnectSuccess(InetSocketAddress address, Channel connection) {
        this.firedEvents.add(CONNECTION_SUCCESS_EVENT);
    }

    public void onTcpConnectFailure(InetSocketAddress address, Throwable t) {
        this.firedEvents.add(CONNECTION_FAILURE_EVENT);
    }

    public void onHostnameResolutionAttempt(String name) {
        this.firedEvents.add(HOSTNAME_RESOLUTION_EVENT);
    }

    public void onHostnameResolutionSuccess(String name, List<InetSocketAddress> addresses) {
        this.firedEvents.add(HOSTNAME_RESOLUTION_SUCCESS_EVENT);
    }

    public void onHostnameResolutionFailure(String name, Throwable cause) {
        this.firedEvents.add(HOSTNAME_RESOLUTION_FAILURE_EVENT);
    }

    public void onTlsHandshakeAttempt() {
        this.firedEvents.add(TLS_HANDSHAKE_EVENT);
    }

    public void onTlsHandshakeSuccess() {
        this.firedEvents.add(TLS_HANDSHAKE_SUCCESS_EVENT);
    }

    public void onTlsHandshakeFailure(Throwable cause) {
        this.firedEvents.add(TLS_HANDSHAKE_FAILURE_EVENT);
    }

    public void onConnectionPoolAttempt() {
        this.firedEvents.add(CONNECTION_POOL_EVENT);
    }

    public void onConnectionPooled(Channel connection) {
        this.firedEvents.add(CONNECTION_POOLED_EVENT);
    }

    public void onConnectionOffer(Channel connection) {
        this.firedEvents.add(CONNECTION_OFFER_EVENT);
    }

    public void onRequestSend(NettyRequest request) {
        this.firedEvents.add(REQUEST_SEND_EVENT);
    }

    public void onRetry() {
        this.firedEvents.add(RETRY_EVENT);
    }
}

