/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.test;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoHandler
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(EchoHandler.class);

    public void handle(String pathInContext, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        byte[] bytes;
        String queryString;
        String param;
        LOGGER.debug("Echo received request {} on path {}", (Object)request, (Object)pathInContext);
        if (httpRequest.getHeader("X-HEAD") != null) {
            httpResponse.setContentLength(1);
        }
        if (httpRequest.getHeader("X-ISO") != null) {
            httpResponse.setContentType("text/html;charset=ISO-8859-1");
        } else {
            httpResponse.setContentType("text/html;charset=UTF-8");
        }
        if (request.getMethod().equalsIgnoreCase("OPTIONS")) {
            httpResponse.addHeader("Allow", "GET,HEAD,POST,OPTIONS,TRACE");
        }
        Enumeration e = httpRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            param = e.nextElement().toString();
            if (param.startsWith("LockThread")) {
                try {
                    Thread.sleep(40000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (param.startsWith("X-redirect")) {
                httpResponse.sendRedirect(httpRequest.getHeader("X-redirect"));
                return;
            }
            httpResponse.addHeader("X-" + param, httpRequest.getHeader(param));
        }
        Enumeration i = httpRequest.getParameterNames();
        StringBuilder requestBody = new StringBuilder();
        while (i.hasMoreElements()) {
            param = i.nextElement().toString();
            httpResponse.addHeader("X-" + param, httpRequest.getParameter(param));
            requestBody.append(param);
            requestBody.append("_");
        }
        String pathInfo = httpRequest.getPathInfo();
        if (pathInfo != null) {
            httpResponse.addHeader("X-pathInfo", pathInfo);
        }
        if ((queryString = httpRequest.getQueryString()) != null) {
            httpResponse.addHeader("X-queryString", queryString);
        }
        httpResponse.addHeader("X-KEEP-ALIVE", httpRequest.getRemoteAddr() + ":" + httpRequest.getRemotePort());
        Cookie[] cs = httpRequest.getCookies();
        if (cs != null) {
            for (Cookie c : cs) {
                httpResponse.addCookie(c);
            }
        }
        if (requestBody.length() > 0) {
            httpResponse.getOutputStream().write(requestBody.toString().getBytes());
        }
        int size = 16384;
        if (httpRequest.getContentLength() > 0) {
            size = httpRequest.getContentLength();
        }
        if ((bytes = new byte[size]).length > 0) {
            int read = 0;
            while (read > -1) {
                read = httpRequest.getInputStream().read(bytes);
                if (read <= 0) continue;
                httpResponse.getOutputStream().write(bytes, 0, read);
            }
        }
        request.setHandled(true);
        httpResponse.getOutputStream().flush();
        httpResponse.getOutputStream().close();
    }
}

