/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ThreadNameTest
extends AbstractBasicTest {
    private static Thread[] getThreads() {
        int count = Thread.activeCount() + 1;
        Thread[] threads;
        int filled;
        while ((filled = Thread.enumerate(threads = new Thread[count])) >= threads.length) {
            count *= 2;
        }
        return Arrays.copyOf(threads, filled);
    }

    @Test(groups={"standalone"})
    public void testThreadName() throws Exception {
        String threadPoolName = "ahc-" + (new Random().nextLong() & Long.MAX_VALUE);
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setThreadPoolName(threadPoolName));){
            ListenableFuture f = client.prepareGet("http://localhost:" + this.port1 + "/").execute();
            f.get(3L, TimeUnit.SECONDS);
            boolean found = false;
            for (Thread thread : ThreadNameTest.getThreads()) {
                if (!thread.getName().startsWith(threadPoolName)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found, (String)("must found threads starting with random string " + threadPoolName));
        }
    }
}

