/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NoNullResponseTest
extends AbstractBasicTest {
    private static final String GOOGLE_HTTPS_URL = "https://www.google.com";

    @Test(groups={"online"}, invocationCount=4)
    public void multipleSslRequestsWithDelayAndKeepAlive() throws Exception {
        DefaultAsyncHttpClientConfig config = Dsl.config().setFollowRedirect(true).setKeepAlive(true).setConnectTimeout(10000).setPooledConnectionIdleTimeout(60000).setRequestTimeout(10000).setMaxConnectionsPerHost(-1).setMaxConnections(-1).build();
        try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)config);){
            BoundRequestBuilder builder = client.prepareGet(GOOGLE_HTTPS_URL);
            Response response1 = (Response)builder.execute().get();
            Thread.sleep(4000L);
            Response response2 = (Response)builder.execute().get();
            Assert.assertNotNull((Object)response1);
            Assert.assertNotNull((Object)response2);
        }
    }
}

