/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.tools;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableProject;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.hive.druid.org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.hive.druid.org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.hive.druid.org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.hive.druid.org.apache.calcite.adapter.jdbc.JdbcRel;
import org.apache.hive.druid.org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.hive.druid.org.apache.calcite.config.Lex;
import org.apache.hive.druid.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.plan.RelTrait;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitDef;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.RelRoot;
import org.apache.hive.druid.org.apache.calcite.rel.convert.ConverterRule;
import org.apache.hive.druid.org.apache.calcite.rel.core.RelFactories;
import org.apache.hive.druid.org.apache.calcite.rel.core.TableScan;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.hive.druid.org.apache.calcite.rel.rules.FilterMergeRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ProjectToWindowRule;
import org.apache.hive.druid.org.apache.calcite.rel.rules.SortRemoveRule;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.schema.Schema;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAggFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlDialect;
import org.apache.hive.druid.org.apache.calcite.sql.SqlExplainFormat;
import org.apache.hive.druid.org.apache.calcite.sql.SqlExplainLevel;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParseException;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParser;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.util.ListSqlOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.hive.druid.org.apache.calcite.test.CalciteAssert;
import org.apache.hive.druid.org.apache.calcite.tools.FrameworkConfig;
import org.apache.hive.druid.org.apache.calcite.tools.Frameworks;
import org.apache.hive.druid.org.apache.calcite.tools.Planner;
import org.apache.hive.druid.org.apache.calcite.tools.Program;
import org.apache.hive.druid.org.apache.calcite.tools.Programs;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RuleSet;
import org.apache.hive.druid.org.apache.calcite.tools.RuleSets;
import org.apache.hive.druid.org.apache.calcite.tools.TpchSchema;
import org.apache.hive.druid.org.apache.calcite.tools.ValidationException;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PlannerTest {
    private void checkParseAndConvert(String query, String queryFromParseTree, String expectedRelExpr) throws Exception {
        Planner planner = this.getPlanner(null, new Program[0]);
        SqlNode parse = planner.parse(query);
        Assert.assertThat((Object)Util.toLinux((String)parse.toString()), (Matcher)CoreMatchers.equalTo((Object)queryFromParseTree));
        SqlNode validate = planner.validate(parse);
        RelNode rel = planner.rel(validate).project();
        Assert.assertThat((Object)this.toString(rel), (Matcher)CoreMatchers.equalTo((Object)expectedRelExpr));
    }

    @Test
    public void testParseAndConvert() throws Exception {
        this.checkParseAndConvert("select * from \"emps\" where \"name\" like '%e%'", "SELECT *\nFROM `emps`\nWHERE `name` LIKE '%e%'", "LogicalProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  LogicalFilter(condition=[LIKE($2, '%e%')])\n    EnumerableTableScan(table=[[hr, emps]])\n");
    }

    @Test(expected=SqlParseException.class)
    public void testParseIdentiferMaxLengthWithDefault() throws Exception {
        Planner planner = this.getPlanner(null, SqlParser.configBuilder().build(), new Program[0]);
        planner.parse("select name as aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa from \"emps\"");
    }

    @Test
    public void testParseIdentiferMaxLengthWithIncreased() throws Exception {
        Planner planner = this.getPlanner(null, SqlParser.configBuilder().setIdentifierMaxLength(512).build(), new Program[0]);
        planner.parse("select name as aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa from \"emps\"");
    }

    @Test
    public void testParseAndConvertWithOrderByAndOffset() throws Exception {
        this.checkParseAndConvert("select * from \"emps\" order by \"emps\".\"deptno\" offset 10", "SELECT *\nFROM `emps`\nORDER BY `emps`.`deptno`\nOFFSET 10 ROWS", "LogicalSort(sort0=[$1], dir0=[ASC], offset=[10])\n  LogicalProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n    EnumerableTableScan(table=[[hr, emps]])\n");
    }

    private String toString(RelNode rel) {
        return Util.toLinux((String)RelOptUtil.dumpPlan((String)"", (RelNode)rel, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES));
    }

    @Test
    public void testParseFails() throws SqlParseException {
        Planner planner = this.getPlanner(null, new Program[0]);
        try {
            SqlNode parse = planner.parse("select * * from \"emps\"");
            Assert.fail((String)("expected error, got " + parse));
        }
        catch (SqlParseException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Encountered \"*\" at line 1, column 10."));
        }
    }

    @Test
    public void testValidateFails() throws SqlParseException {
        Planner planner = this.getPlanner(null, new Program[0]);
        SqlNode parse = planner.parse("select * from \"emps\" where \"Xname\" like '%e%'");
        Assert.assertThat((Object)Util.toLinux((String)parse.toString()), (Matcher)CoreMatchers.equalTo((Object)"SELECT *\nFROM `emps`\nWHERE `Xname` LIKE '%e%'"));
        try {
            SqlNode validate = planner.validate(parse);
            Assert.fail((String)("expected error, got " + validate));
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)Throwables.getStackTraceAsString((Throwable)e), (Matcher)CoreMatchers.containsString((String)"Column 'Xname' not found in any table"));
        }
    }

    @Test
    public void testValidateUserDefinedAggregate() throws Exception {
        SqlStdOperatorTable stdOpTab = SqlStdOperatorTable.instance();
        SqlOperatorTable opTab = ChainedSqlOperatorTable.of((SqlOperatorTable[])new SqlOperatorTable[]{stdOpTab, new ListSqlOperatorTable((List)ImmutableList.of((Object)((Object)new MyCountAggFunction())))});
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.HR)).operatorTable(opTab).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        SqlNode parse = planner.parse("select \"deptno\", my_count(\"empid\") from \"emps\"\ngroup by \"deptno\"");
        Assert.assertThat((Object)Util.toLinux((String)parse.toString()), (Matcher)CoreMatchers.equalTo((Object)"SELECT `deptno`, `MY_COUNT`(`empid`)\nFROM `emps`\nGROUP BY `deptno`"));
        SqlNode validate = planner.validate(parse);
        Assert.assertThat((Object)validate, (Matcher)CoreMatchers.notNullValue());
        planner.close();
        planner.reset();
        parse = planner.parse("select \"deptno\", count(1) from \"emps\"");
        try {
            validate = planner.validate(parse);
            Assert.fail((String)("expected exception, got " + validate));
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)e.getCause().getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"Expression 'deptno' is not being grouped"));
        }
    }

    private Planner getPlanner(List<RelTraitDef> traitDefs, Program ... programs) {
        return this.getPlanner(traitDefs, SqlParser.Config.DEFAULT, programs);
    }

    private Planner getPlanner(List<RelTraitDef> traitDefs, SqlParser.Config parserConfig, Program ... programs) {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(parserConfig).defaultSchema(CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.HR)).traitDefs(traitDefs).programs(programs).build();
        return Frameworks.getPlanner((FrameworkConfig)config);
    }

    @Test
    public void testConvertWithoutValidateFails() throws Exception {
        Planner planner = this.getPlanner(null, new Program[0]);
        SqlNode parse = planner.parse("select * from \"emps\"");
        try {
            RelRoot rel = planner.rel(parse);
            Assert.fail((String)("expected error, got " + rel));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"cannot move from STATE_3_PARSED to STATE_4_VALIDATED"));
        }
    }

    private void checkMetadataPredicates(String sql, String expectedPredicates) throws Exception {
        Planner planner = this.getPlanner(null, new Program[0]);
        SqlNode parse = planner.parse(sql);
        SqlNode validate = planner.validate(parse);
        RelNode rel = planner.rel(validate).project();
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPredicateList predicates = mq.getPulledUpPredicates(rel);
        String buf = predicates.pulledUpPredicates.toString();
        Assert.assertThat((Object)buf, (Matcher)CoreMatchers.equalTo((Object)expectedPredicates));
    }

    @Test
    public void testMetadataUnionPredicates() throws Exception {
        this.checkMetadataPredicates("select * from \"emps\" where \"deptno\" < 10\nunion all\nselect * from \"emps\" where \"empid\" > 2", "[OR(<($1, 10), >($0, 2))]");
    }

    @Test
    public void testMetadataUnionPredicates2() throws Exception {
        this.checkMetadataPredicates("select * from \"emps\" where \"deptno\" < 10\nunion all\nselect * from \"emps\"", "[]");
    }

    @Test
    public void testMetadataUnionPredicates3() throws Exception {
        this.checkMetadataPredicates("select * from \"emps\" where \"deptno\" < 10\nunion all\nselect * from \"emps\" where \"deptno\" < 10 and \"empid\" > 1", "[<($1, 10)]");
    }

    @Test
    public void testMetadataUnionPredicates4() throws Exception {
        this.checkMetadataPredicates("select * from \"emps\" where \"deptno\" < 10\nunion all\nselect * from \"emps\" where \"deptno\" < 10 or \"empid\" > 1", "[OR(<($1, 10), >($0, 1))]");
    }

    @Test
    public void testMetadataUnionPredicates5() throws Exception {
        String sql = "select * from \"emps\" where \"deptno\" < 10\nunion all\nselect * from \"emps\" where \"deptno\" < 10 and false";
        this.checkMetadataPredicates("select * from \"emps\" where \"deptno\" < 10\nunion all\nselect * from \"emps\" where \"deptno\" < 10 and false", "[<($1, 10)]");
    }

    @Test
    public void testMetadataAggregatePredicates() throws Exception {
        this.checkMetadataPredicates("select count(*) from \"emps\" where false", "[]");
    }

    @Test
    public void testMetadataAggregatePredicates2() throws Exception {
        String sql = "select \"deptno\", count(\"deptno\")\nfrom \"emps\" where false\ngroup by \"deptno\"";
        this.checkMetadataPredicates("select \"deptno\", count(\"deptno\")\nfrom \"emps\" where false\ngroup by \"deptno\"", "[false]");
    }

    @Test
    public void testMetadataAggregatePredicates3() throws Exception {
        String sql = "select \"deptno\", count(\"deptno\")\nfrom \"emps\" where \"deptno\" > 10\ngroup by \"deptno\"";
        this.checkMetadataPredicates("select \"deptno\", count(\"deptno\")\nfrom \"emps\" where \"deptno\" > 10\ngroup by \"deptno\"", "[>($0, 10)]");
    }

    @Test
    public void testPlan() throws Exception {
        Program program = Programs.ofRules((RelOptRule[])new RelOptRule[]{FilterMergeRule.INSTANCE, EnumerableRules.ENUMERABLE_FILTER_RULE, EnumerableRules.ENUMERABLE_PROJECT_RULE});
        Planner planner = this.getPlanner(null, program);
        SqlNode parse = planner.parse("select * from \"emps\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel(validate).project();
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.equalTo((Object)"EnumerableProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  EnumerableTableScan(table=[[hr, emps]])\n"));
    }

    @Test
    public void testSortPlan() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{SortRemoveRule.INSTANCE, EnumerableRules.ENUMERABLE_PROJECT_RULE, EnumerableRules.ENUMERABLE_SORT_RULE});
        Planner planner = this.getPlanner(null, Programs.of((RuleSet)ruleSet));
        SqlNode parse = planner.parse("select * from \"emps\" order by \"emps\".\"deptno\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel(validate).project();
        RelTraitSet traitSet = convert.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.equalTo((Object)"EnumerableSort(sort0=[$1], dir0=[ASC])\n  EnumerableProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n    EnumerableTableScan(table=[[hr, emps]])\n"));
    }

    @Test
    public void testDuplicateSortPlan() throws Exception {
        this.runDuplicateSortCheck("select empid from ( select * from emps order by emps.deptno) order by deptno", "EnumerableProject(empid=[$0], deptno=[$1])\n  EnumerableSort(sort0=[$1], dir0=[ASC])\n    EnumerableProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n      EnumerableTableScan(table=[[hr, emps]])\n");
    }

    @Test
    public void testDuplicateSortPlanWithExpr() throws Exception {
        this.runDuplicateSortCheck("select empid+deptno from ( select empid, deptno from emps order by emps.deptno) order by deptno", "EnumerableProject(EXPR$0=[+($0, $1)], deptno=[$1])\n  EnumerableSort(sort0=[$1], dir0=[ASC])\n    EnumerableProject(empid=[$0], deptno=[$1])\n      EnumerableTableScan(table=[[hr, emps]])\n");
    }

    @Ignore(value="RelOptPlanner$CannotPlanException: Node [rel#27:Subset#6.ENUMERABLE.[]] could not be implemented; planner state:\n\nRoot: rel#27:Subset#6.ENUMERABLE.[]")
    @Test
    public void testDuplicateSortPlanWithOver() throws Exception {
        this.runDuplicateSortCheck("select empid+deptno from ( select empid, deptno, count(*) over (partition by deptno) emp_cnt from (   select empid, deptno     from emps    order by emps.deptno) )order by deptno", "EnumerableProject(EXPR$0=[$0])\n  EnumerableSort(sort0=[$1], dir0=[ASC])\n    EnumerableProject(EXPR$0=[+($0, $1)], deptno=[$1])\n      EnumerableProject(empid=[$0], deptno=[$1], $2=[$2])\n        EnumerableWindow(window#0=[window(partition {1} order by [] range between UNBOUNDED PRECEDING and UNBOUNDED FOLLOWING aggs [COUNT()])])\n          EnumerableSort(sort0=[$1], dir0=[ASC])\n            EnumerableProject(empid=[$0], deptno=[$1])\n              EnumerableTableScan(table=[[hr, emps]])\n");
    }

    private void runDuplicateSortCheck(String sql, String plan) throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{SortRemoveRule.INSTANCE, EnumerableRules.ENUMERABLE_PROJECT_RULE, EnumerableRules.ENUMERABLE_WINDOW_RULE, EnumerableRules.ENUMERABLE_SORT_RULE, ProjectToWindowRule.PROJECT});
        Planner planner = this.getPlanner(null, SqlParser.configBuilder().setLex(Lex.JAVA).build(), Programs.of((RuleSet)ruleSet));
        SqlNode parse = planner.parse(sql);
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel((SqlNode)validate).rel;
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        if (traitSet.getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE) == null) {
            return;
        }
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.equalTo((Object)plan));
    }

    @Test
    public void testDuplicateSortPlanWORemoveSortRule() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{EnumerableRules.ENUMERABLE_PROJECT_RULE, EnumerableRules.ENUMERABLE_SORT_RULE});
        Planner planner = this.getPlanner(null, Programs.of((RuleSet)ruleSet));
        SqlNode parse = planner.parse("select \"empid\" from ( select * from \"emps\" order by \"emps\".\"deptno\") order by \"deptno\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel((SqlNode)validate).rel;
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.equalTo((Object)"EnumerableSort(sort0=[$1], dir0=[ASC])\n  EnumerableProject(empid=[$0], deptno=[$1])\n    EnumerableSort(sort0=[$1], dir0=[ASC])\n      EnumerableProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n        EnumerableTableScan(table=[[hr, emps]])\n"));
    }

    @Test
    public void testPlanWithExplicitTraitDefs() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{FilterMergeRule.INSTANCE, EnumerableRules.ENUMERABLE_FILTER_RULE, EnumerableRules.ENUMERABLE_PROJECT_RULE});
        ArrayList<RelTraitDef> traitDefs = new ArrayList<RelTraitDef>();
        traitDefs.add((RelTraitDef)ConventionTraitDef.INSTANCE);
        traitDefs.add((RelTraitDef)RelCollationTraitDef.INSTANCE);
        Planner planner = this.getPlanner(traitDefs, Programs.of((RuleSet)ruleSet));
        SqlNode parse = planner.parse("select * from \"emps\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel(validate).project();
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.equalTo((Object)"EnumerableProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  EnumerableTableScan(table=[[hr, emps]])\n"));
    }

    @Test
    public void testPlanTransformTwice() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{FilterMergeRule.INSTANCE, EnumerableRules.ENUMERABLE_FILTER_RULE, EnumerableRules.ENUMERABLE_PROJECT_RULE});
        Planner planner = this.getPlanner(null, Programs.of((RuleSet)ruleSet));
        SqlNode parse = planner.parse("select * from \"emps\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel(validate).project();
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        RelNode transform2 = planner.transform(0, traitSet, transform);
        Assert.assertThat((Object)this.toString(transform2), (Matcher)CoreMatchers.equalTo((Object)"EnumerableProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  EnumerableTableScan(table=[[hr, emps]])\n"));
    }

    @Test
    public void testPlanTransformWithRuleNameConflicts() throws Exception {
        RelOptRule rule1 = new RelOptRule(RelOptRule.operand(LogicalProject.class, (RelOptRuleOperand)RelOptRule.operand(LogicalFilter.class, (RelOptRuleOperandChildren)RelOptRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "MYRULE"){

            public boolean matches(RelOptRuleCall call) {
                return false;
            }

            public void onMatch(RelOptRuleCall call) {
            }
        };
        RelOptRule rule2 = new RelOptRule(RelOptRule.operand(LogicalFilter.class, (RelOptRuleOperand)RelOptRule.operand(LogicalProject.class, (RelOptRuleOperandChildren)RelOptRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "MYRULE"){

            public boolean matches(RelOptRuleCall call) {
                return false;
            }

            public void onMatch(RelOptRuleCall call) {
            }
        };
        RuleSet ruleSet1 = RuleSets.ofList((RelOptRule[])new RelOptRule[]{rule1, EnumerableRules.ENUMERABLE_FILTER_RULE, EnumerableRules.ENUMERABLE_PROJECT_RULE});
        RuleSet ruleSet2 = RuleSets.ofList((RelOptRule[])new RelOptRule[]{rule2});
        Planner planner = this.getPlanner(null, Programs.of((RuleSet)ruleSet1), Programs.of((RuleSet)ruleSet2));
        SqlNode parse = planner.parse("select * from \"emps\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel((SqlNode)validate).rel;
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        RelNode transform2 = planner.transform(1, traitSet, transform);
        Assert.assertThat((Object)this.toString(transform2), (Matcher)CoreMatchers.equalTo((Object)"EnumerableProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  EnumerableTableScan(table=[[hr, emps]])\n"));
    }

    @Test
    public void testHiveDialect() throws SqlParseException {
        Planner planner = this.getPlanner(null, new Program[0]);
        SqlNode parse = planner.parse("select * from (select * from \"emps\") as t\nwhere \"name\" like '%e%'");
        SqlDialect hiveDialect = SqlDialect.DatabaseProduct.HIVE.getDialect();
        Assert.assertThat((Object)Util.toLinux((String)parse.toSqlString(hiveDialect).getSql()), (Matcher)CoreMatchers.equalTo((Object)"SELECT *\nFROM (SELECT *\nFROM emps) T\nWHERE name LIKE '%e%'"));
    }

    @Test
    public void testPlanTransformWithDiffRuleSetAndConvention() throws Exception {
        Program program0 = Programs.ofRules((RelOptRule[])new RelOptRule[]{FilterMergeRule.INSTANCE, EnumerableRules.ENUMERABLE_FILTER_RULE, EnumerableRules.ENUMERABLE_PROJECT_RULE});
        JdbcConvention out = new JdbcConvention(null, null, "myjdbc");
        Program program1 = Programs.ofRules((RelOptRule[])new RelOptRule[]{new MockJdbcProjectRule(out), new MockJdbcTableRule(out)});
        Planner planner = this.getPlanner(null, program0, program1);
        SqlNode parse = planner.parse("select T1.\"name\" from \"emps\" as T1 ");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel(validate).project();
        RelTraitSet traitSet0 = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelTraitSet traitSet1 = planner.getEmptyTraitSet().replace((RelTrait)out);
        RelNode transform = planner.transform(0, traitSet0, convert);
        RelNode transform2 = planner.transform(1, traitSet1, transform);
        Assert.assertThat((Object)this.toString(transform2), (Matcher)CoreMatchers.equalTo((Object)"JdbcProject(name=[$2])\n  MockJdbcTableScan(table=[[hr, emps]])\n"));
    }

    @Test
    public void testPlanNWayJoin() throws Exception {
        this.checkJoinNWay(5);
        this.checkJoinNWay(9);
        this.checkJoinNWay(35);
        if (CalciteAssert.ENABLE_SLOW) {
            this.checkJoinNWay(60);
        }
    }

    private void checkJoinNWay(int n) throws Exception {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("select *");
        for (i = 0; i < n; ++i) {
            buf.append(i == 0 ? "\nfrom " : ",\n ").append("\"depts\" as d").append(i);
        }
        for (i = 1; i < n; ++i) {
            buf.append(i == 1 ? "\nwhere" : "\nand").append(" d").append(i).append(".\"deptno\" = d").append(i - 1).append(".\"deptno\"");
        }
        Planner planner = this.getPlanner(null, Programs.heuristicJoinOrder((Iterable)Programs.RULE_SET, (boolean)false, (int)6));
        SqlNode parse = planner.parse(buf.toString());
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel(validate).project();
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.containsString((String)"EnumerableJoin(condition=[=($0, $5)], joinType=[inner])"));
    }

    @Test
    public void testHeuristicLeftJoin() throws Exception {
        this.checkHeuristic("select * from \"emps\" as e\nleft join \"depts\" as d using (\"deptno\")\njoin \"dependents\" as p on e.\"empid\" = p.\"empid\"", "EnumerableProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4], deptno0=[$5], name0=[$6], employees=[$7], location=[$8], location9=[$9], empid0=[$10], name1=[$11])\n  EnumerableProject(empid=[$2], deptno=[$3], name=[$4], salary=[$5], commission=[$6], deptno0=[$7], name0=[$8], employees=[$9], x=[$10], y=[$11], empid0=[$0], name1=[$1])\n    EnumerableJoin(condition=[=($0, $2)], joinType=[inner])\n      EnumerableTableScan(table=[[hr, dependents]])\n      EnumerableJoin(condition=[=($1, $5)], joinType=[left])\n        EnumerableTableScan(table=[[hr, emps]])\n        EnumerableProject(deptno=[$0], name=[$1], employees=[$2], x=[$3.x], y=[$3.y])\n          EnumerableTableScan(table=[[hr, depts]])");
    }

    @Test
    public void testHeuristicPushInnerJoin() throws Exception {
        this.checkHeuristic("select * from \"emps\" as e\nright join \"depts\" as d using (\"deptno\")\njoin \"dependents\" as p on e.\"empid\" = p.\"empid\"", "EnumerableProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4], deptno0=[$5], name0=[$6], employees=[$7], location=[$8], location9=[$9], empid0=[$10], name1=[$11])\n  EnumerableProject(empid=[$2], deptno=[$3], name=[$4], salary=[$5], commission=[$6], deptno0=[$7], name0=[$8], employees=[$9], x=[$10], y=[$11], empid0=[$0], name1=[$1])\n    EnumerableJoin(condition=[=($0, $2)], joinType=[inner])\n      EnumerableTableScan(table=[[hr, dependents]])\n      EnumerableProject(empid=[$5], deptno=[$6], name=[$7], salary=[$8], commission=[$9], deptno0=[$0], name0=[$1], employees=[$2], x=[$3], y=[$4])\n        EnumerableJoin(condition=[=($0, $6)], joinType=[left])\n          EnumerableProject(deptno=[$0], name=[$1], employees=[$2], x=[$3.x], y=[$3.y])\n            EnumerableTableScan(table=[[hr, depts]])\n          EnumerableTableScan(table=[[hr, emps]])");
    }

    @Test
    public void testHeuristicRightJoin() throws Exception {
        this.checkHeuristic("select * from \"emps\" as e\njoin \"depts\" as d using (\"deptno\")\nright join \"dependents\" as p on e.\"empid\" = p.\"empid\"", "EnumerableProject(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4], deptno0=[$5], name0=[$6], employees=[$7], location=[$8], location9=[$9], empid0=[$10], name1=[$11])\n  EnumerableProject(empid=[$2], deptno=[$3], name=[$4], salary=[$5], commission=[$6], deptno0=[$7], name0=[$8], employees=[$9], x=[$10], y=[$11], empid0=[$0], name1=[$1])\n    EnumerableJoin(condition=[=($0, $2)], joinType=[left])\n      EnumerableTableScan(table=[[hr, dependents]])\n      EnumerableJoin(condition=[=($1, $5)], joinType=[inner])\n        EnumerableTableScan(table=[[hr, emps]])\n        EnumerableProject(deptno=[$0], name=[$1], employees=[$2], x=[$3.x], y=[$3.y])\n          EnumerableTableScan(table=[[hr, depts]])");
    }

    private void checkHeuristic(String sql, String expected) throws Exception {
        Planner planner = this.getPlanner(null, Programs.heuristicJoinOrder((Iterable)Programs.RULE_SET, (boolean)false, (int)0));
        SqlNode parse = planner.parse(sql);
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel((SqlNode)validate).rel;
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.containsString((String)expected));
    }

    @Test
    public void testAlmostBushy() throws Exception {
        this.checkBushy("select *\nfrom \"sales_fact_1997\" as s\n  join \"customer\" as c using (\"customer_id\")\n  join \"product\" as p using (\"product_id\")\nwhere c.\"city\" = 'San Francisco'\nand p.\"brand_name\" = 'Washington'", "EnumerableProject(product_id=[$0], time_id=[$1], customer_id=[$2], promotion_id=[$3], store_id=[$4], store_sales=[$5], store_cost=[$6], unit_sales=[$7], customer_id0=[$8], account_num=[$9], lname=[$10], fname=[$11], mi=[$12], address1=[$13], address2=[$14], address3=[$15], address4=[$16], city=[$17], state_province=[$18], postal_code=[$19], country=[$20], customer_region_id=[$21], phone1=[$22], phone2=[$23], birthdate=[$24], marital_status=[$25], yearly_income=[$26], gender=[$27], total_children=[$28], num_children_at_home=[$29], education=[$30], date_accnt_opened=[$31], member_card=[$32], occupation=[$33], houseowner=[$34], num_cars_owned=[$35], fullname=[$36], product_class_id=[$37], product_id0=[$38], brand_name=[$39], product_name=[$40], SKU=[$41], SRP=[$42], gross_weight=[$43], net_weight=[$44], recyclable_package=[$45], low_fat=[$46], units_per_case=[$47], cases_per_pallet=[$48], shelf_width=[$49], shelf_height=[$50], shelf_depth=[$51])\n  EnumerableProject(product_id0=[$44], time_id=[$45], customer_id0=[$46], promotion_id=[$47], store_id=[$48], store_sales=[$49], store_cost=[$50], unit_sales=[$51], customer_id=[$15], account_num=[$16], lname=[$17], fname=[$18], mi=[$19], address1=[$20], address2=[$21], address3=[$22], address4=[$23], city=[$24], state_province=[$25], postal_code=[$26], country=[$27], customer_region_id=[$28], phone1=[$29], phone2=[$30], birthdate=[$31], marital_status=[$32], yearly_income=[$33], gender=[$34], total_children=[$35], num_children_at_home=[$36], education=[$37], date_accnt_opened=[$38], member_card=[$39], occupation=[$40], houseowner=[$41], num_cars_owned=[$42], fullname=[$43], product_class_id=[$0], product_id=[$1], brand_name=[$2], product_name=[$3], SKU=[$4], SRP=[$5], gross_weight=[$6], net_weight=[$7], recyclable_package=[$8], low_fat=[$9], units_per_case=[$10], cases_per_pallet=[$11], shelf_width=[$12], shelf_height=[$13], shelf_depth=[$14])\n    EnumerableJoin(condition=[=($1, $44)], joinType=[inner])\n      EnumerableFilter(condition=[=($2, 'Washington')])\n        EnumerableTableScan(table=[[foodmart2, product]])\n      EnumerableJoin(condition=[=($0, $31)], joinType=[inner])\n        EnumerableFilter(condition=[=($9, 'San Francisco')])\n          EnumerableTableScan(table=[[foodmart2, customer]])\n        EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])\n");
    }

    @Test
    public void testBushy() throws Exception {
        this.checkBushy("select *\nfrom \"sales_fact_1997\" as s\n  join \"customer\" as c using (\"customer_id\")\n  join \"product\" as p using (\"product_id\")\n  join \"product_class\" as pc using (\"product_class_id\")\nwhere c.\"city\" = 'San Francisco'\nand p.\"brand_name\" = 'Washington'", "EnumerableProject(product_id=[$0], time_id=[$1], customer_id=[$2], promotion_id=[$3], store_id=[$4], store_sales=[$5], store_cost=[$6], unit_sales=[$7], customer_id0=[$8], account_num=[$9], lname=[$10], fname=[$11], mi=[$12], address1=[$13], address2=[$14], address3=[$15], address4=[$16], city=[$17], state_province=[$18], postal_code=[$19], country=[$20], customer_region_id=[$21], phone1=[$22], phone2=[$23], birthdate=[$24], marital_status=[$25], yearly_income=[$26], gender=[$27], total_children=[$28], num_children_at_home=[$29], education=[$30], date_accnt_opened=[$31], member_card=[$32], occupation=[$33], houseowner=[$34], num_cars_owned=[$35], fullname=[$36], product_class_id=[$37], product_id0=[$38], brand_name=[$39], product_name=[$40], SKU=[$41], SRP=[$42], gross_weight=[$43], net_weight=[$44], recyclable_package=[$45], low_fat=[$46], units_per_case=[$47], cases_per_pallet=[$48], shelf_width=[$49], shelf_height=[$50], shelf_depth=[$51], product_class_id0=[$52], product_subcategory=[$53], product_category=[$54], product_department=[$55], product_family=[$56])\n  EnumerableProject(product_id0=[$49], time_id=[$50], customer_id0=[$51], promotion_id=[$52], store_id=[$53], store_sales=[$54], store_cost=[$55], unit_sales=[$56], customer_id=[$0], account_num=[$1], lname=[$2], fname=[$3], mi=[$4], address1=[$5], address2=[$6], address3=[$7], address4=[$8], city=[$9], state_province=[$10], postal_code=[$11], country=[$12], customer_region_id=[$13], phone1=[$14], phone2=[$15], birthdate=[$16], marital_status=[$17], yearly_income=[$18], gender=[$19], total_children=[$20], num_children_at_home=[$21], education=[$22], date_accnt_opened=[$23], member_card=[$24], occupation=[$25], houseowner=[$26], num_cars_owned=[$27], fullname=[$28], product_class_id0=[$34], product_id=[$35], brand_name=[$36], product_name=[$37], SKU=[$38], SRP=[$39], gross_weight=[$40], net_weight=[$41], recyclable_package=[$42], low_fat=[$43], units_per_case=[$44], cases_per_pallet=[$45], shelf_width=[$46], shelf_height=[$47], shelf_depth=[$48], product_class_id=[$29], product_subcategory=[$30], product_category=[$31], product_department=[$32], product_family=[$33])\n    EnumerableJoin(condition=[=($0, $51)], joinType=[inner])\n      EnumerableFilter(condition=[=($9, 'San Francisco')])\n        EnumerableTableScan(table=[[foodmart2, customer]])\n      EnumerableJoin(condition=[=($6, $20)], joinType=[inner])\n        EnumerableJoin(condition=[=($0, $5)], joinType=[inner])\n          EnumerableTableScan(table=[[foodmart2, product_class]])\n          EnumerableFilter(condition=[=($2, 'Washington')])\n            EnumerableTableScan(table=[[foodmart2, product]])\n        EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])\n");
    }

    @Test
    public void testBushy5() throws Exception {
        this.checkBushy("select *\nfrom \"sales_fact_1997\" as s\n  join \"customer\" as c using (\"customer_id\")\n  join \"product\" as p using (\"product_id\")\n  join \"product_class\" as pc using (\"product_class_id\")\n  join \"store\" as st using (\"store_id\")\nwhere c.\"city\" = 'San Francisco'\n", "EnumerableProject(product_id=[$0], time_id=[$1], customer_id=[$2], promotion_id=[$3], store_id=[$4], store_sales=[$5], store_cost=[$6], unit_sales=[$7], customer_id0=[$8], account_num=[$9], lname=[$10], fname=[$11], mi=[$12], address1=[$13], address2=[$14], address3=[$15], address4=[$16], city=[$17], state_province=[$18], postal_code=[$19], country=[$20], customer_region_id=[$21], phone1=[$22], phone2=[$23], birthdate=[$24], marital_status=[$25], yearly_income=[$26], gender=[$27], total_children=[$28], num_children_at_home=[$29], education=[$30], date_accnt_opened=[$31], member_card=[$32], occupation=[$33], houseowner=[$34], num_cars_owned=[$35], fullname=[$36], product_class_id=[$37], product_id0=[$38], brand_name=[$39], product_name=[$40], SKU=[$41], SRP=[$42], gross_weight=[$43], net_weight=[$44], recyclable_package=[$45], low_fat=[$46], units_per_case=[$47], cases_per_pallet=[$48], shelf_width=[$49], shelf_height=[$50], shelf_depth=[$51], product_class_id0=[$52], product_subcategory=[$53], product_category=[$54], product_department=[$55], product_family=[$56], store_id0=[$57], store_type=[$58], region_id=[$59], store_name=[$60], store_number=[$61], store_street_address=[$62], store_city=[$63], store_state=[$64], store_postal_code=[$65], store_country=[$66], store_manager=[$67], store_phone=[$68], store_fax=[$69], first_opened_date=[$70], last_remodel_date=[$71], store_sqft=[$72], grocery_sqft=[$73], frozen_sqft=[$74], meat_sqft=[$75], coffee_bar=[$76], video_store=[$77], salad_bar=[$78], prepared_food=[$79], florist=[$80])\n  EnumerableProject(product_id0=[$73], time_id=[$74], customer_id0=[$75], promotion_id=[$76], store_id0=[$77], store_sales=[$78], store_cost=[$79], unit_sales=[$80], customer_id=[$24], account_num=[$25], lname=[$26], fname=[$27], mi=[$28], address1=[$29], address2=[$30], address3=[$31], address4=[$32], city=[$33], state_province=[$34], postal_code=[$35], country=[$36], customer_region_id=[$37], phone1=[$38], phone2=[$39], birthdate=[$40], marital_status=[$41], yearly_income=[$42], gender=[$43], total_children=[$44], num_children_at_home=[$45], education=[$46], date_accnt_opened=[$47], member_card=[$48], occupation=[$49], houseowner=[$50], num_cars_owned=[$51], fullname=[$52], product_class_id0=[$58], product_id=[$59], brand_name=[$60], product_name=[$61], SKU=[$62], SRP=[$63], gross_weight=[$64], net_weight=[$65], recyclable_package=[$66], low_fat=[$67], units_per_case=[$68], cases_per_pallet=[$69], shelf_width=[$70], shelf_height=[$71], shelf_depth=[$72], product_class_id=[$53], product_subcategory=[$54], product_category=[$55], product_department=[$56], product_family=[$57], store_id=[$0], store_type=[$1], region_id=[$2], store_name=[$3], store_number=[$4], store_street_address=[$5], store_city=[$6], store_state=[$7], store_postal_code=[$8], store_country=[$9], store_manager=[$10], store_phone=[$11], store_fax=[$12], first_opened_date=[$13], last_remodel_date=[$14], store_sqft=[$15], grocery_sqft=[$16], frozen_sqft=[$17], meat_sqft=[$18], coffee_bar=[$19], video_store=[$20], salad_bar=[$21], prepared_food=[$22], florist=[$23])\n    EnumerableJoin(condition=[=($0, $77)], joinType=[inner])\n      EnumerableTableScan(table=[[foodmart2, store]])\n      EnumerableJoin(condition=[=($0, $51)], joinType=[inner])\n        EnumerableFilter(condition=[=($9, 'San Francisco')])\n          EnumerableTableScan(table=[[foodmart2, customer]])\n        EnumerableJoin(condition=[=($6, $20)], joinType=[inner])\n          EnumerableJoin(condition=[=($0, $5)], joinType=[inner])\n            EnumerableTableScan(table=[[foodmart2, product_class]])\n            EnumerableTableScan(table=[[foodmart2, product]])\n          EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])\n");
    }

    @Test
    public void testBushyCrossJoin() throws Exception {
        this.checkBushy("select * from \"sales_fact_1997\"\njoin \"customer\" using (\"customer_id\")\ncross join \"department\"", "EnumerableProject(product_id=[$0], time_id=[$1], customer_id=[$2], promotion_id=[$3], store_id=[$4], store_sales=[$5], store_cost=[$6], unit_sales=[$7], customer_id0=[$8], account_num=[$9], lname=[$10], fname=[$11], mi=[$12], address1=[$13], address2=[$14], address3=[$15], address4=[$16], city=[$17], state_province=[$18], postal_code=[$19], country=[$20], customer_region_id=[$21], phone1=[$22], phone2=[$23], birthdate=[$24], marital_status=[$25], yearly_income=[$26], gender=[$27], total_children=[$28], num_children_at_home=[$29], education=[$30], date_accnt_opened=[$31], member_card=[$32], occupation=[$33], houseowner=[$34], num_cars_owned=[$35], fullname=[$36], department_id=[$37], department_description=[$38])\n  EnumerableProject(product_id=[$31], time_id=[$32], customer_id0=[$33], promotion_id=[$34], store_id=[$35], store_sales=[$36], store_cost=[$37], unit_sales=[$38], customer_id=[$2], account_num=[$3], lname=[$4], fname=[$5], mi=[$6], address1=[$7], address2=[$8], address3=[$9], address4=[$10], city=[$11], state_province=[$12], postal_code=[$13], country=[$14], customer_region_id=[$15], phone1=[$16], phone2=[$17], birthdate=[$18], marital_status=[$19], yearly_income=[$20], gender=[$21], total_children=[$22], num_children_at_home=[$23], education=[$24], date_accnt_opened=[$25], member_card=[$26], occupation=[$27], houseowner=[$28], num_cars_owned=[$29], fullname=[$30], department_id=[$0], department_description=[$1])\n    EnumerableJoin(condition=[true], joinType=[inner])\n      EnumerableTableScan(table=[[foodmart2, department]])\n      EnumerableJoin(condition=[=($0, $31)], joinType=[inner])\n        EnumerableTableScan(table=[[foodmart2, customer]])\n        EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])");
    }

    @Test
    public void testBushyCrossJoin2() throws Exception {
        this.checkBushy("select * from \"sales_fact_1997\"\njoin \"customer\" using (\"customer_id\")\ncross join \"department\"\njoin \"employee\" using (\"department_id\")", "EnumerableProject(product_id=[$0], time_id=[$1], customer_id=[$2], promotion_id=[$3], store_id=[$4], store_sales=[$5], store_cost=[$6], unit_sales=[$7], customer_id0=[$8], account_num=[$9], lname=[$10], fname=[$11], mi=[$12], address1=[$13], address2=[$14], address3=[$15], address4=[$16], city=[$17], state_province=[$18], postal_code=[$19], country=[$20], customer_region_id=[$21], phone1=[$22], phone2=[$23], birthdate=[$24], marital_status=[$25], yearly_income=[$26], gender=[$27], total_children=[$28], num_children_at_home=[$29], education=[$30], date_accnt_opened=[$31], member_card=[$32], occupation=[$33], houseowner=[$34], num_cars_owned=[$35], fullname=[$36], department_id=[$37], department_description=[$38], employee_id=[$39], full_name=[$40], first_name=[$41], last_name=[$42], position_id=[$43], position_title=[$44], store_id0=[$45], department_id0=[$46], birth_date=[$47], hire_date=[$48], end_date=[$49], salary=[$50], supervisor_id=[$51], education_level=[$52], marital_status0=[$53], gender0=[$54], management_role=[$55])\n  EnumerableProject(product_id=[$48], time_id=[$49], customer_id0=[$50], promotion_id=[$51], store_id0=[$52], store_sales=[$53], store_cost=[$54], unit_sales=[$55], customer_id=[$19], account_num=[$20], lname=[$21], fname=[$22], mi=[$23], address1=[$24], address2=[$25], address3=[$26], address4=[$27], city=[$28], state_province=[$29], postal_code=[$30], country=[$31], customer_region_id=[$32], phone1=[$33], phone2=[$34], birthdate=[$35], marital_status0=[$36], yearly_income=[$37], gender0=[$38], total_children=[$39], num_children_at_home=[$40], education=[$41], date_accnt_opened=[$42], member_card=[$43], occupation=[$44], houseowner=[$45], num_cars_owned=[$46], fullname=[$47], department_id=[$0], department_description=[$1], employee_id=[$2], full_name=[$3], first_name=[$4], last_name=[$5], position_id=[$6], position_title=[$7], store_id=[$8], department_id0=[$9], birth_date=[$10], hire_date=[$11], end_date=[$12], salary=[$13], supervisor_id=[$14], education_level=[$15], marital_status=[$16], gender=[$17], management_role=[$18])\n    EnumerableJoin(condition=[true], joinType=[inner])\n      EnumerableJoin(condition=[=($0, $9)], joinType=[inner])\n        EnumerableTableScan(table=[[foodmart2, department]])\n        EnumerableTableScan(table=[[foodmart2, employee]])\n      EnumerableJoin(condition=[=($0, $31)], joinType=[inner])\n        EnumerableTableScan(table=[[foodmart2, customer]])\n        EnumerableTableScan(table=[[foodmart2, sales_fact_1997]])\n");
    }

    private void checkBushy(String sql, String expected) throws Exception {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.CLONE_FOODMART)).traitDefs((List)null).programs(new Program[]{Programs.heuristicJoinOrder((Iterable)Programs.RULE_SET, (boolean)true, (int)2)}).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        SqlNode parse = planner.parse(sql);
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.rel(validate).project();
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.containsString((String)expected));
    }

    @Test
    public void testOldJoinStyleDeCorrelation() throws Exception {
        Assert.assertFalse((boolean)this.checkTpchQuery("select\n p.`pPartkey`\nfrom\n  `tpch`.`part` p,\n  `tpch`.`partsupp` ps1\nwhere\n  p.`pPartkey` = ps1.`psPartkey`\n  and ps1.`psSupplyCost` = (\n    select\n      min(ps.`psSupplyCost`)\n    from\n      `tpch`.`partsupp` ps\n    where\n      p.`pPartkey` = ps.`psPartkey`\n  )\n").contains("Correlat"));
    }

    public String checkTpchQuery(String tpchTestQuery) throws Exception {
        String plan;
        SchemaPlus schema = Frameworks.createRootSchema((boolean)true).add("tpch", (Schema)new ReflectiveSchema((Object)new TpchSchema()));
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(SqlParser.configBuilder().setLex(Lex.MYSQL).build()).defaultSchema(schema).programs(new Program[]{Programs.ofRules((Iterable)Programs.RULE_SET)}).build();
        try (Planner p = Frameworks.getPlanner((FrameworkConfig)config);){
            SqlNode n = p.parse(tpchTestQuery);
            n = p.validate(n);
            RelNode r = p.rel(n).project();
            plan = RelOptUtil.toString((RelNode)r);
        }
        return plan;
    }

    @Test
    public void testOrderByNonSelectColumn() throws Exception {
        String plan;
        SchemaPlus schema = Frameworks.createRootSchema((boolean)true).add("tpch", (Schema)new ReflectiveSchema((Object)new TpchSchema()));
        String query = "select t.psPartkey from \n(select ps.psPartkey from `tpch`.`partsupp` ps \norder by ps.psPartkey, ps.psSupplyCost) t \norder by t.psPartkey";
        ArrayList<Object> traitDefs = new ArrayList<Object>();
        traitDefs.add(ConventionTraitDef.INSTANCE);
        traitDefs.add(RelCollationTraitDef.INSTANCE);
        SqlParser.Config parserConfig = SqlParser.configBuilder().setLex(Lex.MYSQL).build();
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(parserConfig).defaultSchema(schema).traitDefs(traitDefs).programs(new Program[]{Programs.ofRules((Iterable)Programs.RULE_SET)}).build();
        try (Planner p = Frameworks.getPlanner((FrameworkConfig)config);){
            SqlNode n = p.parse(query);
            n = p.validate(n);
            RelNode r = p.rel(n).project();
            plan = RelOptUtil.toString((RelNode)r);
            plan = Util.toLinux((String)plan);
        }
        Assert.assertThat((Object)plan, (Matcher)CoreMatchers.equalTo((Object)"LogicalSort(sort0=[$0], dir0=[ASC])\n  LogicalProject(psPartkey=[$0])\n    LogicalProject(psPartkey=[$0])\n      LogicalSort(sort0=[$0], sort1=[$1], dir0=[ASC], dir1=[ASC])\n        LogicalProject(psPartkey=[$0], psSupplyCost=[$1])\n          EnumerableTableScan(table=[[tpch, partsupp]])\n"));
    }

    @Test
    public void testMergeProjectForceMode() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{new ProjectMergeRule(true, RelBuilder.proto((Object[])new Object[]{RelFactories.DEFAULT_PROJECT_FACTORY}))});
        Planner planner = this.getPlanner(null, Programs.of((RuleSet)ruleSet));
        planner.close();
    }

    public static class MyCountAggFunction
    extends SqlAggFunction {
        public MyCountAggFunction() {
            super("MY_COUNT", null, SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT, null, (SqlOperandTypeChecker)OperandTypes.ANY, SqlFunctionCategory.NUMERIC, false, false);
        }

        public List<RelDataType> getParameterTypes(RelDataTypeFactory typeFactory) {
            return ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.ANY));
        }

        public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
            return typeFactory.createSqlType(SqlTypeName.BIGINT);
        }

        public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
            if (call.isCountStar()) {
                return validator.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
            }
            return super.deriveType(validator, scope, call);
        }
    }

    private class MockJdbcTableScan
    extends TableScan
    implements JdbcRel {
        MockJdbcTableScan(RelOptCluster cluster, RelOptTable table, JdbcConvention jdbcConvention) {
            super(cluster, cluster.traitSetOf((RelTrait)jdbcConvention), table);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new MockJdbcTableScan(this.getCluster(), this.table, (JdbcConvention)this.getConvention());
        }

        public void register(RelOptPlanner planner) {
            JdbcConvention out = (JdbcConvention)this.getConvention();
            for (RelOptRule rule : JdbcRules.rules((JdbcConvention)out)) {
                planner.addRule(rule);
            }
        }

        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return null;
        }
    }

    private class MockJdbcTableRule
    extends ConverterRule {
        private MockJdbcTableRule(JdbcConvention out) {
            super(EnumerableTableScan.class, (RelTrait)EnumerableConvention.INSTANCE, (RelTrait)out, "MockJdbcTableRule");
        }

        public RelNode convert(RelNode rel) {
            EnumerableTableScan scan = (EnumerableTableScan)rel;
            return new MockJdbcTableScan(scan.getCluster(), scan.getTable(), (JdbcConvention)this.getOutConvention());
        }
    }

    private class MockJdbcProjectRule
    extends ConverterRule {
        private MockJdbcProjectRule(JdbcConvention out) {
            super(EnumerableProject.class, (RelTrait)EnumerableConvention.INSTANCE, (RelTrait)out, "MockJdbcProjectRule");
        }

        public RelNode convert(RelNode rel) {
            EnumerableProject project = (EnumerableProject)rel;
            return new JdbcRules.JdbcProject(rel.getCluster(), rel.getTraitSet().replace((RelTrait)this.getOutConvention()), MockJdbcProjectRule.convert((RelNode)project.getInput(), (RelTraitSet)project.getInput().getTraitSet().replace((RelTrait)this.getOutConvention())), project.getProjects(), project.getRowType());
        }
    }
}

