/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.rex.RexCorrelVariable;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.runtime.CalciteException;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAggFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParser;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.test.CalciteAssert;
import org.apache.hive.druid.org.apache.calcite.test.Matchers;
import org.apache.hive.druid.org.apache.calcite.tools.FrameworkConfig;
import org.apache.hive.druid.org.apache.calcite.tools.Frameworks;
import org.apache.hive.druid.org.apache.calcite.tools.Program;
import org.apache.hive.druid.org.apache.calcite.tools.Programs;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RelRunners;
import org.apache.hive.druid.org.apache.calcite.util.Holder;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.mapping.Mappings;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RelBuilderTest {
    public static Frameworks.ConfigBuilder config() {
        SchemaPlus rootSchema = Frameworks.createRootSchema((boolean)true);
        return Frameworks.newConfigBuilder().parserConfig(SqlParser.Config.DEFAULT).defaultSchema(CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.SCOTT)).traitDefs((List)null).programs(new Program[]{Programs.heuristicJoinOrder((Iterable)Programs.RULE_SET, (boolean)true, (int)2)});
    }

    @Test
    public void testScan() {
        RelNode root = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build()).scan(new String[]{"EMP"}).build();
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testScanQualifiedTable() {
        RelNode root = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build()).scan(new String[]{"scott", "EMP"}).build();
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testScanInvalidTable() {
        try {
            RelNode root = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build()).scan(new String[]{"ZZZ"}).build();
            Assert.fail((String)("expected error, got " + root));
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Table 'ZZZ' not found"));
        }
    }

    @Test
    public void testScanInvalidSchema() {
        try {
            RelNode root = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build()).scan(new String[]{"ZZZ", "EMP"}).build();
            Assert.fail((String)("expected error, got " + root));
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Table 'ZZZ.EMP' not found"));
        }
    }

    @Test
    public void testScanInvalidQualifiedTable() {
        try {
            RelNode root = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build()).scan(new String[]{"scott", "ZZZ"}).build();
            Assert.fail((String)("expected error, got " + root));
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Table 'scott.ZZZ' not found"));
        }
    }

    @Test
    public void testScanValidTableWrongCase() {
        try {
            RelNode root = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build()).scan(new String[]{"emp"}).build();
            Assert.fail((String)("Expected error (table names are case-sensitive), but got " + root));
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Table 'emp' not found"));
        }
    }

    @Test
    public void testScanFilterTrue() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.literal((Object)true)}).build();
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testScanFilterTriviallyFalse() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.equals(builder.literal((Object)1), builder.literal((Object)2))}).build();
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalValues(tuples=[[]])\n"));
    }

    @Test
    public void testScanFilterEquals() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.equals((RexNode)builder.field("DEPTNO"), builder.literal((Object)20))}).build();
        String expected = "LogicalFilter(condition=[=($7, 20)])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalFilter(condition=[=($7, 20)])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testScanFilterOr() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)20)}), builder.isNull((RexNode)builder.field(6))}), builder.isNotNull((RexNode)builder.field(3))}).build();
        String expected = "LogicalFilter(condition=[AND(OR(=($7, 20), IS NULL($6)), IS NOT NULL($3))])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalFilter(condition=[AND(OR(=($7, 20), IS NULL($6)), IS NOT NULL($3))])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testScanFilterOr2() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)20)}), builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)20)})})}).build();
        String expected = "LogicalFilter(condition=[>($7, 20)])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalFilter(condition=[>($7, 20)])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testScanFilterAndFalse() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)20)}), builder.literal((Object)false)}).build();
        String expected = "LogicalValues(tuples=[[]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalValues(tuples=[[]])\n"));
    }

    @Test
    public void testScanFilterAndTrue() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)20)}), builder.literal((Object)true)}).build();
        String expected = "LogicalFilter(condition=[>($7, 20)])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalFilter(condition=[>($7, 20)])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testBadFieldName() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        try {
            RexInputRef ref = builder.scan(new String[]{"EMP"}).field("deptno");
            Assert.fail((String)("expected error, got " + ref));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"field [deptno] not found; input fields are: [EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO]"));
        }
    }

    @Test
    public void testBadFieldOrdinal() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        try {
            RexInputRef ref = builder.scan(new String[]{"DEPT"}).field(20);
            Assert.fail((String)("expected error, got " + ref));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"field ordinal [20] out of range; input fields are: [DEPTNO, DNAME, LOC]"));
        }
    }

    @Test
    public void testBadType() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        try {
            builder.scan(new String[]{"EMP"});
            RexNode call = builder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{builder.field(1), builder.field(3)});
            Assert.fail((String)("expected error, got " + call));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"cannot derive type: +; operands: [$1: VARCHAR(10), $3: SMALLINT]"));
        }
    }

    @Test
    public void testProject() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("DEPTNO"), builder.cast((RexNode)builder.field(6), SqlTypeName.SMALLINT), builder.literal((Object)20), builder.field(6), builder.alias((RexNode)builder.field(6), "C")}).build();
        String expected = "LogicalProject(DEPTNO=[$7], COMM=[CAST($6):SMALLINT NOT NULL], $f2=[20], COMM0=[$6], C=[$6])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(DEPTNO=[$7], COMM=[CAST($6):SMALLINT NOT NULL], $f2=[20], COMM0=[$6], C=[$6])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testProject2() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("DEPTNO"), builder.cast((RexNode)builder.field(6), SqlTypeName.SMALLINT), builder.or(new RexNode[]{builder.equals((RexNode)builder.field("DEPTNO"), builder.literal((Object)20)), builder.and(new RexNode[]{builder.literal(null), builder.equals((RexNode)builder.field("DEPTNO"), builder.literal((Object)10)), builder.and(new RexNode[]{builder.isNull((RexNode)builder.field(6)), builder.not(builder.isNotNull((RexNode)builder.field(7)))})}), builder.equals((RexNode)builder.field("DEPTNO"), builder.literal((Object)20)), builder.equals((RexNode)builder.field("DEPTNO"), builder.literal((Object)30))}), builder.alias(builder.isNull((RexNode)builder.field(2)), "n2"), builder.alias(builder.isNotNull((RexNode)builder.field(3)), "nn2"), builder.literal((Object)20), builder.field(6), builder.alias((RexNode)builder.field(6), "C")}).build();
        String expected = "LogicalProject(DEPTNO=[$7], COMM=[CAST($6):SMALLINT NOT NULL], $f2=[OR(=($7, 20), AND(null, =($7, 10), IS NULL($6), IS NULL($7)), =($7, 30))], n2=[IS NULL($2)], nn2=[IS NOT NULL($3)], $f5=[20], COMM0=[$6], C=[$6])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(DEPTNO=[$7], COMM=[CAST($6):SMALLINT NOT NULL], $f2=[OR(=($7, 20), AND(null, =($7, 10), IS NULL($6), IS NULL($7)), =($7, 30))], n2=[IS NULL($2)], nn2=[IS NOT NULL($3)], $f5=[20], COMM0=[$6], C=[$6])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testProjectIdentity() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).project((Iterable)builder.fields((Mappings.TargetMapping)Mappings.bijection(Arrays.asList(0, 1, 2)))).build();
        String expected = "LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testProjectIdentityWithFieldsRename() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).project(new RexNode[]{builder.alias((RexNode)builder.field(0), "a"), builder.alias((RexNode)builder.field(1), "b"), builder.alias((RexNode)builder.field(2), "c")}).as("t1").project(new RexNode[]{builder.field("a"), builder.field("t1", "c")}).build();
        String expected = "LogicalProject(a=[$0], c=[$2])\n  LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(a=[$0], c=[$2])\n  LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testProjectIdentityWithFieldsRenameFilter() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).project(new RexNode[]{builder.alias((RexNode)builder.field(0), "a"), builder.alias((RexNode)builder.field(1), "b"), builder.alias((RexNode)builder.field(2), "c")}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field("a"), builder.literal((Object)20)})}).aggregate(builder.groupKey(new int[]{0, 1, 2}), new RelBuilder.AggCall[]{builder.aggregateCall(SqlStdOperatorTable.SUM, false, false, null, null, new RexNode[]{builder.field(0)})}).project(new RexNode[]{builder.field("c"), builder.field("a")}).build();
        String expected = "LogicalProject(c=[$2], a=[$0])\n  LogicalAggregate(group=[{0, 1, 2}], agg#0=[SUM($0)])\n    LogicalFilter(condition=[=($0, 20)])\n      LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(c=[$2], a=[$0])\n  LogicalAggregate(group=[{0, 1, 2}], agg#0=[SUM($0)])\n    LogicalFilter(condition=[=($0, 20)])\n      LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testProjectLeadingEdge() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).project((Iterable)builder.fields((Mappings.TargetMapping)Mappings.bijection(Arrays.asList(0, 1, 2)))).build();
        String expected = "LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testRename() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).rename(Arrays.asList("DEPTNO", null)).build();
        String expected = "LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalTableScan(table=[[scott, DEPT]])\n"));
        root = builder.scan(new String[]{"DEPT"}).rename((List)ImmutableList.of((Object)"DEPTNO")).build();
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalTableScan(table=[[scott, DEPT]])\n"));
        root = builder.scan(new String[]{"DEPT"}).rename(Arrays.asList("NAME", null, "DEPTNO")).build();
        String expected2 = "LogicalProject(NAME=[$0], DNAME=[$1], DEPTNO=[$2])\n  LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(NAME=[$0], DNAME=[$1], DEPTNO=[$2])\n  LogicalTableScan(table=[[scott, DEPT]])\n"));
        root = builder.scan(new String[]{"DEPT"}).rename(Arrays.asList("DEPTNO", null, "DEPTNO")).build();
        String expected3 = "LogicalProject(DEPTNO=[$0], DNAME=[$1], DEPTNO0=[$2])\n  LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(DEPTNO=[$0], DNAME=[$1], DEPTNO0=[$2])\n  LogicalTableScan(table=[[scott, DEPT]])\n"));
        root = builder.scan(new String[]{"DEPT"}).rename(Arrays.asList("DEPTNO", null, "DEPTNO")).rename(Arrays.asList("DEPTNO", null, "DEPTNO")).build();
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(DEPTNO=[$0], DNAME=[$1], DEPTNO0=[$2])\n  LogicalTableScan(table=[[scott, DEPT]])\n"));
        try {
            root = builder.scan(new String[]{"DEPT"}).rename((List)ImmutableList.of((Object)"NAME", (Object)"DEPTNO", (Object)"Y", (Object)"Z")).build();
            Assert.fail((String)("expected error, got " + root));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"More names than fields"));
        }
    }

    @Test
    public void testRenameValues() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.values(new String[]{"a", "b"}, new Object[]{true, 1, false, -50}).build();
        String expected = "LogicalValues(tuples=[[{ true, 1 }, { false, -50 }]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalValues(tuples=[[{ true, 1 }, { false, -50 }]])\n"));
        root = builder.push(root).rename((List)ImmutableList.of((Object)"x", (Object)"y z")).build();
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalValues(tuples=[[{ true, 1 }, { false, -50 }]])\n"));
        Assert.assertThat((Object)root.getRowType().getFieldNames().toString(), (Matcher)CoreMatchers.is((Object)"[x, y z]"));
    }

    @Test
    public void testPermute() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).permute(Mappings.bijection(Arrays.asList(1, 2, 0))).build();
        String expected = "LogicalProject(JOB=[$2], EMPNO=[$0], ENAME=[$1])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(JOB=[$2], EMPNO=[$0], ENAME=[$1])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testConvert() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelDataType rowType = builder.getTypeFactory().builder().add("a", SqlTypeName.BIGINT).add("b", SqlTypeName.VARCHAR, 10).add("c", SqlTypeName.VARCHAR, 10).build();
        RelNode root = builder.scan(new String[]{"DEPT"}).convert(rowType, false).build();
        String expected = "LogicalProject(DEPTNO=[CAST($0):BIGINT NOT NULL], DNAME=[CAST($1):VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], LOC=[CAST($2):VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL])\n  LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(DEPTNO=[CAST($0):BIGINT NOT NULL], DNAME=[CAST($1):VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], LOC=[CAST($2):VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL])\n  LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testConvertRename() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelDataType rowType = builder.getTypeFactory().builder().add("a", SqlTypeName.BIGINT).add("b", SqlTypeName.VARCHAR, 10).add("c", SqlTypeName.VARCHAR, 10).build();
        RelNode root = builder.scan(new String[]{"DEPT"}).convert(rowType, true).build();
        String expected = "LogicalProject(a=[CAST($0):BIGINT NOT NULL], b=[CAST($1):VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], c=[CAST($2):VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL])\n  LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(a=[CAST($0):BIGINT NOT NULL], b=[CAST($1):VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL], c=[CAST($2):VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL])\n  LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testAggregate() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.aggregateCall(SqlStdOperatorTable.COUNT, true, false, null, "C", new RexNode[]{builder.field("DEPTNO")})}).build();
        String expected = "LogicalAggregate(group=[{}], C=[COUNT(DISTINCT $7)])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalAggregate(group=[{}], C=[COUNT(DISTINCT $7)])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAggregate2() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(new RexNode[]{builder.field(1), builder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{builder.field(4), builder.field(3)}), builder.field(1)}), new RelBuilder.AggCall[]{builder.aggregateCall(SqlStdOperatorTable.COUNT, false, false, null, "C", new RexNode[0]), builder.aggregateCall(SqlStdOperatorTable.SUM, false, false, null, "S", new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{builder.field(3), builder.literal((Object)1)})})}).build();
        String expected = "LogicalAggregate(group=[{1, 8}], C=[COUNT()], S=[SUM($9)])\n  LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7], $f8=[+($4, $3)], $f9=[+($3, 1)])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalAggregate(group=[{1, 8}], C=[COUNT()], S=[SUM($9)])\n  LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7], $f8=[+($4, $3)], $f9=[+($3, 1)])\n    LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAggregate3() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(new RexNode[]{builder.field(1)}), new RelBuilder.AggCall[]{builder.aggregateCall(SqlStdOperatorTable.COUNT, false, false, null, "C", new RexNode[0])}).aggregate(builder.groupKey(new RexNode[]{builder.field(0)}), new RelBuilder.AggCall[0]).build();
        String expected = "LogicalProject(ENAME=[$0])\n  LogicalAggregate(group=[{1}], C=[COUNT()])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(ENAME=[$0])\n  LogicalAggregate(group=[{1}], C=[COUNT()])\n    LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAggregate4() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(new RexNode[]{builder.field(1)}), new RelBuilder.AggCall[]{builder.aggregateCall(SqlStdOperatorTable.COUNT, false, false, null, "C", new RexNode[0])}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field(1), builder.literal((Object)3)})}).aggregate(builder.groupKey(new RexNode[]{builder.field(0)}), new RelBuilder.AggCall[0]).build();
        String expected = "LogicalProject(ENAME=[$0])\n  LogicalFilter(condition=[>($1, 3)])\n    LogicalAggregate(group=[{1}], C=[COUNT()])\n      LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(ENAME=[$0])\n  LogicalFilter(condition=[>($1, 3)])\n    LogicalAggregate(group=[{1}], C=[COUNT()])\n      LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAggregateFilter() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(ImmutableBitSet.of((int[])new int[]{7}), ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{7}), (Object)ImmutableBitSet.of())), new RelBuilder.AggCall[]{builder.aggregateCall(SqlStdOperatorTable.COUNT, false, false, builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field("EMPNO"), builder.literal((Object)100)}), "C", new RexNode[0])}).build();
        String expected = "LogicalAggregate(group=[{7}], groups=[[{7}, {}]], C=[COUNT() FILTER $8])\n  LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7], $f8=[>($0, 100)])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalAggregate(group=[{7}], groups=[[{7}, {}]], C=[COUNT() FILTER $8])\n  LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7], $f8=[>($0, 100)])\n    LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAggregateFilterFails() {
        try {
            RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
            RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(new RexNode[]{builder.field("DEPTNO")}), new RelBuilder.AggCall[]{builder.aggregateCall(SqlStdOperatorTable.SUM, false, false, (RexNode)builder.field("COMM"), "C", new RexNode[]{builder.field("SAL")})}).build();
            Assert.fail((String)("expected error, got " + root));
        }
        catch (CalciteException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"FILTER expression must be of type BOOLEAN"));
        }
    }

    @Test
    public void testAggregateFilterNullable() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(new RexNode[]{builder.field("DEPTNO")}), new RelBuilder.AggCall[]{builder.aggregateCall(SqlStdOperatorTable.SUM, false, false, builder.call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{builder.field("COMM"), builder.literal((Object)100)}), "C", new RexNode[]{builder.field("SAL")})}).build();
        String expected = "LogicalAggregate(group=[{7}], C=[SUM($5) FILTER $8])\n  LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7], $f8=[IS TRUE(<($6, 100))])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalAggregate(group=[{7}], C=[SUM($5) FILTER $8])\n  LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7], $f8=[IS TRUE(<($6, 100))])\n    LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAggregateProjectWithAliases() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("DEPTNO")}).aggregate(builder.groupKey(new RexNode[]{builder.alias((RexNode)builder.field("DEPTNO"), "departmentNo")}), new RelBuilder.AggCall[0]).build();
        String expected = "LogicalAggregate(group=[{0}])\n  LogicalProject(departmentNo=[$0])\n    LogicalProject(DEPTNO=[$7])\n      LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalAggregate(group=[{0}])\n  LogicalProject(departmentNo=[$0])\n    LogicalProject(DEPTNO=[$7])\n      LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAggregateProjectWithExpression() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("DEPTNO")}).aggregate(builder.groupKey(new RexNode[]{builder.alias(builder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)3)}), "d3")}), new RelBuilder.AggCall[0]).build();
        String expected = "LogicalAggregate(group=[{1}])\n  LogicalProject(DEPTNO=[$0], d3=[$1])\n    LogicalProject(DEPTNO=[$0], $f1=[+($0, 3)])\n      LogicalProject(DEPTNO=[$7])\n        LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalAggregate(group=[{1}])\n  LogicalProject(DEPTNO=[$0], d3=[$1])\n    LogicalProject(DEPTNO=[$0], $f1=[+($0, 3)])\n      LogicalProject(DEPTNO=[$7])\n        LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAggregateGroupingKeyOutOfRangeFails() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        try {
            RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(ImmutableBitSet.of((int[])new int[]{17}), null), new RelBuilder.AggCall[0]).build();
            Assert.fail((String)("expected error, got " + root));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"out of bounds: {17}"));
        }
    }

    @Test
    public void testAggregateGroupingSetNotSubsetFails() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        try {
            RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(ImmutableBitSet.of((int[])new int[]{7}), ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{4}), (Object)ImmutableBitSet.of())), new RelBuilder.AggCall[0]).build();
            Assert.fail((String)("expected error, got " + root));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"group set element [$4] must be a subset of group key"));
        }
    }

    @Test
    public void testAggregateGroupingSetDuplicateIgnored() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(ImmutableBitSet.of((int[])new int[]{7, 6}), ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{7}), (Object)ImmutableBitSet.of((int[])new int[]{6}), (Object)ImmutableBitSet.of((int[])new int[]{7}))), new RelBuilder.AggCall[0]).build();
        String expected = "LogicalAggregate(group=[{6, 7}], groups=[[{6}, {7}]])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalAggregate(group=[{6, 7}], groups=[[{6}, {7}]])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAggregateGrouping() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(new int[]{6, 7}), new RelBuilder.AggCall[]{builder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.GROUPING, false, false, null, "g", new RexNode[]{builder.field("DEPTNO")})}).build();
        String expected = "LogicalAggregate(group=[{6, 7}], g=[GROUPING($7)])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalAggregate(group=[{6, 7}], g=[GROUPING($7)])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAggregateGroupingWithDistinctFails() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        try {
            RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(new int[]{6, 7}), new RelBuilder.AggCall[]{builder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.GROUPING, true, false, null, "g", new RexNode[]{builder.field("DEPTNO")})}).build();
            Assert.fail((String)("expected error, got " + root));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"DISTINCT not allowed"));
        }
    }

    @Test
    public void testAggregateGroupingWithFilterFails() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        try {
            RelNode root = builder.scan(new String[]{"EMP"}).aggregate(builder.groupKey(new int[]{6, 7}), new RelBuilder.AggCall[]{builder.aggregateCall((SqlAggFunction)SqlStdOperatorTable.GROUPING, false, false, builder.literal((Object)true), "g", new RexNode[]{builder.field("DEPTNO")})}).build();
            Assert.fail((String)("expected error, got " + root));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"FILTER not allowed"));
        }
    }

    @Test
    public void testDistinct() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("DEPTNO")}).distinct().build();
        String expected = "LogicalAggregate(group=[{0}])\n  LogicalProject(DEPTNO=[$7])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalAggregate(group=[{0}])\n  LogicalProject(DEPTNO=[$7])\n    LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testDistinctAlready() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).distinct().build();
        String expected = "LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testDistinctEmpty() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{builder.field("COMM")})}).project(new RexNode[0]).distinct().build();
        String expected = "LogicalAggregate(group=[{}])\n  LogicalProject\n    LogicalFilter(condition=[IS NULL($6)])\n      LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalAggregate(group=[{}])\n  LogicalProject\n    LogicalFilter(condition=[IS NULL($6)])\n      LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testUnion() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).project(new RexNode[]{builder.field("DEPTNO")}).scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)20)})}).project(new RexNode[]{builder.field("EMPNO")}).union(true).build();
        String expected = "LogicalUnion(all=[true])\n  LogicalProject(DEPTNO=[$0])\n    LogicalTableScan(table=[[scott, DEPT]])\n  LogicalProject(EMPNO=[$0])\n    LogicalFilter(condition=[=($7, 20)])\n      LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalUnion(all=[true])\n  LogicalProject(DEPTNO=[$0])\n    LogicalTableScan(table=[[scott, DEPT]])\n  LogicalProject(EMPNO=[$0])\n    LogicalFilter(condition=[=($7, 20)])\n      LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testBadUnionArgsErrorMessage() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        try {
            RelNode root = builder.scan(new String[]{"DEPT"}).project(new RexNode[]{builder.field("DEPTNO")}).scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("EMPNO"), builder.field("SAL")}).union(true).build();
            Assert.fail((String)("Expected error, got " + root));
        }
        catch (IllegalArgumentException e) {
            String expected = "Cannot compute compatible row type for arguments to set op: RecordType(TINYINT DEPTNO), RecordType(SMALLINT EMPNO, DECIMAL(7, 2) SAL)";
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Cannot compute compatible row type for arguments to set op: RecordType(TINYINT DEPTNO), RecordType(SMALLINT EMPNO, DECIMAL(7, 2) SAL)"));
        }
    }

    @Test
    public void testUnion3() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).project(new RexNode[]{builder.field("DEPTNO")}).scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("EMPNO")}).scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("DEPTNO")}).union(true, 3).build();
        String expected = "LogicalUnion(all=[true])\n  LogicalProject(DEPTNO=[$0])\n    LogicalTableScan(table=[[scott, DEPT]])\n  LogicalProject(EMPNO=[$0])\n    LogicalTableScan(table=[[scott, EMP]])\n  LogicalProject(DEPTNO=[$7])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalUnion(all=[true])\n  LogicalProject(DEPTNO=[$0])\n    LogicalTableScan(table=[[scott, DEPT]])\n  LogicalProject(EMPNO=[$0])\n    LogicalTableScan(table=[[scott, EMP]])\n  LogicalProject(DEPTNO=[$7])\n    LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testUnion1() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).project(new RexNode[]{builder.field("DEPTNO")}).scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("EMPNO")}).scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("DEPTNO")}).union(true, 1).build();
        String expected = "LogicalProject(DEPTNO=[$7])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(DEPTNO=[$7])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testIntersect() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).project(new RexNode[]{builder.field("DEPTNO")}).scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)20)})}).project(new RexNode[]{builder.field("EMPNO")}).intersect(false).build();
        String expected = "LogicalIntersect(all=[false])\n  LogicalProject(DEPTNO=[$0])\n    LogicalTableScan(table=[[scott, DEPT]])\n  LogicalProject(EMPNO=[$0])\n    LogicalFilter(condition=[=($7, 20)])\n      LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalIntersect(all=[false])\n  LogicalProject(DEPTNO=[$0])\n    LogicalTableScan(table=[[scott, DEPT]])\n  LogicalProject(EMPNO=[$0])\n    LogicalFilter(condition=[=($7, 20)])\n      LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testIntersect3() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).project(new RexNode[]{builder.field("DEPTNO")}).scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("EMPNO")}).scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("DEPTNO")}).intersect(true, 3).build();
        String expected = "LogicalIntersect(all=[true])\n  LogicalProject(DEPTNO=[$0])\n    LogicalTableScan(table=[[scott, DEPT]])\n  LogicalProject(EMPNO=[$0])\n    LogicalTableScan(table=[[scott, EMP]])\n  LogicalProject(DEPTNO=[$7])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalIntersect(all=[true])\n  LogicalProject(DEPTNO=[$0])\n    LogicalTableScan(table=[[scott, DEPT]])\n  LogicalProject(EMPNO=[$0])\n    LogicalTableScan(table=[[scott, EMP]])\n  LogicalProject(DEPTNO=[$7])\n    LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testExcept() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).project(new RexNode[]{builder.field("DEPTNO")}).scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)20)})}).project(new RexNode[]{builder.field("EMPNO")}).minus(false).build();
        String expected = "LogicalMinus(all=[false])\n  LogicalProject(DEPTNO=[$0])\n    LogicalTableScan(table=[[scott, DEPT]])\n  LogicalProject(EMPNO=[$0])\n    LogicalFilter(condition=[=($7, 20)])\n      LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalMinus(all=[false])\n  LogicalProject(DEPTNO=[$0])\n    LogicalTableScan(table=[[scott, DEPT]])\n  LogicalProject(EMPNO=[$0])\n    LogicalFilter(condition=[=($7, 20)])\n      LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testJoin() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{builder.field("COMM")})}).scan(new String[]{"DEPT"}).join(JoinRelType.INNER, builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field(2, 0, "DEPTNO"), builder.field(2, 1, "DEPTNO")})).build();
        String expected = "LogicalJoin(condition=[=($7, $8)], joinType=[inner])\n  LogicalFilter(condition=[IS NULL($6)])\n    LogicalTableScan(table=[[scott, EMP]])\n  LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalJoin(condition=[=($7, $8)], joinType=[inner])\n  LogicalFilter(condition=[IS NULL($6)])\n    LogicalTableScan(table=[[scott, EMP]])\n  LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testJoinUsing() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root2 = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{builder.field("COMM")})}).scan(new String[]{"DEPT"}).join(JoinRelType.INNER, new String[]{"DEPTNO"}).build();
        String expected = "LogicalJoin(condition=[=($7, $8)], joinType=[inner])\n  LogicalFilter(condition=[IS NULL($6)])\n    LogicalTableScan(table=[[scott, EMP]])\n  LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root2, Matchers.hasTree("LogicalJoin(condition=[=($7, $8)], joinType=[inner])\n  LogicalFilter(condition=[IS NULL($6)])\n    LogicalTableScan(table=[[scott, EMP]])\n  LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testJoin2() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).scan(new String[]{"DEPT"}).join(JoinRelType.LEFT, builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field(2, 0, "DEPTNO"), builder.field(2, 1, "DEPTNO")}), new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field(2, 0, "EMPNO"), builder.literal((Object)123)}), builder.call((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{builder.field(2, 1, "DEPTNO")})}).build();
        String expected = "LogicalJoin(condition=[AND(=($7, $8), =($0, 123))], joinType=[left])\n  LogicalTableScan(table=[[scott, EMP]])\n  LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalJoin(condition=[AND(=($7, $8), =($0, 123))], joinType=[left])\n  LogicalTableScan(table=[[scott, EMP]])\n  LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testJoinCartesian() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).scan(new String[]{"DEPT"}).join(JoinRelType.INNER, new String[0]).build();
        String expected = "LogicalJoin(condition=[true], joinType=[inner])\n  LogicalTableScan(table=[[scott, EMP]])\n  LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalJoin(condition=[true], joinType=[inner])\n  LogicalTableScan(table=[[scott, EMP]])\n  LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testCorrelationFails() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        Holder v = Holder.of(null);
        try {
            builder.scan(new String[]{"EMP"}).variable(v).filter(new RexNode[]{builder.equals((RexNode)builder.field(0), (RexNode)v.get())}).scan(new String[]{"DEPT"}).join(JoinRelType.INNER, builder.literal((Object)true), (Set)ImmutableSet.of((Object)((RexCorrelVariable)v.get()).id));
            Assert.fail((String)"expected error");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"variable $cor0 must not be used by left input to correlation"));
        }
    }

    @Test
    public void testCorrelationWithCondition() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        Holder v = Holder.of(null);
        RelNode root = builder.scan(new String[]{"EMP"}).variable(v).scan(new String[]{"DEPT"}).filter(new RexNode[]{builder.equals((RexNode)builder.field(0), builder.field((RexNode)v.get(), "DEPTNO"))}).join(JoinRelType.LEFT, builder.equals((RexNode)builder.field(2, 0, "SAL"), builder.literal((Object)1000)), (Set)ImmutableSet.of((Object)((RexCorrelVariable)v.get()).id)).build();
        String expected = "LogicalCorrelate(correlation=[$cor0], joinType=[left], requiredColumns=[{7}])\n  LogicalTableScan(table=[[scott, EMP]])\n  LogicalFilter(condition=[=($cor0.SAL, 1000)])\n    LogicalFilter(condition=[=($0, $cor0.DEPTNO)])\n      LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalCorrelate(correlation=[$cor0], joinType=[left], requiredColumns=[{7}])\n  LogicalTableScan(table=[[scott, EMP]])\n  LogicalFilter(condition=[=($cor0.SAL, 1000)])\n    LogicalFilter(condition=[=($0, $cor0.DEPTNO)])\n      LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testAlias() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).as("e").scan(new String[]{"DEPT"}).join(JoinRelType.LEFT, new String[0]).filter(new RexNode[]{builder.equals(builder.field("e", "DEPTNO"), builder.field("DEPT", "DEPTNO"))}).project(new RexNode[]{builder.field("e", "ENAME"), builder.field("DEPT", "DNAME")}).build();
        String expected = "LogicalProject(ENAME=[$1], DNAME=[$9])\n  LogicalFilter(condition=[=($7, $8)])\n    LogicalJoin(condition=[true], joinType=[left])\n      LogicalTableScan(table=[[scott, EMP]])\n      LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(ENAME=[$1], DNAME=[$9])\n  LogicalFilter(condition=[=($7, $8)])\n    LogicalJoin(condition=[true], joinType=[left])\n      LogicalTableScan(table=[[scott, EMP]])\n      LogicalTableScan(table=[[scott, DEPT]])\n"));
        RelDataTypeField field = (RelDataTypeField)root.getRowType().getFieldList().get(1);
        Assert.assertThat((Object)field.getName(), (Matcher)CoreMatchers.is((Object)"DNAME"));
        Assert.assertThat((Object)field.getType().isNullable(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testAlias2() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).as("e").scan(new String[]{"EMP"}).as("m").scan(new String[]{"DEPT"}).join(JoinRelType.INNER, new String[0]).join(JoinRelType.INNER, new String[0]).filter(new RexNode[]{builder.equals(builder.field("e", "DEPTNO"), builder.field("DEPT", "DEPTNO")), builder.equals(builder.field("m", "EMPNO"), builder.field("e", "MGR"))}).build();
        String expected = "LogicalFilter(condition=[AND(=($7, $16), =($8, $3))])\n  LogicalJoin(condition=[true], joinType=[inner])\n    LogicalTableScan(table=[[scott, EMP]])\n    LogicalJoin(condition=[true], joinType=[inner])\n      LogicalTableScan(table=[[scott, EMP]])\n      LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalFilter(condition=[AND(=($7, $16), =($8, $3))])\n  LogicalJoin(condition=[true], joinType=[inner])\n    LogicalTableScan(table=[[scott, EMP]])\n    LogicalJoin(condition=[true], joinType=[inner])\n      LogicalTableScan(table=[[scott, EMP]])\n      LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testAliasSort() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).as("e").sort(new int[]{0}).project(new RexNode[]{builder.field("e", "EMPNO")}).build();
        String expected = "LogicalProject(EMPNO=[$0])\n  LogicalSort(sort0=[$0], dir0=[ASC])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(EMPNO=[$0])\n  LogicalSort(sort0=[$0], dir0=[ASC])\n    LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAliasLimit() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).as("e").sort(new int[]{1}).sortLimit(10, 20, new RexNode[0]).project(new RexNode[]{builder.field("e", "EMPNO")}).build();
        String expected = "LogicalProject(EMPNO=[$0])\n  LogicalSort(sort0=[$1], dir0=[ASC], offset=[10], fetch=[20])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(EMPNO=[$0])\n  LogicalSort(sort0=[$1], dir0=[ASC], offset=[10], fetch=[20])\n    LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAliasProject() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).as("EMP_alias").project(new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)20)}).project(new RexNode[]{builder.field("EMP_alias", "DEPTNO")}).build();
        String expected = "LogicalProject(DEPTNO=[$0])\n  LogicalProject(DEPTNO=[$7], $f1=[20])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(DEPTNO=[$0])\n  LogicalProject(DEPTNO=[$7], $f1=[20])\n    LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAliasAggregate() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).as("EMP_alias").project(new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)20)}).aggregate(builder.groupKey(new RexNode[]{builder.field("EMP_alias", "DEPTNO")}), new RelBuilder.AggCall[]{builder.aggregateCall(SqlStdOperatorTable.SUM, false, false, null, null, new RexNode[]{builder.field(1)})}).project(new RexNode[]{builder.alias((RexNode)builder.field(1), "sum"), builder.field("EMP_alias", "DEPTNO")}).build();
        String expected = "LogicalProject(sum=[$1], DEPTNO=[$0])\n  LogicalAggregate(group=[{0}], agg#0=[SUM($1)])\n    LogicalProject(DEPTNO=[$7], $f1=[20])\n      LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(sum=[$1], DEPTNO=[$0])\n  LogicalAggregate(group=[{0}], agg#0=[SUM($1)])\n    LogicalProject(DEPTNO=[$7], $f1=[20])\n      LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testProjectJoin() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).as("e").scan(new String[]{"DEPT"}).join(JoinRelType.INNER, new String[0]).project(new RexNode[]{builder.field("DEPT", "DEPTNO"), builder.field(0), builder.field("e", "MGR")}).project(new RexNode[]{builder.field("DEPT", "DEPTNO"), builder.field(1), builder.field("e", "MGR")}).build();
        String expected = "LogicalProject(DEPTNO=[$8], EMPNO=[$0], MGR=[$3])\n  LogicalJoin(condition=[true], joinType=[inner])\n    LogicalTableScan(table=[[scott, EMP]])\n    LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(DEPTNO=[$8], EMPNO=[$0], MGR=[$3])\n  LogicalJoin(condition=[true], joinType=[inner])\n    LogicalTableScan(table=[[scott, EMP]])\n    LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testMultiLevelAlias() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).as("e").scan(new String[]{"EMP"}).as("m").scan(new String[]{"DEPT"}).join(JoinRelType.INNER, new String[0]).join(JoinRelType.INNER, new String[0]).project(new RexNode[]{builder.field("DEPT", "DEPTNO"), builder.field(16), builder.field("m", "EMPNO"), builder.field("e", "MGR")}).as("all").filter(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.field("DEPT", "DEPTNO"), builder.literal((Object)100)})}).project(new RexNode[]{builder.field("DEPT", "DEPTNO"), builder.field("all", "EMPNO")}).build();
        String expected = "LogicalProject(DEPTNO=[$0], EMPNO=[$2])\n  LogicalFilter(condition=[>($0, 100)])\n    LogicalProject(DEPTNO=[$16], DEPTNO0=[$16], EMPNO=[$8], MGR=[$3])\n      LogicalJoin(condition=[true], joinType=[inner])\n        LogicalTableScan(table=[[scott, EMP]])\n        LogicalJoin(condition=[true], joinType=[inner])\n          LogicalTableScan(table=[[scott, EMP]])\n          LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(DEPTNO=[$0], EMPNO=[$2])\n  LogicalFilter(condition=[>($0, 100)])\n    LogicalProject(DEPTNO=[$16], DEPTNO0=[$16], EMPNO=[$8], MGR=[$3])\n      LogicalJoin(condition=[true], joinType=[inner])\n        LogicalTableScan(table=[[scott, EMP]])\n        LogicalJoin(condition=[true], joinType=[inner])\n          LogicalTableScan(table=[[scott, EMP]])\n          LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testUnionAlias() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).as("e1").project(new RexNode[]{builder.field("EMPNO"), builder.call((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{builder.field("ENAME"), builder.literal((Object)"-1")})}).scan(new String[]{"EMP"}).as("e2").project(new RexNode[]{builder.field("EMPNO"), builder.call((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{builder.field("ENAME"), builder.literal((Object)"-2")})}).union(false).project((Iterable)builder.fields((List)Lists.newArrayList((Object[])new Integer[]{1, 0}))).build();
        String expected = "LogicalProject($f1=[$1], EMPNO=[$0])\n  LogicalUnion(all=[false])\n    LogicalProject(EMPNO=[$0], $f1=[||($1, '-1')])\n      LogicalTableScan(table=[[scott, EMP]])\n    LogicalProject(EMPNO=[$0], $f1=[||($1, '-2')])\n      LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject($f1=[$1], EMPNO=[$0])\n  LogicalUnion(all=[false])\n    LogicalProject(EMPNO=[$0], $f1=[||($1, '-1')])\n      LogicalTableScan(table=[[scott, EMP]])\n    LogicalProject(EMPNO=[$0], $f1=[||($1, '-2')])\n      LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testAliasPastTop() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).scan(new String[]{"DEPT"}).join(JoinRelType.LEFT, builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field(2, "EMP", "DEPTNO"), builder.field(2, "DEPT", "DEPTNO")}), new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{builder.field(2, "EMP", "EMPNO"), builder.literal((Object)123)})}).build();
        String expected = "LogicalJoin(condition=[AND(=($7, $8), =($0, 123))], joinType=[left])\n  LogicalTableScan(table=[[scott, EMP]])\n  LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalJoin(condition=[AND(=($7, $8), =($0, 123))], joinType=[left])\n  LogicalTableScan(table=[[scott, EMP]])\n  LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testAliasPastTop2() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).as("t1").scan(new String[]{"EMP"}).as("t2").join(JoinRelType.INNER, builder.equals(builder.field(2, "t1", "EMPNO"), builder.field(2, "t2", "EMPNO"))).scan(new String[]{"DEPT"}).as("t3").join(JoinRelType.INNER, builder.equals(builder.field(2, "t1", "DEPTNO"), builder.field(2, "t3", "DEPTNO")), new RexNode[]{builder.not(builder.equals(builder.field(2, "t2", "JOB"), builder.field(2, "t3", "LOC")))}).build();
        String expected = "LogicalJoin(condition=[AND(=($7, $16), <>($10, $18))], joinType=[inner])\n  LogicalJoin(condition=[=($0, $8)], joinType=[inner])\n    LogicalTableScan(table=[[scott, EMP]])\n    LogicalTableScan(table=[[scott, EMP]])\n  LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalJoin(condition=[AND(=($7, $16), <>($10, $18))], joinType=[inner])\n  LogicalJoin(condition=[=($0, $8)], joinType=[inner])\n    LogicalTableScan(table=[[scott, EMP]])\n    LogicalTableScan(table=[[scott, EMP]])\n  LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testEmpty() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).project(new RexNode[]{builder.field(0), builder.literal((Object)false)}).empty().build();
        String expected = "LogicalValues(tuples=[[]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalValues(tuples=[[]])\n"));
        String expectedType = "RecordType(TINYINT NOT NULL DEPTNO, BOOLEAN NOT NULL $f1) NOT NULL";
        Assert.assertThat((Object)root.getRowType().getFullTypeString(), (Matcher)CoreMatchers.is((Object)"RecordType(TINYINT NOT NULL DEPTNO, BOOLEAN NOT NULL $f1) NOT NULL"));
    }

    @Test
    public void testValues() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.values(new String[]{"a", "b"}, new Object[]{true, 1, false, -50}).build();
        String expected = "LogicalValues(tuples=[[{ true, 1 }, { false, -50 }]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalValues(tuples=[[{ true, 1 }, { false, -50 }]])\n"));
        String expectedType = "RecordType(BOOLEAN NOT NULL a, INTEGER NOT NULL b) NOT NULL";
        Assert.assertThat((Object)root.getRowType().getFullTypeString(), (Matcher)CoreMatchers.is((Object)"RecordType(BOOLEAN NOT NULL a, INTEGER NOT NULL b) NOT NULL"));
    }

    @Test
    public void testValuesNullable() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.values(new String[]{"a", null, "c"}, new Object[]{null, 1, "abc", false, null, "longer string"}).build();
        String expected = "LogicalValues(tuples=[[{ null, 1, 'abc' }, { false, null, 'longer string' }]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalValues(tuples=[[{ null, 1, 'abc' }, { false, null, 'longer string' }]])\n"));
        String expectedType = "RecordType(BOOLEAN a, INTEGER expr$1, CHAR(13) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL c) NOT NULL";
        Assert.assertThat((Object)root.getRowType().getFullTypeString(), (Matcher)CoreMatchers.is((Object)"RecordType(BOOLEAN a, INTEGER expr$1, CHAR(13) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL c) NOT NULL"));
    }

    @Test
    public void testValuesBadNullFieldNames() {
        try {
            RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
            RelBuilder root = builder.values((String[])null, new Object[]{"a", "b"});
            Assert.fail((String)("expected error, got " + root));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Value count must be a positive multiple of field count"));
        }
    }

    @Test
    public void testValuesBadNoFields() {
        try {
            RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
            RelBuilder root = builder.values(new String[0], new Object[]{1, 2, 3});
            Assert.fail((String)("expected error, got " + root));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Value count must be a positive multiple of field count"));
        }
    }

    @Test
    public void testValuesBadNoValues() {
        try {
            RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
            RelBuilder root = builder.values(new String[]{"a", "b"}, new Object[0]);
            Assert.fail((String)("expected error, got " + root));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Value count must be a positive multiple of field count"));
        }
    }

    @Test
    public void testValuesBadOddMultiple() {
        try {
            RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
            RelBuilder root = builder.values(new String[]{"a", "b"}, new Object[]{1, 2, 3, 4, 5});
            Assert.fail((String)("expected error, got " + root));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Value count must be a positive multiple of field count"));
        }
    }

    @Test
    public void testValuesBadAllNull() {
        try {
            RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
            RelBuilder root = builder.values(new String[]{"a", "b"}, new Object[]{null, null, 1, null});
            Assert.fail((String)("expected error, got " + root));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"All values of field 'b' are null; cannot deduce type"));
        }
    }

    @Test
    public void testValuesAllNull() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelDataType rowType = builder.getTypeFactory().builder().add("a", SqlTypeName.BIGINT).add("a", SqlTypeName.VARCHAR, 10).build();
        RelNode root = builder.values(rowType, new Object[]{null, null, 1, null}).build();
        String expected = "LogicalValues(tuples=[[{ null, null }, { 1, null }]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalValues(tuples=[[{ null, null }, { 1, null }]])\n"));
        String expectedType = "RecordType(BIGINT NOT NULL a, VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL a) NOT NULL";
        Assert.assertThat((Object)root.getRowType().getFullTypeString(), (Matcher)CoreMatchers.is((Object)"RecordType(BIGINT NOT NULL a, VARCHAR(10) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\" NOT NULL a) NOT NULL"));
    }

    @Test
    public void testSort() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).sort(new RexNode[]{builder.field(2), builder.desc((RexNode)builder.field(0))}).build();
        String expected = "LogicalSort(sort0=[$2], sort1=[$0], dir0=[ASC], dir1=[DESC])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalSort(sort0=[$2], sort1=[$0], dir0=[ASC], dir1=[DESC])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
        RelNode root2 = builder.scan(new String[]{"EMP"}).sort(new int[]{2, -1}).build();
        Assert.assertThat((Object)root2, Matchers.hasTree("LogicalSort(sort0=[$2], sort1=[$0], dir0=[ASC], dir1=[DESC])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testTrivialSort() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).sortLimit(0, -1, (Iterable)ImmutableList.of()).build();
        String expected = "LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testSortDuplicate() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).sort(new RexNode[]{builder.desc((RexNode)builder.field("EMPNO")), builder.field("DEPTNO"), builder.field("EMPNO"), builder.field("HIREDATE")}).build();
        String expected = "LogicalSort(sort0=[$0], sort1=[$7], sort2=[$4], dir0=[DESC], dir1=[ASC], dir2=[ASC])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalSort(sort0=[$0], sort1=[$7], sort2=[$4], dir0=[DESC], dir1=[ASC], dir2=[ASC])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testSortByExpression() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).sort(new RexNode[]{builder.nullsLast(builder.desc((RexNode)builder.field(1))), builder.nullsFirst(builder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{builder.field(4), builder.field(3)}))}).build();
        String expected = "LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7])\n  LogicalSort(sort0=[$1], sort1=[$8], dir0=[DESC-nulls-last], dir1=[ASC-nulls-first])\n    LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7], $f8=[+($4, $3)])\n      LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7])\n  LogicalSort(sort0=[$1], sort1=[$8], dir0=[DESC-nulls-last], dir1=[ASC-nulls-first])\n    LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7], $f8=[+($4, $3)])\n      LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testLimit() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).limit(2, 10).build();
        String expected = "LogicalSort(offset=[2], fetch=[10])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalSort(offset=[2], fetch=[10])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testSortLimit() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).sortLimit(-1, 10, new RexNode[]{builder.desc((RexNode)builder.field("DEPTNO"))}).build();
        String expected = "LogicalSort(sort0=[$7], dir0=[DESC], fetch=[10])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalSort(sort0=[$7], dir0=[DESC], fetch=[10])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testSortLimit0() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).sortLimit(-1, 0, new RexNode[]{builder.desc((RexNode)builder.field("DEPTNO"))}).build();
        String expected = "LogicalValues(tuples=[[]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalValues(tuples=[[]])\n"));
    }

    @Test
    public void testSortOverProjectSort() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        builder.scan(new String[]{"EMP"}).sort(new int[]{0}).project(new RexNode[]{builder.field(1)}).limit(0, 1).build();
        RelNode root = builder.scan(new String[]{"EMP"}).sort(new int[]{0}).project((Iterable)Lists.newArrayList((Object[])new RexInputRef[]{builder.field(1)}), (Iterable)Lists.newArrayList((Object[])new String[]{"F1"})).limit(0, 1).project(new RexNode[]{builder.field("F1")}).build();
        String expected = "LogicalProject(F1=[$1])\n  LogicalSort(sort0=[$0], dir0=[ASC], fetch=[1])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree(expected));
    }

    @Test
    public void testSortThenLimit() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).sort(new RexNode[]{builder.desc((RexNode)builder.field("DEPTNO"))}).limit(-1, 10).build();
        String expected = "LogicalSort(sort0=[$7], dir0=[DESC], fetch=[10])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalSort(sort0=[$7], dir0=[DESC], fetch=[10])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
        RelNode root2 = builder.scan(new String[]{"EMP"}).sortLimit(-1, 10, new RexNode[]{builder.desc((RexNode)builder.field("DEPTNO"))}).build();
        Assert.assertThat((Object)root2, Matchers.hasTree("LogicalSort(sort0=[$7], dir0=[DESC], fetch=[10])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testSortExpThenLimit() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"DEPT"}).sort(new RexNode[]{builder.desc(builder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)1)}))}).limit(3, 10).build();
        String expected = "LogicalProject(DEPTNO=[$0], DNAME=[$1], LOC=[$2])\n  LogicalSort(sort0=[$3], dir0=[DESC], offset=[3], fetch=[10])\n    LogicalProject(DEPTNO=[$0], DNAME=[$1], LOC=[$2], $f3=[+($0, 1)])\n      LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalProject(DEPTNO=[$0], DNAME=[$1], LOC=[$2])\n  LogicalSort(sort0=[$3], dir0=[DESC], offset=[3], fetch=[10])\n    LogicalProject(DEPTNO=[$0], DNAME=[$1], LOC=[$2], $f3=[+($0, 1)])\n      LogicalTableScan(table=[[scott, DEPT]])\n"));
        RelNode root2 = builder.scan(new String[]{"DEPT"}).sortLimit(3, 10, new RexNode[]{builder.desc(builder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{builder.field("DEPTNO"), builder.literal((Object)1)}))}).build();
        Assert.assertThat((Object)root2, Matchers.hasTree("LogicalProject(DEPTNO=[$0], DNAME=[$1], LOC=[$2])\n  LogicalSort(sort0=[$3], dir0=[DESC], offset=[3], fetch=[10])\n    LogicalProject(DEPTNO=[$0], DNAME=[$1], LOC=[$2], $f3=[+($0, 1)])\n      LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testRunValues() throws Exception {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.values(new String[]{"a", "b"}, new Object[]{true, 1, false, -50}).build();
        try (PreparedStatement preparedStatement = RelRunners.run((RelNode)root);){
            String s = CalciteAssert.toString(preparedStatement.executeQuery());
            String result = "a=true; b=1\na=false; b=-50\n";
            Assert.assertThat((Object)s, (Matcher)CoreMatchers.is((Object)"a=true; b=1\na=false; b=-50\n"));
        }
    }

    @Test
    public void testRun() throws Exception {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.equals((RexNode)builder.field("DEPTNO"), builder.literal((Object)20))}).build();
        try (PreparedStatement preparedStatement = RelRunners.run((RelNode)root);){
            String s = CalciteAssert.toString(preparedStatement.executeQuery());
            String result = "EMPNO=7369; ENAME=SMITH; JOB=CLERK; MGR=7902; HIREDATE=1980-12-17; SAL=800.00; COMM=null; DEPTNO=20\nEMPNO=7566; ENAME=JONES; JOB=MANAGER; MGR=7839; HIREDATE=1981-02-04; SAL=2975.00; COMM=null; DEPTNO=20\nEMPNO=7788; ENAME=SCOTT; JOB=ANALYST; MGR=7566; HIREDATE=1987-04-19; SAL=3000.00; COMM=null; DEPTNO=20\nEMPNO=7876; ENAME=ADAMS; JOB=CLERK; MGR=7788; HIREDATE=1987-05-23; SAL=1100.00; COMM=null; DEPTNO=20\nEMPNO=7902; ENAME=FORD; JOB=ANALYST; MGR=7566; HIREDATE=1981-12-03; SAL=3000.00; COMM=null; DEPTNO=20\n";
            Assert.assertThat((Object)s, (Matcher)CoreMatchers.is((Object)"EMPNO=7369; ENAME=SMITH; JOB=CLERK; MGR=7902; HIREDATE=1980-12-17; SAL=800.00; COMM=null; DEPTNO=20\nEMPNO=7566; ENAME=JONES; JOB=MANAGER; MGR=7839; HIREDATE=1981-02-04; SAL=2975.00; COMM=null; DEPTNO=20\nEMPNO=7788; ENAME=SCOTT; JOB=ANALYST; MGR=7566; HIREDATE=1987-04-19; SAL=3000.00; COMM=null; DEPTNO=20\nEMPNO=7876; ENAME=ADAMS; JOB=CLERK; MGR=7788; HIREDATE=1987-05-23; SAL=1100.00; COMM=null; DEPTNO=20\nEMPNO=7902; ENAME=FORD; JOB=ANALYST; MGR=7566; HIREDATE=1981-12-03; SAL=3000.00; COMM=null; DEPTNO=20\n"));
        }
    }

    @Test
    public void testTypeInferenceValidation() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RexNode arg0 = builder.literal((Object)0);
        RexNode arg1 = builder.literal((Object)"xyz");
        try {
            builder.call((SqlOperator)SqlStdOperatorTable.PLUS, (Iterable)Lists.newArrayList((Object[])new RexNode[]{arg0, arg1}));
            Assert.fail((String)"Invalid combination of parameter types");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"cannot derive type"));
        }
        try {
            builder.call((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{arg0, arg1});
            Assert.fail((String)"Invalid combination of parameter types");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"cannot derive type"));
        }
    }

    @Test
    public void testMatchRecognize() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build()).scan(new String[]{"EMP"});
        RelDataTypeFactory typeFactory = builder.getTypeFactory();
        RelDataType intType = typeFactory.createSqlType(SqlTypeName.INTEGER);
        RexNode pattern = builder.patternConcat(new RexNode[]{builder.literal((Object)"STRT"), builder.patternQuantify(new RexNode[]{builder.literal((Object)"DOWN"), builder.literal((Object)1), builder.literal((Object)-1), builder.literal((Object)false)}), builder.patternQuantify(new RexNode[]{builder.literal((Object)"UP"), builder.literal((Object)1), builder.literal((Object)-1), builder.literal((Object)false)})});
        ImmutableMap.Builder pdBuilder = new ImmutableMap.Builder();
        RexNode downDefinition = builder.call((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.PREV, new RexNode[]{builder.patternField("DOWN", intType, 3), builder.literal((Object)0)}), builder.call((SqlOperator)SqlStdOperatorTable.PREV, new RexNode[]{builder.patternField("DOWN", intType, 3), builder.literal((Object)1)})});
        pdBuilder.put((Object)"DOWN", (Object)downDefinition);
        RexNode upDefinition = builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.PREV, new RexNode[]{builder.patternField("UP", intType, 3), builder.literal((Object)0)}), builder.call((SqlOperator)SqlStdOperatorTable.PREV, new RexNode[]{builder.patternField("UP", intType, 3), builder.literal((Object)1)})});
        pdBuilder.put((Object)"UP", (Object)upDefinition);
        ImmutableList.Builder measuresBuilder = new ImmutableList.Builder();
        measuresBuilder.add((Object)builder.alias(builder.patternField("STRT", intType, 3), "start_nw"));
        measuresBuilder.add((Object)builder.alias(builder.call((SqlOperator)SqlStdOperatorTable.LAST, new RexNode[]{builder.patternField("DOWN", intType, 3), builder.literal((Object)0)}), "bottom_nw"));
        RexLiteral after = builder.getRexBuilder().makeFlag((Enum)SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW);
        ImmutableList.Builder partitionKeysBuilder = new ImmutableList.Builder();
        partitionKeysBuilder.add((Object)builder.field("DEPTNO"));
        ImmutableList.Builder orderKeysBuilder = new ImmutableList.Builder();
        orderKeysBuilder.add((Object)builder.field("EMPNO"));
        RexNode interval = builder.literal((Object)"INTERVAL '5' SECOND");
        ImmutableMap subsets = ImmutableMap.of();
        RelNode root = builder.match(pattern, false, false, (Map)pdBuilder.build(), (Iterable)measuresBuilder.build(), (RexNode)after, (Map)subsets, false, (Iterable)partitionKeysBuilder.build(), (Iterable)orderKeysBuilder.build(), interval).build();
        String expected = "LogicalMatch(partition=[[$7]], order=[[0]], outputFields=[[$7, 'start_nw', 'bottom_nw']], allRows=[false], after=[FLAG(SKIP TO NEXT ROW)], pattern=[(('STRT', PATTERN_QUANTIFIER('DOWN', 1, -1, false)), PATTERN_QUANTIFIER('UP', 1, -1, false))], isStrictStarts=[false], isStrictEnds=[false], interval=['INTERVAL ''5'' SECOND'], subsets=[[]], patternDefinitions=[[<(PREV(DOWN.$3, 0), PREV(DOWN.$3, 1)), >(PREV(UP.$3, 0), PREV(UP.$3, 1))]], inputFields=[[EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO]])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalMatch(partition=[[$7]], order=[[0]], outputFields=[[$7, 'start_nw', 'bottom_nw']], allRows=[false], after=[FLAG(SKIP TO NEXT ROW)], pattern=[(('STRT', PATTERN_QUANTIFIER('DOWN', 1, -1, false)), PATTERN_QUANTIFIER('UP', 1, -1, false))], isStrictStarts=[false], isStrictEnds=[false], interval=['INTERVAL ''5'' SECOND'], subsets=[[]], patternDefinitions=[[<(PREV(DOWN.$3, 0), PREV(DOWN.$3, 1)), >(PREV(UP.$3, 0), PREV(UP.$3, 1))]], inputFields=[[EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, DEPTNO]])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testFilterCastAny() {
        RelBuilder builder = RelBuilder.create((FrameworkConfig)RelBuilderTest.config().build());
        RelDataType anyType = builder.getTypeFactory().createSqlType(SqlTypeName.ANY);
        RelNode root = builder.scan(new String[]{"EMP"}).filter(new RexNode[]{builder.cast((RexNode)builder.getRexBuilder().makeInputRef(anyType, 0), SqlTypeName.BOOLEAN)}).build();
        String expected = "LogicalFilter(condition=[CAST($0):BOOLEAN NOT NULL])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)root, Matchers.hasTree("LogicalFilter(condition=[CAST($0):BOOLEAN NOT NULL])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }
}

