/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.util.Calendar;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.hive.druid.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.hive.druid.org.apache.calcite.rel.rules.DateRangeRules;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.test.RexImplicationCheckerTest;
import org.apache.hive.druid.org.apache.calcite.util.TimestampString;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;

public class DruidDateRangeRulesTest {
    @Test
    public void testExtractYearAndMonthFromDateColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.eq(f.exYear, (RexNode)f.literal(2014)), f.eq(f.exMonth, (RexNode)f.literal(6))), (Matcher<String>)Is.is((Object)"[2014-06-01T00:00:00.000Z/2014-07-01T00:00:00.000Z]"));
    }

    @Test
    public void testExtractYearAndDayFromDateColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.eq(f.exYear, (RexNode)f.literal(2010)), f.eq(f.exDay, (RexNode)f.literal(31))), (Matcher<String>)Is.is((Object)"[2010-01-31T00:00:00.000Z/2010-02-01T00:00:00.000Z, 2010-03-31T00:00:00.000Z/2010-04-01T00:00:00.000Z, 2010-05-31T00:00:00.000Z/2010-06-01T00:00:00.000Z, 2010-07-31T00:00:00.000Z/2010-08-01T00:00:00.000Z, 2010-08-31T00:00:00.000Z/2010-09-01T00:00:00.000Z, 2010-10-31T00:00:00.000Z/2010-11-01T00:00:00.000Z, 2010-12-31T00:00:00.000Z/2011-01-01T00:00:00.000Z]"));
    }

    @Test
    public void testExtractYearMonthDayFromDateColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.gt(f.exYear, (RexNode)f.literal(2010)), f.lt(f.exYear, (RexNode)f.literal(2020)), f.eq(f.exMonth, (RexNode)f.literal(2)), f.eq(f.exDay, (RexNode)f.literal(29))), (Matcher<String>)Is.is((Object)"[2012-02-29T00:00:00.000Z/2012-03-01T00:00:00.000Z, 2016-02-29T00:00:00.000Z/2016-03-01T00:00:00.000Z]"));
    }

    @Test
    public void testExtractYearMonthDayFromTimestampColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(f.gt(f.exYear, (RexNode)f.literal(2010)), f.lt(f.exYear, (RexNode)f.literal(2020)), f.eq(f.exMonth, (RexNode)f.literal(2)), f.eq(f.exDay, (RexNode)f.literal(29))), (Matcher<String>)Is.is((Object)"[2012-02-29T00:00:00.000Z/2012-03-01T00:00:00.000Z, 2016-02-29T00:00:00.000Z/2016-03-01T00:00:00.000Z]"));
    }

    @Test
    public void testFilterWithCast() {
        Fixture2 f = new Fixture2();
        Calendar c = Util.calendar();
        c.clear();
        c.set(2010, 0, 1);
        TimestampString from = TimestampString.fromCalendarFields((Calendar)c);
        c.clear();
        c.set(2011, 0, 1);
        TimestampString to = TimestampString.fromCalendarFields((Calendar)c);
        this.checkDateRangeNoSimplify(f, f.and(f.ge(f.d, f.cast(f.timestampDataType, f.timestampLiteral(from))), f.lt(f.d, f.cast(f.timestampDataType, f.timestampLiteral(to)))), (Matcher<String>)Is.is((Object)"[2010-01-01T00:00:00.000Z/2011-01-01T00:00:00.000Z]"));
    }

    private void checkDateRangeNoSimplify(RexImplicationCheckerTest.Fixture f, RexNode e, Matcher<String> intervalMatcher) {
        e = DateRangeRules.replaceTimeUnits((RexBuilder)f.rexBuilder, (RexNode)e, (String)"UTC");
        List intervals = DruidDateTimeUtils.createInterval((RexNode)e, (String)"UTC");
        Assert.assertThat((Object)intervals, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)intervals.toString(), intervalMatcher);
    }

    private void checkDateRange(RexImplicationCheckerTest.Fixture f, RexNode e, Matcher<String> intervalMatcher) {
        RexNode e2 = f.simplify.simplify(e = DateRangeRules.replaceTimeUnits((RexBuilder)f.rexBuilder, (RexNode)e, (String)"UTC"));
        List intervals = DruidDateTimeUtils.createInterval((RexNode)e2, (String)"UTC");
        if (intervals == null) {
            throw new AssertionError((Object)"null interval");
        }
        Assert.assertThat((Object)intervals.toString(), intervalMatcher);
    }

    private static class Fixture2
    extends RexImplicationCheckerTest.Fixture {
        private final RexNode exYear;
        private final RexNode exMonth;
        private final RexNode exDay;

        Fixture2() {
            this.exYear = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.YEAR), (Object)this.ts));
            this.exMonth = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH), (Object)this.ts));
            this.exDay = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.DAY), (Object)this.ts));
        }
    }
}

