/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.resolver.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hive.druid.io.netty.channel.socket.InternetProtocolFamily;
import org.apache.hive.druid.io.netty.resolver.dns.PreferredAddressTypeComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PreferredAddressTypeComparatorTest {
    @Test
    public void testIpv4() throws UnknownHostException {
        InetAddress ipv4Address1 = InetAddress.getByName("10.0.0.1");
        InetAddress ipv4Address2 = InetAddress.getByName("10.0.0.2");
        InetAddress ipv4Address3 = InetAddress.getByName("10.0.0.3");
        InetAddress ipv6Address1 = InetAddress.getByName("::1");
        InetAddress ipv6Address2 = InetAddress.getByName("::2");
        InetAddress ipv6Address3 = InetAddress.getByName("::3");
        PreferredAddressTypeComparator ipv4 = PreferredAddressTypeComparator.comparator((InternetProtocolFamily)InternetProtocolFamily.IPv4);
        ArrayList addressList = new ArrayList();
        Collections.addAll(addressList, ipv4Address1, ipv4Address2, ipv6Address1, ipv6Address2, ipv4Address3, ipv6Address3);
        Collections.sort(addressList, ipv4);
        Assertions.assertEquals(Arrays.asList(ipv4Address1, ipv4Address2, ipv4Address3, ipv6Address1, ipv6Address2, ipv6Address3), addressList);
    }

    @Test
    public void testIpv6() throws UnknownHostException {
        InetAddress ipv4Address1 = InetAddress.getByName("10.0.0.1");
        InetAddress ipv4Address2 = InetAddress.getByName("10.0.0.2");
        InetAddress ipv4Address3 = InetAddress.getByName("10.0.0.3");
        InetAddress ipv6Address1 = InetAddress.getByName("::1");
        InetAddress ipv6Address2 = InetAddress.getByName("::2");
        InetAddress ipv6Address3 = InetAddress.getByName("::3");
        PreferredAddressTypeComparator ipv4 = PreferredAddressTypeComparator.comparator((InternetProtocolFamily)InternetProtocolFamily.IPv6);
        ArrayList addressList = new ArrayList();
        Collections.addAll(addressList, ipv4Address1, ipv4Address2, ipv6Address1, ipv6Address2, ipv4Address3, ipv6Address3);
        Collections.sort(addressList, ipv4);
        Assertions.assertEquals(Arrays.asList(ipv6Address1, ipv6Address2, ipv6Address3, ipv4Address1, ipv4Address2, ipv4Address3), addressList);
    }
}

