/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.socksx.v5;

import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5ClientEncoder;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5Message;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5ServerEncoder;

final class Socks5CommonTestUtils {
    private Socks5CommonTestUtils() {
    }

    public static void writeFromClientToServer(EmbeddedChannel embedder, Socks5Message msg) {
        embedder.writeInbound(new Object[]{Socks5CommonTestUtils.encodeClient(msg)});
    }

    public static void writeFromServerToClient(EmbeddedChannel embedder, Socks5Message msg) {
        embedder.writeInbound(new Object[]{Socks5CommonTestUtils.encodeServer(msg)});
    }

    public static ByteBuf encodeClient(Socks5Message msg) {
        EmbeddedChannel out = new EmbeddedChannel(new ChannelHandler[]{Socks5ClientEncoder.DEFAULT});
        out.writeOutbound(new Object[]{msg});
        ByteBuf encoded = (ByteBuf)out.readOutbound();
        out.finish();
        return encoded;
    }

    public static ByteBuf encodeServer(Socks5Message msg) {
        EmbeddedChannel out = new EmbeddedChannel(new ChannelHandler[]{Socks5ServerEncoder.DEFAULT});
        out.writeOutbound(new Object[]{msg});
        ByteBuf encoded = (ByteBuf)out.readOutbound();
        out.finish();
        return encoded;
    }
}

