/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.socksx.v5;

import java.net.IDN;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.DefaultSocks5CommandRequest;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5AddressType;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5CommandRequest;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5CommandRequestDecoder;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5CommandType;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5CommonTestUtils;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5Message;
import org.apache.hive.druid.io.netty.util.NetUtil;
import org.apache.hive.druid.io.netty.util.internal.SocketUtils;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLogger;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLoggerFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Socks5CommandRequestDecoderTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Socks5CommandRequestDecoderTest.class);

    private static void test(Socks5CommandType type, Socks5AddressType dstAddrType, String dstAddr, int dstPort) {
        logger.debug("Testing type: " + type + " dstAddrType: " + dstAddrType + " dstAddr: " + dstAddr + " dstPort: " + dstPort);
        DefaultSocks5CommandRequest msg = new DefaultSocks5CommandRequest(type, dstAddrType, dstAddr, dstPort);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new Socks5CommandRequestDecoder()});
        Socks5CommonTestUtils.writeFromClientToServer(embedder, (Socks5Message)msg);
        msg = (Socks5CommandRequest)embedder.readInbound();
        Assertions.assertSame((Object)msg.type(), (Object)type);
        Assertions.assertSame((Object)msg.dstAddrType(), (Object)dstAddrType);
        Assertions.assertEquals((Object)msg.dstAddr(), (Object)IDN.toASCII(dstAddr));
        Assertions.assertEquals((int)msg.dstPort(), (int)dstPort);
        Assertions.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testCmdRequestDecoderIPv4() {
        String[] hosts = new String[]{"127.0.0.1"};
        int[] ports = new int[]{1, 32769, 65535};
        for (Socks5CommandType cmdType : Arrays.asList(Socks5CommandType.BIND, Socks5CommandType.CONNECT, Socks5CommandType.UDP_ASSOCIATE)) {
            for (String host : hosts) {
                for (int port : ports) {
                    Socks5CommandRequestDecoderTest.test(cmdType, Socks5AddressType.IPv4, host, port);
                }
            }
        }
    }

    @Test
    public void testCmdRequestDecoderIPv6() throws UnknownHostException {
        String[] hosts = new String[]{NetUtil.bytesToIpAddress((byte[])SocketUtils.addressByName((String)"::1").getAddress())};
        int[] ports = new int[]{1, 32769, 65535};
        for (Socks5CommandType cmdType : Arrays.asList(Socks5CommandType.BIND, Socks5CommandType.CONNECT, Socks5CommandType.UDP_ASSOCIATE)) {
            for (String host : hosts) {
                for (int port : ports) {
                    Socks5CommandRequestDecoderTest.test(cmdType, Socks5AddressType.IPv6, host, port);
                }
            }
        }
    }

    @Test
    public void testCmdRequestDecoderDomain() {
        String[] hosts = new String[]{"google.com", "\u0645\u062b\u0627\u0644.\u0625\u062e\u062a\u0628\u0627\u0631", "\u03c0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1.\u03b4\u03bf\u03ba\u03b9\u03bc\u03ae", "\u0645\u062b\u0627\u0644.\u0622\u0632\u0645\u0627\u06cc\u0634\u06cc", "\u043f\u0440\u0438\u043c\u0435\u0440.\u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435", "\u05d1\u05f2\u05b7\u05e9\u05e4\u05bc\u05d9\u05dc.\u05d8\u05e2\u05e1\u05d8", "\u4f8b\u5b50.\u6d4b\u8bd5", "\u4f8b\u5b50.\u6e2c\u8a66", "\u0909\u0926\u093e\u0939\u0930\u0923.\u092a\u0930\u0940\u0915\u094d\u0937\u093e", "\u4f8b\u3048.\u30c6\u30b9\u30c8", "\uc2e4\ub840.\ud14c\uc2a4\ud2b8", "\u0b89\u0ba4\u0bbe\u0bb0\u0ba3\u0bae\u0bcd.\u0baa\u0bb0\u0bbf\u0b9f\u0bcd\u0b9a\u0bc8"};
        int[] ports = new int[]{1, 32769, 65535};
        for (Socks5CommandType cmdType : Arrays.asList(Socks5CommandType.BIND, Socks5CommandType.CONNECT, Socks5CommandType.UDP_ASSOCIATE)) {
            for (String host : hosts) {
                for (int port : ports) {
                    Socks5CommandRequestDecoderTest.test(cmdType, Socks5AddressType.DOMAIN, host, port);
                }
            }
        }
    }
}

