/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.mqtt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.io.netty.handler.codec.mqtt.MqttProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MqttPropertiesTest {
    private MqttProperties createSampleProperties() {
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(10)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(20)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.CONTENT_TYPE.value(), "text/plain"));
        props.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("isSecret", "true"));
        props.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("tag", "firstTag"));
        props.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("tag", "secondTag"));
        return props;
    }

    @Test
    public void testGetProperty() {
        MqttProperties props = this.createSampleProperties();
        Assertions.assertEquals((Object)"text/plain", (Object)((MqttProperties.StringProperty)props.getProperty((int)MqttProperties.MqttPropertyType.CONTENT_TYPE.value())).value);
        Assertions.assertEquals((int)10, (int)((Integer)((MqttProperties.IntegerProperty)props.getProperty((int)MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value())).value));
        ArrayList<MqttProperties.StringPair> expectedUserProps = new ArrayList<MqttProperties.StringPair>();
        expectedUserProps.add(new MqttProperties.StringPair("isSecret", "true"));
        expectedUserProps.add(new MqttProperties.StringPair("tag", "firstTag"));
        expectedUserProps.add(new MqttProperties.StringPair("tag", "secondTag"));
        List actualUserProps = (List)((MqttProperties.UserProperties)props.getProperty((int)MqttProperties.MqttPropertyType.USER_PROPERTY.value())).value;
        Assertions.assertEquals(expectedUserProps, (Object)actualUserProps);
    }

    @Test
    public void testGetProperties() {
        MqttProperties props = this.createSampleProperties();
        Assertions.assertEquals(Collections.singletonList(new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.CONTENT_TYPE.value(), "text/plain")), (Object)props.getProperties(MqttProperties.MqttPropertyType.CONTENT_TYPE.value()));
        ArrayList<MqttProperties.IntegerProperty> expectedSubscriptionIds = new ArrayList<MqttProperties.IntegerProperty>();
        expectedSubscriptionIds.add(new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(10)));
        expectedSubscriptionIds.add(new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(20)));
        Assertions.assertEquals(expectedSubscriptionIds, (Object)props.getProperties(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value()));
        ArrayList<MqttProperties.UserProperty> expectedUserProps = new ArrayList<MqttProperties.UserProperty>();
        expectedUserProps.add(new MqttProperties.UserProperty("isSecret", "true"));
        expectedUserProps.add(new MqttProperties.UserProperty("tag", "firstTag"));
        expectedUserProps.add(new MqttProperties.UserProperty("tag", "secondTag"));
        List actualUserProps = props.getProperties(MqttProperties.MqttPropertyType.USER_PROPERTY.value());
        Assertions.assertEquals(expectedUserProps, (Object)actualUserProps);
    }

    @Test
    public void testListAll() {
        MqttProperties props = this.createSampleProperties();
        ArrayList<Object> expectedProperties = new ArrayList<Object>();
        expectedProperties.add(new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        expectedProperties.add(new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.CONTENT_TYPE.value(), "text/plain"));
        expectedProperties.add(new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(10)));
        expectedProperties.add(new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(20)));
        MqttProperties.UserProperties expectedUserProperties = new MqttProperties.UserProperties();
        expectedUserProperties.add(new MqttProperties.StringPair("isSecret", "true"));
        expectedUserProperties.add(new MqttProperties.StringPair("tag", "firstTag"));
        expectedUserProperties.add(new MqttProperties.StringPair("tag", "secondTag"));
        expectedProperties.add(expectedUserProperties);
        Assertions.assertEquals(expectedProperties, (Object)props.listAll());
    }
}

