/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2HeadersTest;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Headers;
import org.apache.hive.druid.io.netty.handler.codec.http2.ReadOnlyHttp2Headers;
import org.apache.hive.druid.io.netty.util.AsciiString;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ReadOnlyHttp2HeadersTest {
    @Test
    public void notKeyValuePairThrows() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])new AsciiString[]{null});
            }
        });
    }

    @Test
    public void nullTrailersNotAllowed() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])null);
            }
        });
    }

    @Test
    public void nullHeaderNameNotChecked() {
        ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])new AsciiString[]{null, null});
    }

    @Test
    public void nullHeaderNameValidated() {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyHttp2Headers.trailers((boolean)true, (AsciiString[])new AsciiString[]{null, new AsciiString((CharSequence)"foo")});
            }
        });
    }

    @Test
    public void pseudoHeaderNotAllowedAfterNonPseudoHeaders() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyHttp2Headers.trailers((boolean)true, (AsciiString[])new AsciiString[]{new AsciiString((CharSequence)":scheme"), new AsciiString((CharSequence)"foo"), new AsciiString((CharSequence)"othername"), new AsciiString((CharSequence)"goo"), new AsciiString((CharSequence)":path"), new AsciiString((CharSequence)"val")});
            }
        });
    }

    @Test
    public void nullValuesAreNotAllowed() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyHttp2Headers.trailers((boolean)true, (AsciiString[])new AsciiString[]{new AsciiString((CharSequence)"foo"), null});
            }
        });
    }

    @Test
    public void emptyHeaderNameAllowed() {
        ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])new AsciiString[]{AsciiString.EMPTY_STRING, new AsciiString((CharSequence)"foo")});
    }

    @Test
    public void testPseudoHeadersMustComeFirstWhenIteratingServer() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newServerHeaders();
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst((Http2Headers)headers);
    }

    @Test
    public void testPseudoHeadersMustComeFirstWhenIteratingClient() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newClientHeaders();
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst((Http2Headers)headers);
    }

    @Test
    public void testIteratorReadOnlyClient() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyHttp2HeadersTest.testIteratorReadOnly((Http2Headers)ReadOnlyHttp2HeadersTest.newClientHeaders());
            }
        });
    }

    @Test
    public void testIteratorReadOnlyServer() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyHttp2HeadersTest.testIteratorReadOnly((Http2Headers)ReadOnlyHttp2HeadersTest.newServerHeaders());
            }
        });
    }

    @Test
    public void testIteratorReadOnlyTrailers() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyHttp2HeadersTest.testIteratorReadOnly((Http2Headers)ReadOnlyHttp2HeadersTest.newTrailers());
            }
        });
    }

    @Test
    public void testIteratorEntryReadOnlyClient() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyHttp2HeadersTest.testIteratorEntryReadOnly((Http2Headers)ReadOnlyHttp2HeadersTest.newClientHeaders());
            }
        });
    }

    @Test
    public void testIteratorEntryReadOnlyServer() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyHttp2HeadersTest.testIteratorEntryReadOnly((Http2Headers)ReadOnlyHttp2HeadersTest.newServerHeaders());
            }
        });
    }

    @Test
    public void testIteratorEntryReadOnlyTrailers() {
        Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

            public void execute() {
                ReadOnlyHttp2HeadersTest.testIteratorEntryReadOnly((Http2Headers)ReadOnlyHttp2HeadersTest.newTrailers());
            }
        });
    }

    @Test
    public void testSize() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newTrailers();
        Assertions.assertEquals((int)(ReadOnlyHttp2HeadersTest.otherHeaders().length / 2), (int)headers.size());
    }

    @Test
    public void testIsNotEmpty() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newTrailers();
        Assertions.assertFalse((boolean)headers.isEmpty());
    }

    @Test
    public void testIsEmpty() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])new AsciiString[0]);
        Assertions.assertTrue((boolean)headers.isEmpty());
    }

    @Test
    public void testContainsName() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newClientHeaders();
        Assertions.assertTrue((boolean)headers.contains((Object)"Name1"));
        Assertions.assertTrue((boolean)headers.contains((Object)Http2Headers.PseudoHeaderName.PATH.value()));
        Assertions.assertFalse((boolean)headers.contains((Object)Http2Headers.PseudoHeaderName.STATUS.value()));
        Assertions.assertFalse((boolean)headers.contains((Object)"a missing header"));
    }

    @Test
    public void testContainsNameAndValue() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newClientHeaders();
        Assertions.assertTrue((boolean)headers.contains((Object)"Name1", (Object)"value1"));
        Assertions.assertFalse((boolean)headers.contains((Object)"Name1", (Object)"Value1"));
        Assertions.assertTrue((boolean)headers.contains((CharSequence)"name2", (CharSequence)"Value2", true));
        Assertions.assertFalse((boolean)headers.contains((CharSequence)"name2", (CharSequence)"Value2", false));
        Assertions.assertTrue((boolean)headers.contains((Object)Http2Headers.PseudoHeaderName.PATH.value(), (Object)"/foo"));
        Assertions.assertFalse((boolean)headers.contains((Object)Http2Headers.PseudoHeaderName.STATUS.value(), (Object)"200"));
        Assertions.assertFalse((boolean)headers.contains((Object)"a missing header", (Object)"a missing value"));
    }

    @Test
    public void testGet() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newClientHeaders();
        Assertions.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"value1", (CharSequence)((CharSequence)headers.get((Object)"Name1"))));
        Assertions.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"/foo", (CharSequence)((CharSequence)headers.get((Object)Http2Headers.PseudoHeaderName.PATH.value()))));
        Assertions.assertNull((Object)headers.get((Object)Http2Headers.PseudoHeaderName.STATUS.value()));
        Assertions.assertNull((Object)headers.get((Object)"a missing header"));
    }

    @Test
    public void testClientOtherValueIterator() {
        ReadOnlyHttp2HeadersTest.testValueIteratorSingleValue((Http2Headers)ReadOnlyHttp2HeadersTest.newClientHeaders(), "name2", "value2");
    }

    @Test
    public void testClientPsuedoValueIterator() {
        ReadOnlyHttp2HeadersTest.testValueIteratorSingleValue((Http2Headers)ReadOnlyHttp2HeadersTest.newClientHeaders(), ":path", "/foo");
    }

    @Test
    public void testServerPsuedoValueIterator() {
        ReadOnlyHttp2HeadersTest.testValueIteratorSingleValue((Http2Headers)ReadOnlyHttp2HeadersTest.newServerHeaders(), ":status", "200");
    }

    @Test
    public void testEmptyValueIterator() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newServerHeaders();
        final Iterator itr = headers.valueIterator((CharSequence)"foo");
        Assertions.assertFalse((boolean)itr.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, (Executable)new Executable(){

            public void execute() {
                itr.next();
            }
        });
    }

    @Test
    public void testIteratorMultipleValues() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2Headers.serverHeaders((boolean)false, (AsciiString)new AsciiString((CharSequence)"200"), (AsciiString[])new AsciiString[]{new AsciiString((CharSequence)"name2"), new AsciiString((CharSequence)"value1"), new AsciiString((CharSequence)"name1"), new AsciiString((CharSequence)"value2"), new AsciiString((CharSequence)"name2"), new AsciiString((CharSequence)"value3")});
        Iterator itr = headers.valueIterator((CharSequence)"name2");
        Assertions.assertTrue((boolean)itr.hasNext());
        Assertions.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"value1", (CharSequence)((CharSequence)itr.next())));
        Assertions.assertTrue((boolean)itr.hasNext());
        Assertions.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"value3", (CharSequence)((CharSequence)itr.next())));
        Assertions.assertFalse((boolean)itr.hasNext());
    }

    private static void testValueIteratorSingleValue(Http2Headers headers, CharSequence name, CharSequence value) {
        Iterator itr = headers.valueIterator(name);
        Assertions.assertTrue((boolean)itr.hasNext());
        Assertions.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)value, (CharSequence)((CharSequence)itr.next())));
        Assertions.assertFalse((boolean)itr.hasNext());
    }

    private static void testIteratorReadOnly(Http2Headers headers) {
        Iterator itr = headers.iterator();
        Assertions.assertTrue((boolean)itr.hasNext());
        itr.remove();
    }

    private static void testIteratorEntryReadOnly(Http2Headers headers) {
        Iterator itr = headers.iterator();
        Assertions.assertTrue((boolean)itr.hasNext());
        ((Map.Entry)itr.next()).setValue("foo");
    }

    private static ReadOnlyHttp2Headers newServerHeaders() {
        return ReadOnlyHttp2Headers.serverHeaders((boolean)false, (AsciiString)new AsciiString((CharSequence)"200"), (AsciiString[])ReadOnlyHttp2HeadersTest.otherHeaders());
    }

    private static ReadOnlyHttp2Headers newClientHeaders() {
        return ReadOnlyHttp2Headers.clientHeaders((boolean)false, (AsciiString)new AsciiString((CharSequence)"meth"), (AsciiString)new AsciiString((CharSequence)"/foo"), (AsciiString)new AsciiString((CharSequence)"schemer"), (AsciiString)new AsciiString((CharSequence)"respect_my_authority"), (AsciiString[])ReadOnlyHttp2HeadersTest.otherHeaders());
    }

    private static ReadOnlyHttp2Headers newTrailers() {
        return ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])ReadOnlyHttp2HeadersTest.otherHeaders());
    }

    private static AsciiString[] otherHeaders() {
        return new AsciiString[]{new AsciiString((CharSequence)"name1"), new AsciiString((CharSequence)"value1"), new AsciiString((CharSequence)"name2"), new AsciiString((CharSequence)"value2"), new AsciiString((CharSequence)"name3"), new AsciiString((CharSequence)"value3")};
    }
}

