/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.kqueue;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hive.druid.io.netty.bootstrap.ServerBootstrap;
import org.apache.hive.druid.io.netty.channel.kqueue.BsdSocket;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueSocketTestPermutation;
import org.apache.hive.druid.io.netty.channel.unix.Buffer;
import org.apache.hive.druid.io.netty.testsuite.transport.TestsuitePermutation;
import org.apache.hive.druid.io.netty.testsuite.transport.socket.AbstractSocketShutdownOutputByPeerTest;

public class KQueueDomainSocketShutdownOutputByPeerTest
extends AbstractSocketShutdownOutputByPeerTest<BsdSocket> {
    protected List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> newFactories() {
        return KQueueSocketTestPermutation.INSTANCE.serverDomainSocket();
    }

    protected SocketAddress newSocketAddress() {
        return KQueueSocketTestPermutation.newSocketAddress();
    }

    protected void shutdownOutput(BsdSocket s) throws IOException {
        s.shutdown(false, true);
    }

    protected void connect(BsdSocket s, SocketAddress address) throws IOException {
        s.connect(address);
    }

    protected void close(BsdSocket s) throws IOException {
        s.close();
    }

    protected void write(BsdSocket s, int data) throws IOException {
        ByteBuffer buf = Buffer.allocateDirectWithNativeOrder((int)4);
        buf.putInt(data);
        buf.flip();
        s.write(buf, buf.position(), buf.limit());
        Buffer.free((ByteBuffer)buf);
    }

    protected BsdSocket newSocket() {
        return BsdSocket.newSocketDomain();
    }
}

