/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.io.druid.client.CoordinatorServerView;
import org.apache.hive.druid.io.druid.client.DruidDataSource;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.server.http.DatasourcesResource;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.Action;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthTestUtils;
import org.apache.hive.druid.io.druid.server.security.AuthenticationResult;
import org.apache.hive.druid.io.druid.server.security.Authorizer;
import org.apache.hive.druid.io.druid.server.security.AuthorizerMapper;
import org.apache.hive.druid.io.druid.server.security.Resource;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatasourcesResourceTest {
    private CoordinatorServerView inventoryView;
    private DruidServer server;
    private List<DruidDataSource> listDataSources;
    private List<DataSegment> dataSegmentList;
    private HttpServletRequest request;

    @Before
    public void setUp() {
        this.request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        this.inventoryView = (CoordinatorServerView)EasyMock.createStrictMock(CoordinatorServerView.class);
        this.server = (DruidServer)EasyMock.niceMock(DruidServer.class);
        this.dataSegmentList = new ArrayList<DataSegment>();
        this.dataSegmentList.add(new DataSegment("datasource1", Intervals.of((String)"2010-01-01/P1D"), null, null, null, null, null, Integer.valueOf(9), 10L));
        this.dataSegmentList.add(new DataSegment("datasource1", Intervals.of((String)"2010-01-22/P1D"), null, null, null, null, null, Integer.valueOf(9), 20L));
        this.dataSegmentList.add(new DataSegment("datasource2", Intervals.of((String)"2010-01-01/P1D"), null, null, null, null, null, Integer.valueOf(9), 30L));
        this.listDataSources = new ArrayList<DruidDataSource>();
        this.listDataSources.add(new DruidDataSource("datasource1", new HashMap()).addSegment(this.dataSegmentList.get(0)));
        this.listDataSources.add(new DruidDataSource("datasource2", new HashMap()).addSegment(this.dataSegmentList.get(1)));
    }

    @Test
    public void testGetFullQueryableDataSources() throws Exception {
        EasyMock.expect((Object)this.server.getDataSources()).andReturn((Object)ImmutableList.of((Object)this.listDataSources.get(0), (Object)this.listDataSources.get(1))).once();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.expect((Object)this.server.getDataSources()).andReturn((Object)ImmutableList.of((Object)this.listDataSources.get(0), (Object)this.listDataSources.get(1))).once();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null)).once();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server, this.request});
        DatasourcesResource datasourcesResource = new DatasourcesResource(this.inventoryView, null, null, new AuthConfig(), AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        Response response = datasourcesResource.getQueryableDataSources("full", null, this.request);
        Set result = (Set)response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals(this.listDataSources.stream().map(DruidDataSource::toImmutableDruidDataSource).collect(Collectors.toSet()), new HashSet(result));
        response = datasourcesResource.getQueryableDataSources(null, null, this.request);
        List result1 = (List)response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)2L, (long)result1.size());
        Assert.assertTrue((boolean)result1.contains("datasource1"));
        Assert.assertTrue((boolean)result1.contains("datasource2"));
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server});
    }

    @Test
    public void testSecuredGetFullQueryableDataSources() throws Exception {
        AuthenticationResult authenticationResult = new AuthenticationResult("druid", "druid", null);
        EasyMock.expect((Object)this.server.getDataSources()).andReturn((Object)ImmutableList.of((Object)this.listDataSources.get(0), (Object)this.listDataSources.get(1))).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).once();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).once();
        EasyMock.expect((Object)this.server.getDataSources()).andReturn((Object)ImmutableList.of((Object)this.listDataSources.get(0), (Object)this.listDataSources.get(1))).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)authenticationResult).once();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).once();
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server, this.request});
        AuthorizerMapper authMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return new Authorizer(){

                    public Access authorize(AuthenticationResult authenticationResult1, Resource resource, Action action) {
                        if (resource.getName().equals("datasource1")) {
                            return new Access(true);
                        }
                        return new Access(false);
                    }
                };
            }
        };
        DatasourcesResource datasourcesResource = new DatasourcesResource(this.inventoryView, null, null, new AuthConfig(null, null), authMapper);
        Response response = datasourcesResource.getQueryableDataSources("full", null, this.request);
        Set result = (Set)response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals(this.listDataSources.subList(0, 1).stream().map(DruidDataSource::toImmutableDruidDataSource).collect(Collectors.toSet()), new HashSet(result));
        response = datasourcesResource.getQueryableDataSources(null, null, this.request);
        List result1 = (List)response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)1L, (long)result1.size());
        Assert.assertTrue((boolean)result1.contains("datasource1"));
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server, this.request});
    }

    @Test
    public void testGetSimpleQueryableDataSources() throws Exception {
        EasyMock.expect((Object)this.server.getDataSources()).andReturn(this.listDataSources).atLeastOnce();
        EasyMock.expect((Object)this.server.getDataSource("datasource1")).andReturn((Object)this.listDataSources.get(0)).atLeastOnce();
        EasyMock.expect((Object)this.server.getTier()).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.server.getDataSource("datasource2")).andReturn((Object)this.listDataSources.get(1)).atLeastOnce();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null)).atLeastOnce();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server, this.request});
        DatasourcesResource datasourcesResource = new DatasourcesResource(this.inventoryView, null, null, new AuthConfig(), AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        Response response = datasourcesResource.getQueryableDataSources(null, "simple", this.request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        List results = (List)response.getEntity();
        int index = 0;
        for (Map entry : results) {
            Assert.assertEquals((Object)this.listDataSources.get(index).getName(), (Object)entry.get("name").toString());
            Assert.assertTrue((boolean)((Map)((Map)entry.get("properties")).get("tiers")).containsKey(null));
            Assert.assertNotNull(((Map)entry.get("properties")).get("segments"));
            Assert.assertEquals((Object)1, ((Map)((Map)entry.get("properties")).get("segments")).get("count"));
            ++index;
        }
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server});
    }

    @Test
    public void testFullGetTheDataSource() throws Exception {
        DruidDataSource dataSource1 = new DruidDataSource("datasource1", new HashMap());
        EasyMock.expect((Object)this.server.getDataSource("datasource1")).andReturn((Object)dataSource1).atLeastOnce();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server});
        DatasourcesResource datasourcesResource = new DatasourcesResource(this.inventoryView, null, null, new AuthConfig(), null);
        Response response = datasourcesResource.getTheDataSource("datasource1", "full");
        ImmutableDruidDataSource result = (ImmutableDruidDataSource)response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)dataSource1.toImmutableDruidDataSource(), (Object)result);
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server});
    }

    @Test
    public void testNullGetTheDataSource() throws Exception {
        EasyMock.expect((Object)this.server.getDataSource("none")).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server});
        DatasourcesResource datasourcesResource = new DatasourcesResource(this.inventoryView, null, null, new AuthConfig(), null);
        Assert.assertEquals((long)204L, (long)datasourcesResource.getTheDataSource("none", null).getStatus());
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server});
    }

    @Test
    public void testSimpleGetTheDataSource() throws Exception {
        DruidDataSource dataSource1 = new DruidDataSource("datasource1", new HashMap());
        dataSource1.addSegment(new DataSegment("datasegment1", Intervals.of((String)"2010-01-01/P1D"), null, null, null, null, null, Integer.valueOf(9), 10L));
        EasyMock.expect((Object)this.server.getDataSource("datasource1")).andReturn((Object)dataSource1).atLeastOnce();
        EasyMock.expect((Object)this.server.getTier()).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server});
        DatasourcesResource datasourcesResource = new DatasourcesResource(this.inventoryView, null, null, new AuthConfig(), null);
        Response response = datasourcesResource.getTheDataSource("datasource1", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Map result = (Map)response.getEntity();
        Assert.assertEquals((Object)1, ((Map)((Map)result.get("tiers")).get(null)).get("segmentCount"));
        Assert.assertEquals((Object)10L, ((Map)((Map)result.get("tiers")).get(null)).get("size"));
        Assert.assertNotNull(result.get("segments"));
        Assert.assertEquals((Object)"2010-01-01T00:00:00.000Z", (Object)((Map)result.get("segments")).get("minTime").toString());
        Assert.assertEquals((Object)"2010-01-02T00:00:00.000Z", (Object)((Map)result.get("segments")).get("maxTime").toString());
        Assert.assertEquals((Object)1, ((Map)result.get("segments")).get("count"));
        Assert.assertEquals((Object)10L, ((Map)result.get("segments")).get("size"));
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server});
    }

    @Test
    public void testSimpleGetTheDataSourceManyTiers() throws Exception {
        EasyMock.expect((Object)this.server.getDataSource("datasource1")).andReturn((Object)this.listDataSources.get(0)).atLeastOnce();
        EasyMock.expect((Object)this.server.getTier()).andReturn((Object)"cold").atLeastOnce();
        DruidServer server2 = (DruidServer)EasyMock.createStrictMock(DruidServer.class);
        EasyMock.expect((Object)server2.getDataSource("datasource1")).andReturn((Object)this.listDataSources.get(1)).atLeastOnce();
        EasyMock.expect((Object)server2.getTier()).andReturn((Object)"hot").atLeastOnce();
        DruidServer server3 = (DruidServer)EasyMock.createStrictMock(DruidServer.class);
        EasyMock.expect((Object)server3.getDataSource("datasource1")).andReturn((Object)this.listDataSources.get(1)).atLeastOnce();
        EasyMock.expect((Object)server3.getTier()).andReturn((Object)"cold").atLeastOnce();
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server, (Object)server2, (Object)server3)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.server, server2, server3});
        DatasourcesResource datasourcesResource = new DatasourcesResource(this.inventoryView, null, null, new AuthConfig(), null);
        Response response = datasourcesResource.getTheDataSource("datasource1", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Map result = (Map)response.getEntity();
        Assert.assertEquals((Object)2, ((Map)((Map)result.get("tiers")).get("cold")).get("segmentCount"));
        Assert.assertEquals((Object)30L, ((Map)((Map)result.get("tiers")).get("cold")).get("size"));
        Assert.assertEquals((Object)1, ((Map)((Map)result.get("tiers")).get("hot")).get("segmentCount"));
        Assert.assertEquals((Object)20L, ((Map)((Map)result.get("tiers")).get("hot")).get("size"));
        Assert.assertNotNull(result.get("segments"));
        Assert.assertEquals((Object)"2010-01-01T00:00:00.000Z", (Object)((Map)result.get("segments")).get("minTime").toString());
        Assert.assertEquals((Object)"2010-01-23T00:00:00.000Z", (Object)((Map)result.get("segments")).get("maxTime").toString());
        Assert.assertEquals((Object)2, ((Map)result.get("segments")).get("count"));
        Assert.assertEquals((Object)30L, ((Map)result.get("segments")).get("size"));
        EasyMock.verify((Object[])new Object[]{this.inventoryView, this.server, server2, server3});
    }

    @Test
    public void testGetSegmentDataSourceIntervals() {
        this.server = new DruidServer("who", "host", null, 1234L, ServerType.HISTORICAL, "tier1", 0);
        this.server.addDataSegment(this.dataSegmentList.get(0));
        this.server.addDataSegment(this.dataSegmentList.get(1));
        this.server.addDataSegment(this.dataSegmentList.get(2));
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView});
        ArrayList<Interval> expectedIntervals = new ArrayList<Interval>();
        expectedIntervals.add(Intervals.of((String)"2010-01-22T00:00:00.000Z/2010-01-23T00:00:00.000Z"));
        expectedIntervals.add(Intervals.of((String)"2010-01-01T00:00:00.000Z/2010-01-02T00:00:00.000Z"));
        DatasourcesResource datasourcesResource = new DatasourcesResource(this.inventoryView, null, null, new AuthConfig(), null);
        Response response = datasourcesResource.getSegmentDataSourceIntervals("invalidDataSource", null, null);
        Assert.assertEquals((Object)response.getEntity(), null);
        response = datasourcesResource.getSegmentDataSourceIntervals("datasource1", null, null);
        TreeSet actualIntervals = (TreeSet)response.getEntity();
        Assert.assertEquals((long)2L, (long)actualIntervals.size());
        Assert.assertEquals(expectedIntervals.get(0), actualIntervals.first());
        Assert.assertEquals(expectedIntervals.get(1), actualIntervals.last());
        response = datasourcesResource.getSegmentDataSourceIntervals("datasource1", "simple", null);
        TreeMap results = (TreeMap)response.getEntity();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals(expectedIntervals.get(0), results.firstKey());
        Assert.assertEquals(expectedIntervals.get(1), results.lastKey());
        Assert.assertEquals((Object)1, ((Map)results.firstEntry().getValue()).get("count"));
        Assert.assertEquals((Object)1, ((Map)results.lastEntry().getValue()).get("count"));
        response = datasourcesResource.getSegmentDataSourceIntervals("datasource1", null, "full");
        results = (TreeMap)response.getEntity();
        int i = 1;
        for (Map.Entry entry : results.entrySet()) {
            Assert.assertEquals((Object)this.dataSegmentList.get(i).getInterval(), entry.getKey());
            Assert.assertEquals((Object)this.dataSegmentList.get(i), ((Map)((Map)entry.getValue()).get(this.dataSegmentList.get(i).getIdentifier())).get("metadata"));
            --i;
        }
        EasyMock.verify((Object[])new Object[]{this.inventoryView});
    }

    @Test
    public void testGetSegmentDataSourceSpecificInterval() {
        int i;
        this.server = new DruidServer("who", "host", null, 1234L, ServerType.HISTORICAL, "tier1", 0);
        this.server.addDataSegment(this.dataSegmentList.get(0));
        this.server.addDataSegment(this.dataSegmentList.get(1));
        this.server.addDataSegment(this.dataSegmentList.get(2));
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.inventoryView});
        DatasourcesResource datasourcesResource = new DatasourcesResource(this.inventoryView, null, null, new AuthConfig(), null);
        Response response = datasourcesResource.getSegmentDataSourceSpecificInterval("invalidDataSource", "2010-01-01/P1D", null, null);
        Assert.assertEquals(null, (Object)response.getEntity());
        response = datasourcesResource.getSegmentDataSourceSpecificInterval("datasource1", "2010-03-01/P1D", null, null);
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)response.getEntity());
        response = datasourcesResource.getSegmentDataSourceSpecificInterval("datasource1", "2010-01-01/P1D", null, null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.dataSegmentList.get(0).getIdentifier()), (Object)response.getEntity());
        response = datasourcesResource.getSegmentDataSourceSpecificInterval("datasource1", "2010-01-01/P1M", null, null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.dataSegmentList.get(1).getIdentifier(), (Object)this.dataSegmentList.get(0).getIdentifier()), (Object)response.getEntity());
        response = datasourcesResource.getSegmentDataSourceSpecificInterval("datasource1", "2010-01-01/P1M", "simple", null);
        HashMap results = (HashMap)response.getEntity();
        Assert.assertEquals((long)2L, (long)results.size());
        for (i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)results.containsKey(this.dataSegmentList.get(i).getInterval()));
            Assert.assertEquals((Object)1, ((Map)results.get(this.dataSegmentList.get(i).getInterval())).get("count"));
        }
        response = datasourcesResource.getSegmentDataSourceSpecificInterval("datasource1", "2010-01-01/P1M", null, "full");
        TreeMap results1 = (TreeMap)response.getEntity();
        i = 1;
        for (Map.Entry entry : results1.entrySet()) {
            Assert.assertEquals((Object)this.dataSegmentList.get(i).getInterval(), entry.getKey());
            Assert.assertEquals((Object)this.dataSegmentList.get(i), ((Map)((Map)entry.getValue()).get(this.dataSegmentList.get(i).getIdentifier())).get("metadata"));
            --i;
        }
        EasyMock.verify((Object[])new Object[]{this.inventoryView});
    }

    @Test
    public void testDeleteDataSourceSpecificInterval() throws Exception {
        String interval = "2010-01-01_P1D";
        Interval theInterval = Intervals.of((String)interval.replace("_", "/"));
        IndexingServiceClient indexingServiceClient = (IndexingServiceClient)EasyMock.createStrictMock(IndexingServiceClient.class);
        indexingServiceClient.killSegments("datasource1", theInterval);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{indexingServiceClient, this.server});
        DatasourcesResource datasourcesResource = new DatasourcesResource(this.inventoryView, null, indexingServiceClient, new AuthConfig(), null);
        Response response = datasourcesResource.deleteDataSourceSpecificInterval("datasource1", interval);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(null, (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{indexingServiceClient, this.server});
    }

    @Test
    public void testDeleteDataSource() {
        IndexingServiceClient indexingServiceClient = (IndexingServiceClient)EasyMock.createStrictMock(IndexingServiceClient.class);
        EasyMock.replay((Object[])new Object[]{indexingServiceClient, this.server});
        DatasourcesResource datasourcesResource = new DatasourcesResource(this.inventoryView, null, indexingServiceClient, new AuthConfig(), null);
        Response response = datasourcesResource.deleteDataSource("datasource", "true", "???");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        Assert.assertTrue((boolean)response.getEntity().toString().contains("java.lang.IllegalArgumentException"));
        EasyMock.verify((Object[])new Object[]{indexingServiceClient, this.server});
    }
}

