/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.server.coordinator.DiskNormalizedCostBalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class DiskNormalizedCostBalancerStrategyTest {
    private static final Interval day = Intervals.of((String)"2015-01-01T00/2015-01-01T01");

    public static List<ServerHolder> setupDummyCluster(int serverCount, int maxSegments) {
        DataSegment segment;
        int j;
        HashMap segments;
        ArrayList serverHolderList = Lists.newArrayList();
        for (int i = 0; i < serverCount; ++i) {
            LoadQueuePeonTester fromPeon = new LoadQueuePeonTester();
            segments = Maps.newHashMap();
            for (j = 0; j < maxSegments; ++j) {
                segment = DiskNormalizedCostBalancerStrategyTest.getSegment(j);
                segments.put(segment.getIdentifier(), segment);
            }
            serverHolderList.add(new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("DruidServer_Name_" + i, "localhost", null, 10000000L, ServerType.HISTORICAL, "hot", 1), 3000L, ImmutableMap.of((Object)"DUMMY", (Object)EasyMock.createMock(ImmutableDruidDataSource.class)), ImmutableMap.copyOf((Map)segments)), (LoadQueuePeon)fromPeon));
        }
        LoadQueuePeonTester fromPeon = new LoadQueuePeonTester();
        ImmutableDruidServer druidServer = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        EasyMock.expect((Object)druidServer.getName()).andReturn((Object)"BEST_SERVER").anyTimes();
        EasyMock.expect((Object)druidServer.getCurrSize()).andReturn((Object)3000L).anyTimes();
        EasyMock.expect((Object)druidServer.getMaxSize()).andReturn((Object)100000000L).anyTimes();
        EasyMock.expect((Object)druidServer.getSegment((String)EasyMock.anyObject())).andReturn(null).anyTimes();
        segments = Maps.newHashMap();
        for (j = 0; j < maxSegments; ++j) {
            segment = DiskNormalizedCostBalancerStrategyTest.getSegment(j);
            segments.put(segment.getIdentifier(), segment);
            EasyMock.expect((Object)druidServer.getSegment(segment.getIdentifier())).andReturn((Object)segment).anyTimes();
        }
        EasyMock.expect((Object)druidServer.getSegments()).andReturn((Object)segments).anyTimes();
        EasyMock.replay((Object[])new Object[]{druidServer});
        serverHolderList.add(new ServerHolder(druidServer, (LoadQueuePeon)fromPeon));
        return serverHolderList;
    }

    public static DataSegment getSegment(int index) {
        return DiskNormalizedCostBalancerStrategyTest.getSegment(index, "DUMMY", day);
    }

    public static DataSegment getSegment(int index, String dataSource, Interval interval) {
        DataSegment segment = new DataSegment(dataSource, interval, String.valueOf(index), new ConcurrentHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), null, Integer.valueOf(0), (long)index * 100L);
        return segment;
    }

    @Test
    public void testNormalizedCostBalancerMultiThreadedStrategy() throws InterruptedException {
        List<ServerHolder> serverHolderList = DiskNormalizedCostBalancerStrategyTest.setupDummyCluster(10, 20);
        DataSegment segment = DiskNormalizedCostBalancerStrategyTest.getSegment(1000);
        DiskNormalizedCostBalancerStrategy strategy = new DiskNormalizedCostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(4)));
        ServerHolder holder = strategy.findNewSegmentHomeReplicator(segment, serverHolderList);
        Assert.assertNotNull((String)"Should be able to find a place for new segment!!", (Object)holder);
        Assert.assertEquals((String)"Best Server should be BEST_SERVER", (Object)"BEST_SERVER", (Object)holder.getServer().getName());
    }

    @Test
    public void testNormalizedCostBalancerSingleThreadStrategy() throws InterruptedException {
        List<ServerHolder> serverHolderList = DiskNormalizedCostBalancerStrategyTest.setupDummyCluster(10, 20);
        DataSegment segment = DiskNormalizedCostBalancerStrategyTest.getSegment(1000);
        DiskNormalizedCostBalancerStrategy strategy = new DiskNormalizedCostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1)));
        ServerHolder holder = strategy.findNewSegmentHomeReplicator(segment, serverHolderList);
        Assert.assertNotNull((String)"Should be able to find a place for new segment!!", (Object)holder);
        Assert.assertEquals((String)"Best Server should be BEST_SERVER", (Object)"BEST_SERVER", (Object)holder.getServer().getName());
    }
}

