/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.firehose;

import java.io.IOException;
import org.apache.hive.druid.io.druid.curator.discovery.ServiceAnnouncer;
import org.apache.hive.druid.io.druid.segment.realtime.firehose.ChatHandler;
import org.apache.hive.druid.io.druid.segment.realtime.firehose.ServiceAnnouncingChatHandlerProvider;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.initialization.ServerConfig;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class ServiceAnnouncingChatHandlerProviderTest
extends EasyMockSupport {
    private static final String TEST_SERVICE_NAME = "test-service-name";
    private static final String TEST_HOST = "test-host";
    private static final int TEST_PORT = 1234;
    private ServiceAnnouncingChatHandlerProvider chatHandlerProvider;
    @Mock
    private DruidNode node;
    @Mock
    private ServiceAnnouncer serviceAnnouncer;

    @Before
    public void setUp() throws Exception {
        this.chatHandlerProvider = new ServiceAnnouncingChatHandlerProvider(this.node, this.serviceAnnouncer, new ServerConfig());
    }

    @Test
    public void testRegistrationDefault() throws IOException {
        this.testRegistrationWithAnnounce(false);
    }

    @Test
    public void testRegistrationWithAnnounce() throws IOException {
        this.testRegistrationWithAnnounce(true);
    }

    @Test
    public void testRegistrationWithoutAnnounce() throws IOException {
        TestChatHandler testChatHandler = new TestChatHandler();
        Assert.assertFalse((String)"bad initial state", (boolean)this.chatHandlerProvider.get(TEST_SERVICE_NAME).isPresent());
        this.chatHandlerProvider.register(TEST_SERVICE_NAME, (ChatHandler)testChatHandler, false);
        Assert.assertTrue((String)"chatHandler did not register", (boolean)this.chatHandlerProvider.get(TEST_SERVICE_NAME).isPresent());
        Assert.assertEquals((Object)testChatHandler, (Object)this.chatHandlerProvider.get(TEST_SERVICE_NAME).get());
        this.chatHandlerProvider.unregister(TEST_SERVICE_NAME);
        Assert.assertFalse((String)"chatHandler did not deregister", (boolean)this.chatHandlerProvider.get(TEST_SERVICE_NAME).isPresent());
    }

    private void testRegistrationWithAnnounce(boolean useThreeArgConstructor) throws IOException {
        TestChatHandler testChatHandler = new TestChatHandler();
        Capture captured = Capture.newInstance();
        EasyMock.expect((Object)this.node.getHost()).andReturn((Object)TEST_HOST);
        EasyMock.expect((Object)this.node.getPlaintextPort()).andReturn((Object)1234);
        EasyMock.expect((Object)this.node.isEnablePlaintextPort()).andReturn((Object)true);
        EasyMock.expect((Object)this.node.isEnableTlsPort()).andReturn((Object)false);
        EasyMock.expect((Object)this.node.getTlsPort()).andReturn((Object)-1);
        this.serviceAnnouncer.announce((DruidNode)EasyMock.capture((Capture)captured));
        this.replayAll();
        Assert.assertFalse((String)"bad initial state", (boolean)this.chatHandlerProvider.get(TEST_SERVICE_NAME).isPresent());
        if (useThreeArgConstructor) {
            this.chatHandlerProvider.register(TEST_SERVICE_NAME, (ChatHandler)testChatHandler, true);
        } else {
            this.chatHandlerProvider.register(TEST_SERVICE_NAME, (ChatHandler)testChatHandler);
        }
        this.verifyAll();
        DruidNode param = (DruidNode)captured.getValues().get(0);
        Assert.assertEquals((Object)TEST_SERVICE_NAME, (Object)param.getServiceName());
        Assert.assertEquals((Object)TEST_HOST, (Object)param.getHost());
        Assert.assertEquals((long)1234L, (long)param.getPlaintextPort());
        Assert.assertEquals((long)-1L, (long)param.getTlsPort());
        Assert.assertEquals(null, (Object)param.getHostAndTlsPort());
        Assert.assertTrue((String)"chatHandler did not register", (boolean)this.chatHandlerProvider.get(TEST_SERVICE_NAME).isPresent());
        Assert.assertEquals((Object)testChatHandler, (Object)this.chatHandlerProvider.get(TEST_SERVICE_NAME).get());
        captured.reset();
        this.resetAll();
        EasyMock.expect((Object)this.node.getHost()).andReturn((Object)TEST_HOST);
        EasyMock.expect((Object)this.node.getPlaintextPort()).andReturn((Object)1234);
        EasyMock.expect((Object)this.node.isEnablePlaintextPort()).andReturn((Object)true);
        EasyMock.expect((Object)this.node.getTlsPort()).andReturn((Object)-1);
        EasyMock.expect((Object)this.node.isEnableTlsPort()).andReturn((Object)false);
        this.serviceAnnouncer.unannounce((DruidNode)EasyMock.capture((Capture)captured));
        this.replayAll();
        this.chatHandlerProvider.unregister(TEST_SERVICE_NAME);
        this.verifyAll();
        param = (DruidNode)captured.getValues().get(0);
        Assert.assertEquals((Object)TEST_SERVICE_NAME, (Object)param.getServiceName());
        Assert.assertEquals((Object)TEST_HOST, (Object)param.getHost());
        Assert.assertEquals((long)1234L, (long)param.getPlaintextPort());
        Assert.assertEquals((long)-1L, (long)param.getTlsPort());
        Assert.assertEquals(null, (Object)param.getHostAndTlsPort());
        Assert.assertFalse((String)"chatHandler did not deregister", (boolean)this.chatHandlerProvider.get(TEST_SERVICE_NAME).isPresent());
    }

    private static class TestChatHandler
    implements ChatHandler {
        private TestChatHandler() {
        }
    }
}

