/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.io.druid.segment.realtime.SegmentPublisher;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.Appenderator;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorPlumber;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorTest;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorTester;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.IntervalStartVersioningPolicy;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.NoopRejectionPolicyFactory;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.RejectionPolicyFactory;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.SegmentHandoffNotifier;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.VersioningPolicy;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class AppenderatorPlumberTest {
    private final AppenderatorPlumber plumber;
    private final AppenderatorTester appenderatorTester = new AppenderatorTester(10);

    public AppenderatorPlumberTest() throws Exception {
        DataSegmentAnnouncer segmentAnnouncer = (DataSegmentAnnouncer)EasyMock.createMock(DataSegmentAnnouncer.class);
        segmentAnnouncer.announceSegment((DataSegment)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        SegmentPublisher segmentPublisher = (SegmentPublisher)EasyMock.createNiceMock(SegmentPublisher.class);
        SegmentHandoffNotifierFactory handoffNotifierFactory = (SegmentHandoffNotifierFactory)EasyMock.createNiceMock(SegmentHandoffNotifierFactory.class);
        SegmentHandoffNotifier handoffNotifier = (SegmentHandoffNotifier)EasyMock.createNiceMock(SegmentHandoffNotifier.class);
        EasyMock.expect((Object)handoffNotifierFactory.createSegmentHandoffNotifier(EasyMock.anyString())).andReturn((Object)handoffNotifier).anyTimes();
        EasyMock.expect((Object)handoffNotifier.registerSegmentHandoffCallback((SegmentDescriptor)EasyMock.anyObject(), (Executor)EasyMock.anyObject(), (Runnable)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        RealtimeTuningConfig tuningConfig = new RealtimeTuningConfig(Integer.valueOf(1), null, null, null, (VersioningPolicy)new IntervalStartVersioningPolicy(), (RejectionPolicyFactory)new NoopRejectionPolicyFactory(), null, null, null, Boolean.valueOf(true), 0, 0, Boolean.valueOf(false), null, null, null);
        this.plumber = new AppenderatorPlumber(this.appenderatorTester.getSchema(), tuningConfig, this.appenderatorTester.getMetrics(), segmentAnnouncer, segmentPublisher, handoffNotifier, this.appenderatorTester.getAppenderator());
    }

    @Test
    public void testSimpleIngestion() throws Exception {
        ConcurrentHashMap<String, String> commitMetadata = new ConcurrentHashMap<String, String>();
        Appenderator appenderator = this.appenderatorTester.getAppenderator();
        Assert.assertEquals(null, (Object)this.plumber.startJob());
        Assert.assertEquals((Object)"foo", (Object)appenderator.getDataSource());
        InputRow[] rows = new InputRow[]{AppenderatorTest.IR("2000", "foo", 1L), AppenderatorTest.IR("2000", "bar", 2L), AppenderatorTest.IR("2000", "qux", 4L)};
        commitMetadata.put("x", "1");
        Assert.assertEquals((long)1L, (long)this.plumber.add(rows[0], null));
        commitMetadata.put("x", "2");
        Assert.assertEquals((long)2L, (long)this.plumber.add(rows[1], null));
        commitMetadata.put("x", "3");
        Assert.assertEquals((long)3L, (long)this.plumber.add(rows[2], null));
        Assert.assertEquals((long)1L, (long)this.plumber.getSegmentsView().size());
        SegmentIdentifier si = this.plumber.getSegmentsView().values().toArray(new SegmentIdentifier[1])[0];
        Assert.assertEquals((long)3L, (long)appenderator.getRowCount(si));
        appenderator.clear();
        Assert.assertTrue((boolean)appenderator.getSegments().isEmpty());
        this.plumber.dropSegment(si);
        this.plumber.finishJob();
    }
}

