/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.io.druid.java.util.common.MapUtils;
import org.apache.hive.druid.io.druid.segment.AbstractSegment;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoader;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class CacheTestSegmentLoader
implements SegmentLoader {
    private final Set<DataSegment> segmentsInTrash = new HashSet<DataSegment>();

    public boolean isSegmentLoaded(DataSegment segment) throws SegmentLoadingException {
        Map loadSpec = segment.getLoadSpec();
        return new File(MapUtils.getString((Map)loadSpec, (String)"cacheDir")).exists();
    }

    public Segment getSegment(final DataSegment segment) throws SegmentLoadingException {
        return new AbstractSegment(){

            public String getIdentifier() {
                return segment.getIdentifier();
            }

            public Interval getDataInterval() {
                return segment.getInterval();
            }

            public QueryableIndex asQueryableIndex() {
                throw new UnsupportedOperationException();
            }

            public StorageAdapter asStorageAdapter() {
                throw new UnsupportedOperationException();
            }

            public void close() throws IOException {
            }
        };
    }

    public File getSegmentFiles(DataSegment segment) throws SegmentLoadingException {
        throw new UnsupportedOperationException();
    }

    public void cleanup(DataSegment segment) throws SegmentLoadingException {
        this.segmentsInTrash.add(segment);
    }

    public Set<DataSegment> getSegmentsInTrash() {
        return this.segmentsInTrash;
    }
}

