/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.timeboundary;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.io.CharSource;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.hive.druid.io.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.TestIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.SingleElementPartitionChunk;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeBoundaryQueryRunnerTest {
    private final QueryRunner runner;
    private static final QueryRunnerFactory factory = new TimeBoundaryQueryRunnerFactory(QueryRunnerTestHelper.NOOP_QUERYWATCHER);
    private static Segment segment0;
    private static Segment segment1;
    private static List<String> segmentIdentifiers;
    public static final String[] V_0112;
    public static final String[] V_0113;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.transformToConstructionFeeder(QueryRunnerTestHelper.makeQueryRunners(new TimeBoundaryQueryRunnerFactory(QueryRunnerTestHelper.NOOP_QUERYWATCHER)));
    }

    public TimeBoundaryQueryRunnerTest(QueryRunner runner) {
        this.runner = runner;
    }

    private static IncrementalIndex newIndex(String minTimeStamp) {
        return TimeBoundaryQueryRunnerTest.newIndex(minTimeStamp, 10000);
    }

    private static IncrementalIndex newIndex(String minTimeStamp, int maxRowCount) {
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)minTimeStamp).getMillis()).withQueryGranularity(Granularities.HOUR).withMetrics(TestIndex.METRIC_AGGS).build();
        return new IncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(maxRowCount).buildOnheap();
    }

    private static String makeIdentifier(IncrementalIndex index, String version) {
        return TimeBoundaryQueryRunnerTest.makeIdentifier(index.getInterval(), version);
    }

    private static String makeIdentifier(Interval interval, String version) {
        return DataSegment.makeDataSegmentIdentifier((String)"testing", (DateTime)interval.getStart(), (DateTime)interval.getEnd(), (String)version, (ShardSpec)new NoneShardSpec());
    }

    private QueryRunner getCustomRunner() throws IOException {
        CharSource v_0112 = CharSource.wrap((CharSequence)StringUtils.join((Object[])V_0112, (String)"\n"));
        CharSource v_0113 = CharSource.wrap((CharSequence)StringUtils.join((Object[])V_0113, (String)"\n"));
        IncrementalIndex index0 = TestIndex.loadIncrementalIndex(TimeBoundaryQueryRunnerTest.newIndex("2011-01-12T00:00:00.000Z"), v_0112);
        IncrementalIndex index1 = TestIndex.loadIncrementalIndex(TimeBoundaryQueryRunnerTest.newIndex("2011-01-14T00:00:00.000Z"), v_0113);
        segment0 = new IncrementalIndexSegment(index0, TimeBoundaryQueryRunnerTest.makeIdentifier(index0, "v1"));
        segment1 = new IncrementalIndexSegment(index1, TimeBoundaryQueryRunnerTest.makeIdentifier(index1, "v1"));
        VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)StringComparators.LEXICOGRAPHIC);
        timeline.add(index0.getInterval(), (Object)"v1", (PartitionChunk)new SingleElementPartitionChunk((Object)segment0));
        timeline.add(index1.getInterval(), (Object)"v1", (PartitionChunk)new SingleElementPartitionChunk((Object)segment1));
        segmentIdentifiers = Lists.newArrayList();
        for (TimelineObjectHolder holder : timeline.lookup(Intervals.of((String)"2011-01-12/2011-01-17"))) {
            segmentIdentifiers.add(TimeBoundaryQueryRunnerTest.makeIdentifier(holder.getInterval(), (String)holder.getVersion()));
        }
        return QueryRunnerTestHelper.makeFilteringQueryRunner((VersionedIntervalTimeline<String, Segment>)timeline, factory);
    }

    @Test
    public void testFilteredTimeBoundaryQuery() throws IOException {
        QueryRunner customRunner = this.getCustomRunner();
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").filters("quality", "automotive").build();
        Assert.assertTrue((boolean)timeBoundaryQuery.hasFilters());
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)customRunner.run(QueryPlus.wrap((Query)timeBoundaryQuery), context), (List)Lists.newArrayList());
        Assert.assertTrue((Iterables.size((Iterable)results) > 0 ? 1 : 0) != 0);
        TimeBoundaryResultValue val = (TimeBoundaryResultValue)((Result)results.iterator().next()).getValue();
        DateTime minTime = val.getMinTime();
        DateTime maxTime = val.getMaxTime();
        Assert.assertEquals((Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z"), (Object)minTime);
        Assert.assertEquals((Object)DateTimes.of((String)"2011-01-16T00:00:00.000Z"), (Object)maxTime);
    }

    @Test
    public void testFilteredTimeBoundaryQueryNoMatches() throws IOException {
        QueryRunner customRunner = this.getCustomRunner();
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").filters("quality", "foobar").build();
        Assert.assertTrue((boolean)timeBoundaryQuery.hasFilters());
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)customRunner.run(QueryPlus.wrap((Query)timeBoundaryQuery), context), (List)Lists.newArrayList());
        Assert.assertTrue((Iterables.size((Iterable)results) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTimeBoundary() {
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        Assert.assertFalse((boolean)timeBoundaryQuery.hasFilters());
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)timeBoundaryQuery), context), (List)Lists.newArrayList());
        TimeBoundaryResultValue val = (TimeBoundaryResultValue)((Result)results.iterator().next()).getValue();
        DateTime minTime = val.getMinTime();
        DateTime maxTime = val.getMaxTime();
        Assert.assertEquals((Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)minTime);
        Assert.assertEquals((Object)DateTimes.of((String)"2011-04-15T00:00:00.000Z"), (Object)maxTime);
    }

    @Test
    public void testTimeBoundaryMax() {
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").bound("maxTime").build();
        ConcurrentHashMap<String, ArrayList> context = new ConcurrentHashMap<String, ArrayList>();
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)timeBoundaryQuery), context), (List)Lists.newArrayList());
        TimeBoundaryResultValue val = (TimeBoundaryResultValue)((Result)results.iterator().next()).getValue();
        DateTime minTime = val.getMinTime();
        DateTime maxTime = val.getMaxTime();
        Assert.assertNull((Object)minTime);
        Assert.assertEquals((Object)DateTimes.of((String)"2011-04-15T00:00:00.000Z"), (Object)maxTime);
    }

    @Test
    public void testTimeBoundaryMin() {
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").bound("minTime").build();
        ConcurrentHashMap<String, ArrayList> context = new ConcurrentHashMap<String, ArrayList>();
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)timeBoundaryQuery), context), (List)Lists.newArrayList());
        TimeBoundaryResultValue val = (TimeBoundaryResultValue)((Result)results.iterator().next()).getValue();
        DateTime minTime = val.getMinTime();
        DateTime maxTime = val.getMaxTime();
        Assert.assertEquals((Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)minTime);
        Assert.assertNull((Object)maxTime);
    }

    @Test
    public void testMergeResults() throws Exception {
        List<Result> results = Arrays.asList(new Result(DateTimes.nowUtc(), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)"2012-01-01", (Object)"minTime", (Object)"2011-01-01"))), new Result(DateTimes.nowUtc(), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)"2012-02-01", (Object)"minTime", (Object)"2011-01-01"))));
        TimeBoundaryQuery query = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, null, null, null);
        Iterable actual = query.mergeResults(results);
        Assert.assertTrue((boolean)((TimeBoundaryResultValue)((Result)actual.iterator().next()).getValue()).getMaxTime().equals((Object)DateTimes.of((String)"2012-02-01")));
    }

    @Test
    public void testMergeResultsEmptyResults() throws Exception {
        ArrayList results = Lists.newArrayList();
        TimeBoundaryQuery query = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, null, null, null);
        Iterable actual = query.mergeResults((List)results);
        Assert.assertFalse((boolean)actual.iterator().hasNext());
    }

    static {
        V_0112 = new String[]{"2011-01-12T01:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t110000\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T02:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t120000\tpreferred\te\u0001preferred\t100.000000", "2011-01-13T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t100000\tpreferred\ta\u0001preferred\t100.000000", "2011-01-13T01:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t110000\tpreferred\tb\u0001preferred\t100.000000"};
        V_0113 = new String[]{"2011-01-14T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t100000\tpreferred\ta\u0001preferred\t94.874713", "2011-01-14T02:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t120000\tpreferred\te\u0001preferred\t110.087299", "2011-01-15T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t100000\tpreferred\ta\u0001preferred\t94.874713", "2011-01-15T01:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t110000\tpreferred\tb\u0001preferred\t103.629399", "2011-01-16T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t100000\tpreferred\ta\u0001preferred\t94.874713", "2011-01-16T01:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t110000\tpreferred\tb\u0001preferred\t103.629399", "2011-01-16T02:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t120000\tpreferred\te\u0001preferred\t110.087299", "2011-01-17T01:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t110000\tpreferred\tb\u0001preferred\t103.629399", "2011-01-17T02:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t120000\tpreferred\te\u0001preferred\t110.087299"};
    }
}

