/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.select;

import java.util.Arrays;
import java.util.Collections;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.query.CacheStrategy;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.select.PagingSpec;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.select.SelectQueryConfig;
import org.apache.hive.druid.io.druid.query.select.SelectQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.select.SelectQueryRunnerTest;
import org.junit.Assert;
import org.junit.Test;

public class SelectQueryQueryToolChestTest {
    private static final Supplier<SelectQueryConfig> configSupplier = Suppliers.ofInstance((Object)new SelectQueryConfig(Boolean.valueOf(true)));
    private static final SelectQueryQueryToolChest toolChest = new SelectQueryQueryToolChest((ObjectMapper)new DefaultObjectMapper(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator(), configSupplier);

    @Test
    public void testComputeCacheKeyWithDifferentSortOrer() throws Exception {
        SelectQuery query1 = Druids.newSelectQueryBuilder().dataSource("dummy").dimensions(Collections.singletonList("testDim")).intervals(SelectQueryRunnerTest.I_0112_0114).granularity(QueryRunnerTestHelper.allGran).pagingSpec(PagingSpec.newSpec((int)3)).descending(false).build();
        SelectQuery query2 = Druids.newSelectQueryBuilder().dataSource("dummy").dimensions(Collections.singletonList("testDim")).intervals(SelectQueryRunnerTest.I_0112_0114).granularity(QueryRunnerTestHelper.allGran).pagingSpec(PagingSpec.newSpec((int)3)).descending(true).build();
        CacheStrategy strategy1 = toolChest.getCacheStrategy(query1);
        Assert.assertNotNull((Object)strategy1);
        CacheStrategy strategy2 = toolChest.getCacheStrategy(query2);
        Assert.assertNotNull((Object)strategy2);
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
    }
}

