/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.scan;

import java.util.Arrays;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.scan.ScanQuery;
import org.apache.hive.druid.io.druid.query.spec.LegacySegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.junit.Assert;
import org.junit.Test;

public class ScanQuerySpecTest {
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();

    @Test
    public void testSerializationLegacyString() throws Exception {
        String legacy = "{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z\"]},\"filter\":null,\"columns\":[\"market\",\"quality\",\"index\"],\"limit\":3,\"context\":null}";
        String current = "{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z\"]},\"virtualColumns\":[],\"resultFormat\":\"list\",\"batchSize\":20480,\"limit\":3,\"filter\":null,\"columns\":[\"market\",\"quality\",\"index\"],\"legacy\":null,\"context\":null,\"descending\":false,\"granularity\":{\"type\":\"all\"}}";
        ScanQuery query = new ScanQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12/2011-01-14")), VirtualColumns.EMPTY, null, 0, 3L, null, Arrays.asList("market", "quality", "index"), null, null);
        String actual = jsonMapper.writeValueAsString((Object)query);
        Assert.assertEquals((Object)current, (Object)actual);
        Assert.assertEquals((Object)query, (Object)jsonMapper.readValue(actual, ScanQuery.class));
        Assert.assertEquals((Object)query, (Object)jsonMapper.readValue(legacy, ScanQuery.class));
    }
}

