/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.dimension;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.LookupDimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.hive.druid.io.druid.query.lookup.LookupReferencesManager;
import org.apache.hive.druid.io.druid.query.lookup.MapLookupExtractorFactory;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class LookupDimensionSpecTest {
    private static final Map<String, String> STRING_MAP = ImmutableMap.of((Object)"key", (Object)"value", (Object)"key2", (Object)"value2");
    private static LookupExtractor MAP_LOOKUP_EXTRACTOR = new MapLookupExtractor(STRING_MAP, true);
    private static final LookupReferencesManager LOOKUP_REF_MANAGER = (LookupReferencesManager)EasyMock.createMock(LookupReferencesManager.class);
    private final DimensionSpec lookupDimSpec = new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, null, null, null, Boolean.valueOf(true));

    @Parameters
    @Test
    public void testSerDesr(DimensionSpec lookupDimSpec) throws IOException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        InjectableValues.Std injectableValues = new InjectableValues.Std().addValue(LookupReferencesManager.class, (Object)LOOKUP_REF_MANAGER);
        String serLookup = mapper.writeValueAsString((Object)lookupDimSpec);
        Assert.assertEquals((Object)lookupDimSpec, (Object)mapper.reader(LookupDimensionSpec.class).with((InjectableValues)injectableValues).readValue(serLookup));
    }

    private Object[] parametersForTestSerDesr() {
        return new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, true, null, null, null, Boolean.valueOf(true)), new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, "Missing_value", null, null, Boolean.valueOf(true)), new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, null, null, null, Boolean.valueOf(true)), new LookupDimensionSpec("dimName", "outputName", null, false, null, "name", LOOKUP_REF_MANAGER, Boolean.valueOf(true))};
    }

    @Test(expected=Exception.class)
    public void testExceptionWhenNameAndLookupNotNull() {
        new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, "replace", "name", null, Boolean.valueOf(true));
    }

    @Test(expected=Exception.class)
    public void testExceptionWhenNameAndLookupNull() {
        new LookupDimensionSpec("dimName", "outputName", null, false, "replace", "", null, Boolean.valueOf(true));
    }

    @Test
    public void testGetDimension() {
        Assert.assertEquals((Object)"dimName", (Object)this.lookupDimSpec.getDimension());
    }

    @Test
    public void testGetOutputName() {
        Assert.assertEquals((Object)"outputName", (Object)this.lookupDimSpec.getOutputName());
    }

    public Object[] parametersForTestApply() {
        return new Object[]{new Object[]{new LookupDimensionSpec("dimName", "outputName", null, true, null, "lookupName", LOOKUP_REF_MANAGER, Boolean.valueOf(true)), STRING_MAP}, new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, true, null, null, null, Boolean.valueOf(true)), STRING_MAP}, new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, null, null, null, Boolean.valueOf(true)), ImmutableMap.of((Object)"not there", (Object)"")}, new Object[]{new LookupDimensionSpec("dimName", "outputName", null, false, null, "lookupName", LOOKUP_REF_MANAGER, Boolean.valueOf(true)), ImmutableMap.of((Object)"not there", (Object)"")}, new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, "Missing_value", null, null, Boolean.valueOf(true)), ImmutableMap.of((Object)"not there", (Object)"Missing_value")}, new Object[]{new LookupDimensionSpec("dimName", "outputName", null, false, "Missing_value", "lookupName", LOOKUP_REF_MANAGER, Boolean.valueOf(true)), ImmutableMap.of((Object)"not there", (Object)"Missing_value")}, new Object[]{new LookupDimensionSpec("dimName", "outputName", null, true, null, "lookupName", LOOKUP_REF_MANAGER, Boolean.valueOf(true)), ImmutableMap.of((Object)"not there", (Object)"not there")}, new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, true, null, "", null, Boolean.valueOf(true)), ImmutableMap.of((Object)"not there", (Object)"not there")}};
    }

    @Test
    @Parameters
    public void testApply(DimensionSpec dimensionSpec, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Assert.assertEquals((Object)Strings.emptyToNull((String)entry.getValue()), (Object)dimensionSpec.getExtractionFn().apply(entry.getKey()));
        }
    }

    public Object[] parametersForTestGetCacheKey() {
        return new Object[]{new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, true, null, null, null, Boolean.valueOf(true)), false}, new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, "Missing_value", null, null, Boolean.valueOf(true)), false}, new Object[]{new LookupDimensionSpec("dimName", "outputName2", MAP_LOOKUP_EXTRACTOR, false, null, null, null, Boolean.valueOf(true)), false}, new Object[]{new LookupDimensionSpec("dimName2", "outputName2", MAP_LOOKUP_EXTRACTOR, false, null, null, null, Boolean.valueOf(true)), false}, new Object[]{new LookupDimensionSpec("dimName", "outputName", MAP_LOOKUP_EXTRACTOR, false, null, null, null, Boolean.valueOf(true)), true}, new Object[]{new LookupDimensionSpec("dimName", "outputName", null, false, null, "name", LOOKUP_REF_MANAGER, Boolean.valueOf(true)), false}};
    }

    @Test
    @Parameters
    public void testGetCacheKey(DimensionSpec dimensionSpec, boolean expectedResult) {
        Assert.assertEquals((Object)expectedResult, (Object)Arrays.equals(this.lookupDimSpec.getCacheKey(), dimensionSpec.getCacheKey()));
    }

    @Test
    public void testPreservesOrdering() {
        Assert.assertFalse((boolean)this.lookupDimSpec.preservesOrdering());
    }

    @Test
    public void testIsOneToOne() {
        Assert.assertEquals((Object)this.lookupDimSpec.getExtractionFn().getExtractionType(), (Object)ExtractionFn.ExtractionType.ONE_TO_ONE);
    }

    static {
        EasyMock.expect((Object)LOOKUP_REF_MANAGER.get((String)EasyMock.eq((Object)"lookupName"))).andReturn((Object)new LookupExtractorFactoryContainer("v0", (LookupExtractorFactory)new MapLookupExtractorFactory(STRING_MAP, false))).anyTimes();
        EasyMock.replay((Object[])new Object[]{LOOKUP_REF_MANAGER});
    }
}

