/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.data.input.impl.CSVParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.TestQueryRunners;
import org.apache.hive.druid.io.druid.query.aggregation.AggregationTestHelper;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.ListFilteredDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.RegexFilteredDimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.spec.LegacySegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryConfig;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.apache.hive.druid.io.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultiValuedDimensionTest {
    private final AggregationTestHelper helper;
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;
    private IncrementalIndex incrementalIndex;
    private QueryableIndex queryableIndex;
    private File persistedSegmentDir;

    @Parameterized.Parameters(name="{0}")
    public static Collection<?> constructorFeeder() throws IOException {
        ArrayList constructors = Lists.newArrayList();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            constructors.add(new Object[]{config, TmpFileSegmentWriteOutMediumFactory.instance()});
            constructors.add(new Object[]{config, OffHeapMemorySegmentWriteOutMediumFactory.instance()});
        }
        return constructors;
    }

    public MultiValuedDimensionTest(GroupByQueryConfig config, SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws Exception {
        this.helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper((List<? extends Module>)ImmutableList.of(), config, null);
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
    }

    @Before
    public void setup() throws Exception {
        String[] rows;
        this.incrementalIndex = new IncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setMaxRowCount(5000).buildOnheap();
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)new CSVParseSpec(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"product", (Object)"tags")), null, null), "\t", (List)ImmutableList.of((Object)"timestamp", (Object)"product", (Object)"tags"), false, 0), "UTF-8");
        for (String row : rows = new String[]{"2011-01-12T00:00:00.000Z,product_1,t1\tt2\tt3", "2011-01-13T00:00:00.000Z,product_2,t3\tt4\tt5", "2011-01-14T00:00:00.000Z,product_3,t5\tt6\tt7", "2011-01-14T00:00:00.000Z,product_4"}) {
            this.incrementalIndex.add(parser.parse(row));
        }
        this.persistedSegmentDir = Files.createTempDir();
        TestHelper.getTestIndexMergerV9(this.segmentWriteOutMediumFactory).persist(this.incrementalIndex, this.persistedSegmentDir, new IndexSpec(), null);
        this.queryableIndex = TestHelper.getTestIndexIO(this.segmentWriteOutMediumFactory).loadIndex(this.persistedSegmentDir);
    }

    @Test
    public void testGroupByNoFilter() throws Exception {
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("tags", "tags")})).setAggregatorSpecs(Collections.singletonList(new CountAggregatorFactory("count"))).build();
        Sequence<Row> result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment("sid1", this.queryableIndex), (Object)new IncrementalIndexSegment(this.incrementalIndex, "sid2")), (Query)query);
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", null, "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t3", "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t4", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t5", "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t6", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t7", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, Sequences.toList(result, new ArrayList()), "");
    }

    @Test
    public void testGroupByWithDimFilter() throws Exception {
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("tags", "tags")})).setAggregatorSpecs(Collections.singletonList(new CountAggregatorFactory("count"))).setDimFilter((DimFilter)new SelectorDimFilter("tags", "t3", null)).build();
        Sequence<Row> result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment("sid1", this.queryableIndex), (Object)new IncrementalIndexSegment(this.incrementalIndex, "sid2")), (Query)query);
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t2", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t3", "count", 4L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t4", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t5", "count", 2L));
        TestHelper.assertExpectedObjects(expectedResults, Sequences.toList(result, new ArrayList()), "");
    }

    @Test
    public void testGroupByWithDimFilterAndWithFilteredDimSpec() throws Exception {
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new RegexFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("tags", "tags"), "t3")})).setAggregatorSpecs(Collections.singletonList(new CountAggregatorFactory("count"))).setDimFilter((DimFilter)new SelectorDimFilter("tags", "t3", null)).build();
        Sequence<Row> result = this.helper.runQueryOnSegmentsObjs((List<Segment>)ImmutableList.of((Object)new QueryableIndexSegment("sid1", this.queryableIndex), (Object)new IncrementalIndexSegment(this.incrementalIndex, "sid2")), (Query)query);
        List<Row> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "tags", "t3", "count", 4L));
        TestHelper.assertExpectedObjects(expectedResults, Sequences.toList(result, new ArrayList()), "");
    }

    @Test
    public void testTopNWithDimFilterAndWithFilteredDimSpec() throws Exception {
        TopNQuery query = new TopNQueryBuilder().dataSource("xx").granularity(Granularities.ALL).dimension((DimensionSpec)new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("tags", "tags"), (Set)ImmutableSet.of((Object)"t3"), null)).metric("count").intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Collections.singletonList(new CountAggregatorFactory("count"))).threshold(5).filters((DimFilter)new SelectorDimFilter("tags", "t3", null)).build();
        TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory(TestQueryRunners.getPool(), new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new QueryableIndexSegment("sid1", this.queryableIndex), null);
        HashMap context = Maps.newHashMap();
        Sequence result = runner.run(QueryPlus.wrap((Query)query), (Map)context);
        List<Result> expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"tags", (Object)"t3", (Object)"count", (Object)2L)))));
        TestHelper.assertExpectedObjects(expectedResults, Sequences.toList((Sequence)result, new ArrayList()), "");
    }

    @After
    public void cleanup() throws Exception {
        this.queryableIndex.close();
        this.incrementalIndex.close();
        FileUtils.deleteDirectory((File)this.persistedSegmentDir);
    }
}

