/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.http.client.pool;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.http.client.pool.ResourceContainer;
import org.apache.hive.druid.io.druid.java.util.http.client.pool.ResourceFactory;
import org.apache.hive.druid.io.druid.java.util.http.client.pool.ResourcePool;
import org.apache.hive.druid.io.druid.java.util.http.client.pool.ResourcePoolConfig;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourcePoolTest {
    ResourceFactory<String, String> resourceFactory;
    ResourcePool<String, String> pool;

    @Before
    public void setUp() throws Exception {
        this.resourceFactory = (ResourceFactory)EasyMock.createMock(ResourceFactory.class);
        EasyMock.replay((Object[])new Object[]{this.resourceFactory});
        this.pool = new ResourcePool(this.resourceFactory, new ResourcePoolConfig(2, TimeUnit.MINUTES.toMillis(4L)));
        EasyMock.verify((Object[])new Object[]{this.resourceFactory});
        EasyMock.reset((Object[])new Object[]{this.resourceFactory});
    }

    @Test
    public void testSanity() throws Exception {
        this.primePool();
        EasyMock.replay((Object[])new Object[]{this.resourceFactory});
    }

    private void primePool() {
        EasyMock.expect((Object)this.resourceFactory.generate((Object)"billy")).andAnswer((IAnswer)new StringIncrementingAnswer("billy")).times(2);
        EasyMock.expect((Object)this.resourceFactory.generate((Object)"sally")).andAnswer((IAnswer)new StringIncrementingAnswer("sally")).times(2);
        EasyMock.expect((Object)this.resourceFactory.isGood((Object)"billy0")).andReturn((Object)true).times(1);
        EasyMock.expect((Object)this.resourceFactory.isGood((Object)"sally0")).andReturn((Object)true).times(1);
        EasyMock.replay((Object[])new Object[]{this.resourceFactory});
        ResourceContainer billyString = this.pool.take((Object)"billy");
        ResourceContainer sallyString = this.pool.take((Object)"sally");
        Assert.assertEquals((Object)"billy0", (Object)billyString.get());
        Assert.assertEquals((Object)"sally0", (Object)sallyString.get());
        EasyMock.verify((Object[])new Object[]{this.resourceFactory});
        EasyMock.reset((Object[])new Object[]{this.resourceFactory});
        billyString.returnResource();
        sallyString.returnResource();
    }

    @Test
    public void testFailedResource() throws Exception {
        this.primePool();
        EasyMock.expect((Object)this.resourceFactory.isGood((Object)"billy1")).andReturn((Object)false).times(1);
        this.resourceFactory.close((Object)"billy1");
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.resourceFactory.generate((Object)"billy")).andReturn((Object)"billy2").times(1);
        EasyMock.replay((Object[])new Object[]{this.resourceFactory});
        ResourceContainer billy = this.pool.take((Object)"billy");
        Assert.assertEquals((Object)"billy2", (Object)billy.get());
        billy.returnResource();
        EasyMock.verify((Object[])new Object[]{this.resourceFactory});
        EasyMock.reset((Object[])new Object[]{this.resourceFactory});
    }

    @Test
    public void testFaultyFailedResourceReplacement() throws Exception {
        this.primePool();
        EasyMock.expect((Object)this.resourceFactory.isGood((Object)"billy1")).andReturn((Object)false).times(1);
        this.resourceFactory.close((Object)"billy1");
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.resourceFactory.generate((Object)"billy")).andThrow((Throwable)new ISE("where's billy?", new Object[0])).times(1);
        EasyMock.expect((Object)this.resourceFactory.isGood((Object)"billy0")).andReturn((Object)false).times(1);
        this.resourceFactory.close((Object)"billy0");
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.resourceFactory.generate((Object)"billy")).andThrow((Throwable)new ISE("where's billy?", new Object[0])).times(1);
        EasyMock.expect((Object)this.resourceFactory.generate((Object)"billy")).andReturn((Object)"billy2").times(1);
        EasyMock.replay((Object[])new Object[]{this.resourceFactory});
        IllegalStateException e1 = null;
        try {
            this.pool.take((Object)"billy");
        }
        catch (IllegalStateException e) {
            e1 = e;
        }
        Assert.assertNotNull((String)"exception", (Object)e1);
        Assert.assertEquals((Object)"where's billy?", (Object)e1.getMessage());
        IllegalStateException e2 = null;
        try {
            this.pool.take((Object)"billy");
        }
        catch (IllegalStateException e) {
            e2 = e;
        }
        Assert.assertNotNull((String)"exception", (Object)e2);
        Assert.assertEquals((Object)"where's billy?", (Object)e2.getMessage());
        ResourceContainer billy = this.pool.take((Object)"billy");
        Assert.assertEquals((Object)"billy2", (Object)billy.get());
        billy.returnResource();
        EasyMock.verify((Object[])new Object[]{this.resourceFactory});
        EasyMock.reset((Object[])new Object[]{this.resourceFactory});
    }

    @Test
    public void testTakeMoreThanAllowed() throws Exception {
        this.primePool();
        EasyMock.expect((Object)this.resourceFactory.isGood((Object)"billy1")).andReturn((Object)true).times(1);
        EasyMock.expect((Object)this.resourceFactory.isGood((Object)"billy0")).andReturn((Object)true).times(1);
        EasyMock.replay((Object[])new Object[]{this.resourceFactory});
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        CountDownLatch latch3 = new CountDownLatch(1);
        MyThread billy1Thread = new MyThread(latch1, "billy");
        billy1Thread.start();
        billy1Thread.waitForValueToBeGotten(1L, TimeUnit.SECONDS);
        MyThread billy0Thread = new MyThread(latch2, "billy");
        billy0Thread.start();
        billy0Thread.waitForValueToBeGotten(1L, TimeUnit.SECONDS);
        MyThread blockedThread = new MyThread(latch3, "billy");
        blockedThread.start();
        EasyMock.verify((Object[])new Object[]{this.resourceFactory});
        EasyMock.reset((Object[])new Object[]{this.resourceFactory});
        EasyMock.expect((Object)this.resourceFactory.isGood((Object)"billy0")).andReturn((Object)true).times(1);
        EasyMock.replay((Object[])new Object[]{this.resourceFactory});
        latch2.countDown();
        blockedThread.waitForValueToBeGotten(1L, TimeUnit.SECONDS);
        EasyMock.verify((Object[])new Object[]{this.resourceFactory});
        EasyMock.reset((Object[])new Object[]{this.resourceFactory});
        latch1.countDown();
        latch3.countDown();
        Assert.assertEquals((Object)"billy1", (Object)billy1Thread.getValue());
        Assert.assertEquals((Object)"billy0", (Object)billy0Thread.getValue());
        Assert.assertEquals((Object)"billy0", (Object)blockedThread.getValue());
    }

    @Test
    public void testCloseUnblocks() throws InterruptedException {
        this.primePool();
        EasyMock.expect((Object)this.resourceFactory.isGood((Object)"billy1")).andReturn((Object)true).times(1);
        EasyMock.expect((Object)this.resourceFactory.isGood((Object)"billy0")).andReturn((Object)true).times(1);
        this.resourceFactory.close((Object)"sally1");
        EasyMock.expectLastCall().times(1);
        this.resourceFactory.close((Object)"sally0");
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.resourceFactory});
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        CountDownLatch latch3 = new CountDownLatch(1);
        MyThread billy1Thread = new MyThread(latch1, "billy");
        billy1Thread.start();
        billy1Thread.waitForValueToBeGotten(1L, TimeUnit.SECONDS);
        MyThread billy0Thread = new MyThread(latch2, "billy");
        billy0Thread.start();
        billy0Thread.waitForValueToBeGotten(1L, TimeUnit.SECONDS);
        MyThread blockedThread = new MyThread(latch3, "billy");
        blockedThread.start();
        blockedThread.waitForValueToBeGotten(1L, TimeUnit.SECONDS);
        this.pool.close();
        EasyMock.verify((Object[])new Object[]{this.resourceFactory});
        EasyMock.reset((Object[])new Object[]{this.resourceFactory});
        EasyMock.replay((Object[])new Object[]{this.resourceFactory});
        latch2.countDown();
        blockedThread.waitForValueToBeGotten(1L, TimeUnit.SECONDS);
        EasyMock.verify((Object[])new Object[]{this.resourceFactory});
        EasyMock.reset((Object[])new Object[]{this.resourceFactory});
        latch1.countDown();
        latch3.countDown();
        Assert.assertEquals((Object)"billy1", (Object)billy1Thread.getValue());
        Assert.assertEquals((Object)"billy0", (Object)billy0Thread.getValue());
        blockedThread.join();
        Assert.assertEquals(null, (Object)blockedThread.getValue());
    }

    @Test
    public void testTimedOutResource() throws Exception {
        this.resourceFactory = (ResourceFactory)EasyMock.createMock(ResourceFactory.class);
        this.pool = new ResourcePool(this.resourceFactory, new ResourcePoolConfig(2, TimeUnit.MILLISECONDS.toMillis(10L)));
        EasyMock.expect((Object)this.resourceFactory.generate((Object)"billy")).andAnswer((IAnswer)new StringIncrementingAnswer("billy")).times(2);
        EasyMock.expect((Object)this.resourceFactory.isGood((Object)"billy0")).andReturn((Object)true).times(1);
        EasyMock.replay((Object[])new Object[]{this.resourceFactory});
        ResourceContainer billyString = this.pool.take((Object)"billy");
        Assert.assertEquals((Object)"billy0", (Object)billyString.get());
        EasyMock.verify((Object[])new Object[]{this.resourceFactory});
        EasyMock.reset((Object[])new Object[]{this.resourceFactory});
        billyString.returnResource();
        Thread.sleep(100L);
        EasyMock.expect((Object)this.resourceFactory.generate((Object)"billy")).andReturn((Object)"billy1").times(1);
        this.resourceFactory.close((Object)"billy1");
        EasyMock.expect((Object)this.resourceFactory.isGood((Object)"billy1")).andReturn((Object)true).times(1);
        EasyMock.replay((Object[])new Object[]{this.resourceFactory});
        ResourceContainer billy = this.pool.take((Object)"billy");
        Assert.assertEquals((Object)"billy1", (Object)billy.get());
        billy.returnResource();
        EasyMock.verify((Object[])new Object[]{this.resourceFactory});
        EasyMock.reset((Object[])new Object[]{this.resourceFactory});
    }

    private class MyThread
    extends Thread {
        private final CountDownLatch gotValueLatch = new CountDownLatch(1);
        private final CountDownLatch latch1;
        private String resourceName;
        volatile String value = null;

        public MyThread(CountDownLatch latch1, String resourceName) {
            this.latch1 = latch1;
            this.resourceName = resourceName;
        }

        @Override
        public void run() {
            ResourceContainer resourceContainer = ResourcePoolTest.this.pool.take((Object)this.resourceName);
            this.value = (String)resourceContainer.get();
            this.gotValueLatch.countDown();
            try {
                this.latch1.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resourceContainer.returnResource();
        }

        public String getValue() {
            return this.value;
        }

        public void waitForValueToBeGotten(long length, TimeUnit timeUnit) throws InterruptedException {
            this.gotValueLatch.await(length, timeUnit);
        }
    }

    private static class StringIncrementingAnswer
    implements IAnswer<String> {
        int count = 0;
        private String string;

        public StringIncrementingAnswer(String string) {
            this.string = string;
        }

        public String answer() throws Throwable {
            return this.string + this.count++;
        }
    }
}

