/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.parsers;

import java.util.TimeZone;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParserUtils;
import org.apache.hive.druid.io.druid.java.util.common.parsers.TimestampParser;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TimestampParserTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testStripQuotes() throws Exception {
        Assert.assertEquals((Object)"hello world", (Object)ParserUtils.stripQuotes((String)"\"hello world\""));
        Assert.assertEquals((Object)"hello world", (Object)ParserUtils.stripQuotes((String)"    \"    hello world   \"    "));
    }

    @Test
    public void testExtractTimeZone() throws Exception {
        Assert.assertEquals((Object)DateTimeZone.UTC, (Object)ParserUtils.getDateTimeZone((String)"UTC"));
        Assert.assertEquals((Object)DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("PST")), (Object)ParserUtils.getDateTimeZone((String)"PST"));
        Assert.assertNull((Object)ParserUtils.getDateTimeZone((String)"Hello"));
        Assert.assertNull((Object)ParserUtils.getDateTimeZone((String)"AEST"));
        Assert.assertEquals((Object)DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("Australia/Hobart")), (Object)ParserUtils.getDateTimeZone((String)"Australia/Hobart"));
        Assert.assertNull((Object)ParserUtils.getDateTimeZone((String)""));
        Assert.assertNull((Object)ParserUtils.getDateTimeZone(null));
    }

    @Test
    public void testAuto() throws Exception {
        Function parser = TimestampParser.createObjectTimestampParser((String)"auto");
        Assert.assertEquals((Object)DateTimes.of((String)"2009-02-13T23:31:30Z"), (Object)parser.apply((Object)"1234567890000"));
        Assert.assertEquals((Object)DateTimes.of((String)"2009-02-13T23:31:30Z"), (Object)parser.apply((Object)"2009-02-13T23:31:30Z"));
        Assert.assertEquals((Object)DateTimes.of((String)"2009-02-13T23:31:30-08:00"), (Object)parser.apply((Object)"2009-02-13T23:31:30-08:00"));
        Assert.assertEquals((Object)DateTimes.of((String)"2009-02-13T23:31:30Z"), (Object)parser.apply((Object)"2009-02-13 23:31:30Z"));
        Assert.assertEquals((Object)DateTimes.of((String)"2009-02-13T23:31:30-08:00"), (Object)parser.apply((Object)"2009-02-13 23:31:30-08:00"));
        Assert.assertEquals((Object)DateTimes.of((String)"2009-02-13T00:00:00Z"), (Object)parser.apply((Object)"2009-02-13"));
        Assert.assertEquals((Object)DateTimes.of((String)"2009-02-13T00:00:00Z"), (Object)parser.apply((Object)"\"2009-02-13\""));
        Assert.assertEquals((Object)DateTimes.of((String)"2009-02-13T23:31:30Z"), (Object)parser.apply((Object)"2009-02-13 23:31:30"));
        Assert.assertEquals((Object)DateTimes.of((String)"2009-02-13T23:31:30Z"), (Object)parser.apply((Object)1234567890000L));
        Assert.assertEquals((Object)DateTimes.of((String)"2009-02-13T23:31:30Z"), (Object)parser.apply((Object)"2009-02-13 23:31:30 UTC"));
        Assert.assertEquals((Object)new DateTime((Object)"2009-02-13T23:31:30Z", DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("PST"))), (Object)parser.apply((Object)"2009-02-13 23:31:30 PST"));
        Assert.assertEquals((Object)new DateTime((Object)"2009-02-13T23:31:30Z", DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("PST"))), (Object)parser.apply((Object)"\"2009-02-13 23:31:30 PST\""));
    }

    @Test
    public void testAutoNull() throws Exception {
        Function parser = TimestampParser.createObjectTimestampParser((String)"auto");
        this.expectedException.expect(NullPointerException.class);
        parser.apply(null);
    }

    @Test
    public void testAutoInvalid() throws Exception {
        Function parser = TimestampParser.createObjectTimestampParser((String)"auto");
        this.expectedException.expect(IllegalArgumentException.class);
        parser.apply((Object)"asdf");
    }

    @Test
    public void testRuby() throws Exception {
        Function parser = TimestampParser.createObjectTimestampParser((String)"ruby");
        Assert.assertEquals((Object)DateTimes.of((String)"2013-01-16T15:41:47+01:00"), (Object)parser.apply((Object)"1358347307.435447"));
        Assert.assertEquals((Object)DateTimes.of((String)"2013-01-16T15:41:47+01:00"), (Object)parser.apply((Object)1.358347307435447E9));
    }

    @Test
    public void testNano() throws Exception {
        String timeNsStr = "1427504794977098494";
        DateTime expectedDt = DateTimes.of((String)"2015-3-28T01:06:34.977Z");
        Function parser = TimestampParser.createObjectTimestampParser((String)"nano");
        Assert.assertEquals((String)"Incorrect truncation of nanoseconds -> milliseconds", (Object)expectedDt, (Object)parser.apply((Object)timeNsStr));
        expectedDt = DateTimes.of((String)"1970-1-1T00:00:00.000Z");
        Assert.assertEquals((Object)expectedDt, (Object)parser.apply((Object)"999999"));
        Assert.assertEquals((Object)expectedDt, (Object)parser.apply((Object)"0"));
        Assert.assertEquals((Object)expectedDt, (Object)parser.apply((Object)"0000"));
        Assert.assertEquals((Object)expectedDt, (Object)parser.apply((Object)999999L));
    }

    @Test
    public void testTimeStampParserWithQuotes() throws Exception {
        DateTime d = new DateTime(1994, 11, 9, 4, 0, DateTimeZone.forOffsetHours((int)-8));
        Function parser = TimestampParser.createTimestampParser((String)"EEE MMM dd HH:mm:ss z yyyy");
        Assert.assertEquals((long)d.getMillis(), (long)((DateTime)parser.apply((Object)" \" Wed Nov 9 04:00:00 PST 1994 \"  ")).getMillis());
    }

    @Test
    public void testTimeStampParserWithShortTimeZone() throws Exception {
        DateTime d = new DateTime(1994, 11, 9, 4, 0, DateTimeZone.forOffsetHours((int)-8));
        Function parser = TimestampParser.createTimestampParser((String)"EEE MMM dd HH:mm:ss z yyyy");
        Assert.assertEquals((long)d.getMillis(), (long)((DateTime)parser.apply((Object)"Wed Nov 9 04:00:00 PST 1994")).getMillis());
    }

    @Test
    public void testTimeStampParserWithLongTimeZone() throws Exception {
        long millis1 = new DateTime(1994, 11, 9, 4, 0, DateTimeZone.forOffsetHours((int)-8)).getMillis();
        long millis2 = new DateTime(1994, 11, 9, 4, 0, DateTimeZone.forOffsetHours((int)-6)).getMillis();
        Function parser = TimestampParser.createTimestampParser((String)"EEE MMM dd HH:mm:ss zZ z yyyy");
        Assert.assertEquals((long)millis1, (long)((DateTime)parser.apply((Object)"Wed Nov 9 04:00:00 GMT-0800 PST 1994")).getMillis());
        Assert.assertEquals((long)millis2, (long)((DateTime)parser.apply((Object)"Wed Nov 9 04:00:00 GMT-0600 CST 1994")).getMillis());
        Assert.assertEquals((long)millis1, (long)((DateTime)parser.apply((Object)"Wed Nov 9 04:00:00 UTC-0800 PST 1994")).getMillis());
        Assert.assertEquals((long)millis2, (long)((DateTime)parser.apply((Object)"Wed Nov 9 04:00:00 UTC-0600 CST 1994")).getMillis());
        parser = TimestampParser.createTimestampParser((String)"EEE MMM dd HH:mm:ss zZ yyyy");
        Assert.assertEquals((long)millis1, (long)((DateTime)parser.apply((Object)"Wed Nov 9 04:00:00 GMT-0800 1994")).getMillis());
        Assert.assertEquals((long)millis2, (long)((DateTime)parser.apply((Object)"Wed Nov 9 04:00:00 GMT-0600 1994")).getMillis());
        Assert.assertEquals((long)millis1, (long)((DateTime)parser.apply((Object)"Wed Nov 9 04:00:00 UTC-0800 1994")).getMillis());
        Assert.assertEquals((long)millis2, (long)((DateTime)parser.apply((Object)"Wed Nov 9 04:00:00 UTC-0600 1994")).getMillis());
    }

    @Test
    public void testTimeZoneAtExtremeLocations() throws Exception {
        Function parser = TimestampParser.createTimestampParser((String)"EEE MMM dd yy HH:mm:ss zZ z");
        Assert.assertEquals((long)new DateTime(2005, 1, 22, 13, 0, DateTimeZone.forOffsetHours((int)-6)).getMillis(), (long)((DateTime)parser.apply((Object)"Sat Jan 22 05 13:00:00 GMT-0600 CST")).getMillis());
        parser = TimestampParser.createTimestampParser((String)"zZ z EEE MMM dd yy HH:mm:ss");
        Assert.assertEquals((long)new DateTime(2005, 1, 22, 13, 0, DateTimeZone.forOffsetHours((int)-6)).getMillis(), (long)((DateTime)parser.apply((Object)"GMT-0600 CST Sat Jan 22 05 13:00:00")).getMillis());
    }

    @Test
    public void testJodaSymbolInsideLiteral() throws Exception {
        DateTime d = new DateTime(1994, 11, 9, 4, 0, DateTimeZone.forOffsetHours((int)-8));
        Assert.assertEquals((long)d.getMillis(), (long)((DateTime)TimestampParser.createTimestampParser((String)"EEE MMM dd HH:mm:ss z yyyy 'helloz'").apply((Object)"Wed Nov 9 04:00:00 PST 1994 helloz")).getMillis());
        Assert.assertEquals((long)d.getMillis(), (long)((DateTime)TimestampParser.createTimestampParser((String)"EEE MMM dd HH:mm:ss 'helloz' z yyyy 'hello'").apply((Object)"Wed Nov 9 04:00:00 helloz PST 1994 hello")).getMillis());
    }
}

