/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.guava;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.SequenceTestHelper;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.java.util.common.guava.UnsupportedSequence;
import org.junit.Assert;
import org.junit.Test;

public class WrappingSequenceTest {
    @Test
    public void testSanity() throws Exception {
        final AtomicInteger closedCounter = new AtomicInteger(0);
        Closeable closeable = new Closeable(){

            @Override
            public void close() throws IOException {
                closedCounter.incrementAndGet();
            }
        };
        List<Integer> nums = Arrays.asList(1, 2, 3, 4, 5);
        SequenceTestHelper.testAll((Sequence<Integer>)Sequences.withBaggage((Sequence)Sequences.simple(nums), (Closeable)closeable), nums);
        Assert.assertEquals((long)3L, (long)closedCounter.get());
        closedCounter.set(0);
        SequenceTestHelper.testClosed(closedCounter, (Sequence<Integer>)Sequences.withBaggage((Sequence)new UnsupportedSequence(), (Closeable)closeable));
    }

    @Test
    public void testConsistentCloseOrder() {
        final AtomicInteger closed1 = new AtomicInteger();
        final AtomicInteger closed2 = new AtomicInteger();
        final AtomicInteger counter = new AtomicInteger();
        Sequence sequence = Sequences.withBaggage((Sequence)Sequences.withBaggage((Sequence)Sequences.simple(Arrays.asList(1, 2, 3)), (Closeable)new Closeable(){

            @Override
            public void close() throws IOException {
                closed1.set(counter.incrementAndGet());
            }
        }), (Closeable)new Closeable(){

            @Override
            public void close() throws IOException {
                closed2.set(counter.incrementAndGet());
            }
        });
        Sequences.toList((Sequence)sequence, new ArrayList());
        Assert.assertEquals((long)1L, (long)closed1.get());
        Assert.assertEquals((long)2L, (long)closed2.get());
        Sequence yieldingSequence = Sequences.limit((Sequence)sequence, (int)1);
        Sequences.toList((Sequence)yieldingSequence, new ArrayList());
        Assert.assertEquals((long)3L, (long)closed1.get());
        Assert.assertEquals((long)4L, (long)closed2.get());
    }
}

